/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.upload;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import org.apache.log4j.Logger;

public class SkipFilter
extends AbstractUploadFilter {
    private static final Logger log = Logger.getLogger(SkipFilter.class);

    public SkipFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session) {
        this(symlinkResolver, session, new UploadFilterOptions());
    }

    public SkipFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options) {
        super(symlinkResolver, session, options);
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (parent.isExists() && local.isFile() && this.find.withCache(this.cache).find(file)) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skip file %s", file));
            }
            return false;
        }
        return super.accept(file, local, parent);
    }
}

