/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.Set;

public class VaultRegistryLocationFeature
implements Location {
    private final Session<?> session;
    private final Location proxy;
    private final VaultRegistry registry;

    public VaultRegistryLocationFeature(Session<?> session, Location proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Set<Location.Name> getLocations() {
        return this.proxy.getLocations();
    }

    @Override
    public Location.Name getLocation(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Location.class, this.proxy).getLocation(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryLocationFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

