/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.shared.DefaultAclFeature;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.BucketAccessControls;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.ObjectAccessControls;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class GoogleStorageAccessControlListFeature
extends DefaultAclFeature
implements AclPermission {
    private static final Logger log = Logger.getLogger(GoogleStorageAccessControlListFeature.class);
    private final PathContainerService containerService = new GoogleStoragePathContainerService();
    private final GoogleStorageSession session;

    public GoogleStorageAccessControlListFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public Acl getPermission(Path file) throws BackgroundException {
        try {
            Acl acl = new Acl();
            if (this.containerService.isContainer(file)) {
                BucketAccessControls controls = (BucketAccessControls)((Storage)this.session.getClient()).bucketAccessControls().list(this.containerService.getContainer(file).getName()).execute();
                for (BucketAccessControl control : controls.getItems()) {
                    String entity = control.getEntity();
                    acl.addAll(this.toUser(entity, control.getEmail()), new Acl.Role[]{new Acl.Role(control.getRole())});
                }
            } else {
                ObjectAccessControls controls = (ObjectAccessControls)((Storage)this.session.getClient()).objectAccessControls().list(this.containerService.getContainer(file).getName(), this.containerService.getKey(file)).execute();
                for (ObjectAccessControl control : controls.getItems()) {
                    String entity = control.getEntity();
                    acl.addAll(this.toUser(entity, control.getEmail()), new Acl.Role[]{this.toRole(control)});
                }
            }
            return acl;
        }
        catch (IOException e) {
            BackgroundException failure = new GoogleStorageExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            if (file.isPlaceholder() && failure instanceof NotfoundException) {
                return Acl.EMPTY;
            }
            if (failure instanceof InteroperabilityException) {
                return Acl.EMPTY;
            }
            throw failure;
        }
    }

    protected Acl.User toUser(String entity, String email) {
        if (entity.startsWith("user-")) {
            if (StringUtils.isNotBlank((CharSequence)email)) {
                return new Acl.EmailUser(StringUtils.substringAfter((String)entity, (String)"user-"));
            }
        } else {
            if (entity.startsWith("group-")) {
                if (StringUtils.isNotBlank((CharSequence)email)) {
                    return new Acl.EmailGroupUser(StringUtils.substringAfter((String)entity, (String)"group-"));
                }
                return new Acl.GroupUser(StringUtils.substringAfter((String)entity, (String)"group-"));
            }
            if (entity.startsWith("domain-")) {
                return new Acl.DomainUser(StringUtils.substringAfter((String)entity, (String)"domain-"));
            }
        }
        switch (entity) {
            case "allUsers": {
                return new Acl.GroupUser("AllUsers", false);
            }
            case "allAuthenticatedUsers": {
                return new Acl.GroupUser("AllAuthenticatedUsers", false);
            }
        }
        return new Acl.CanonicalUser(entity);
    }

    protected Acl.Role toRole(ObjectAccessControl control) {
        switch (control.getRole()) {
            case "READER": {
                return new Acl.Role("READ");
            }
            case "OWNER": {
                return new Acl.Role("FULL_CONTROL");
            }
        }
        return new Acl.Role(control.getRole());
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        try {
            if (this.containerService.isContainer(file)) {
                List<BucketAccessControl> bucketAccessControls = this.toBucketAccessControl(acl);
                ((Storage)this.session.getClient()).buckets().update(this.containerService.getContainer(file).getName(), new Bucket().setAcl(bucketAccessControls)).execute();
            } else {
                List<ObjectAccessControl> objectAccessControls = this.toObjectAccessControl(acl);
                ((Storage)this.session.getClient()).objects().update(this.containerService.getContainer(file).getName(), this.containerService.getKey(file), new StorageObject().setAcl(objectAccessControls)).execute();
            }
        }
        catch (IOException e) {
            BackgroundException failure = new GoogleStorageExceptionMappingService().map("Cannot change permissions of {0}", e, file);
            if (file.isPlaceholder() && failure instanceof NotfoundException) {
                return;
            }
            throw failure;
        }
    }

    protected List<BucketAccessControl> toBucketAccessControl(Acl acl) {
        ArrayList<BucketAccessControl> list = new ArrayList<BucketAccessControl>();
        for (Acl.UserAndRole userAndRole : acl.asList()) {
            if (!userAndRole.isValid()) continue;
            BucketAccessControl control = new BucketAccessControl();
            switch (userAndRole.getRole().getName()) {
                case "READ": {
                    control.setRole("READER");
                    break;
                }
                case "FULL_CONTROL": {
                    control.setRole("OWNER");
                }
            }
            if (userAndRole.getUser() instanceof Acl.EmailUser) {
                control.setEntity(String.format("user-%s", userAndRole.getUser().getIdentifier()));
                control.setEmail(userAndRole.getUser().getIdentifier());
            } else if (userAndRole.getUser() instanceof Acl.GroupUser) {
                if (userAndRole.getUser().getIdentifier().equals("AllUsers")) {
                    control.setEntity("allUsers");
                } else if (userAndRole.getUser().getIdentifier().equals("AllAuthenticatedUsers")) {
                    control.setEntity("allAuthenticatedUsers");
                } else {
                    control.setEntity(String.format("group-%s", userAndRole.getUser().getIdentifier()));
                }
            } else if (userAndRole.getUser() instanceof Acl.DomainUser) {
                control.setEntity(String.format("domain-%s", userAndRole.getUser().getIdentifier()));
                control.setDomain(userAndRole.getUser().getIdentifier());
            } else if (userAndRole.getUser() instanceof Acl.CanonicalUser) {
                control.setEntity(userAndRole.getUser().getIdentifier());
                control.setEmail(userAndRole.getUser().getIdentifier());
            } else if (userAndRole.getUser() instanceof Acl.EmailGroupUser) {
                control.setEntity(String.format("group-%s", userAndRole.getUser().getIdentifier()));
                control.setEmail(userAndRole.getUser().getIdentifier());
            } else {
                log.warn((Object)String.format("Unsupported user %s", userAndRole.getUser()));
            }
            list.add(control);
        }
        return list;
    }

    protected List<ObjectAccessControl> toObjectAccessControl(Acl acl) {
        ArrayList<ObjectAccessControl> list = new ArrayList<ObjectAccessControl>();
        for (Acl.UserAndRole userAndRole : acl.asList()) {
            if (!userAndRole.isValid()) continue;
            ObjectAccessControl control = new ObjectAccessControl();
            switch (userAndRole.getRole().getName()) {
                case "READ": {
                    control.setRole("READER");
                    break;
                }
                case "FULL_CONTROL": {
                    control.setRole("OWNER");
                }
            }
            if (userAndRole.getUser() instanceof Acl.EmailUser) {
                control.setEntity(String.format("user-%s", userAndRole.getUser().getIdentifier()));
                control.setEmail(userAndRole.getUser().getIdentifier());
            } else if (userAndRole.getUser() instanceof Acl.GroupUser) {
                if (userAndRole.getUser().getIdentifier().equals("AllUsers")) {
                    control.setEntity("allUsers");
                } else if (userAndRole.getUser().getIdentifier().equals("AllAuthenticatedUsers")) {
                    control.setEntity("allAuthenticatedUsers");
                } else {
                    control.setEntity(String.format("group-%s", userAndRole.getUser().getIdentifier()));
                }
            } else if (userAndRole.getUser() instanceof Acl.DomainUser) {
                control.setEntity(String.format("domain-%s", userAndRole.getUser().getIdentifier()));
                control.setDomain(userAndRole.getUser().getIdentifier());
            } else if (userAndRole.getUser() instanceof Acl.CanonicalUser) {
                control.setEntity(userAndRole.getUser().getIdentifier());
                control.setEmail(userAndRole.getUser().getIdentifier());
            } else if (userAndRole.getUser() instanceof Acl.EmailGroupUser) {
                control.setEntity(String.format("group-%s", userAndRole.getUser().getIdentifier()));
                control.setEmail(userAndRole.getUser().getIdentifier());
            } else {
                log.warn((Object)String.format("Unsupported user %s", userAndRole.getUser()));
            }
            list.add(control);
        }
        return list;
    }

    public List<Acl.User> getAvailableAclUsers() {
        ArrayList<Acl.User> users = new ArrayList<Acl.User>(Arrays.asList(new Acl.CanonicalUser(), new Acl.GroupUser("AllAuthenticatedUsers", false), new Acl.GroupUser("AllUsers", false)));
        users.add((Acl.User)new Acl.EmailUser(){

            public String getPlaceholder() {
                return LocaleFactory.localizedString((String)"Google Account Email Address", (String)"S3");
            }
        });
        users.add((Acl.User)new Acl.DomainUser(""){

            public String getPlaceholder() {
                return LocaleFactory.localizedString((String)"Google Apps Domain", (String)"S3");
            }
        });
        users.add((Acl.User)new Acl.EmailGroupUser("", true){

            public String getPlaceholder() {
                return LocaleFactory.localizedString((String)"Google Group Email Address", (String)"S3");
            }
        });
        return users;
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return new ArrayList<Acl.Role>(Arrays.asList(new Acl.Role("FULL_CONTROL"), new Acl.Role("READ")));
    }
}

