/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.Tag;

public class DataObjInpForMcoll
extends AbstractIRODSPackingInstruction {
    public static final int MCOLL_AN = 630;
    public static final String COLL_TYPE_LINK = "linkPoint";
    public static final String COLL_TYPE_MSSO = "mssoStructFile";
    public static final String COLL_TYPE_MOUNT = "mountPoint";
    public static final String COLL_TYPE_HAAW = "haawStructFile";
    public static final String COLL_TYPE_TAR = "tarStructFile";
    private final String sourceFileAbsolutePath;
    private final String targetFileAbsolutePath;
    private final String collectionType;
    private final String destResourceName;
    private int operationType = 0;

    public static DataObjInpForMcoll instanceForMSSOMount(String microServiceSourceFile, String targetFileAbsolutePath, String destRescName) {
        return new DataObjInpForMcoll(microServiceSourceFile, targetFileAbsolutePath, COLL_TYPE_MSSO, destRescName);
    }

    public static DataObjInpForMcoll instanceForFileSystemMount(String localFileSystemAbsolutePath, String irodsMountedCollectionAbsolutePath, String destRescName) {
        return new DataObjInpForMcoll(localFileSystemAbsolutePath, irodsMountedCollectionAbsolutePath, COLL_TYPE_MOUNT, destRescName);
    }

    public static DataObjInpForMcoll instanceForSoftLinkMount(String sourceFileAbsolutePath, String targetFileAbsolutePath, String destRescName) {
        return new DataObjInpForMcoll(sourceFileAbsolutePath, targetFileAbsolutePath, COLL_TYPE_LINK, destRescName);
    }

    private DataObjInpForMcoll(String sourceFileAbsolutePath, String targetFileAbsolutePath, String collectionType, String destRescName) {
        if (sourceFileAbsolutePath == null || sourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("sourceFileAbsolutePath is null or empty");
        }
        if (targetFileAbsolutePath == null || targetFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("targetFileAbsolutePath is null or empty");
        }
        if (collectionType == null || collectionType.isEmpty()) {
            throw new IllegalArgumentException("collectionType is null or empty");
        }
        if (destRescName == null) {
            throw new IllegalArgumentException("destRescName is null, set to blank if unused");
        }
        this.sourceFileAbsolutePath = sourceFileAbsolutePath;
        this.targetFileAbsolutePath = targetFileAbsolutePath;
        this.collectionType = collectionType;
        this.destResourceName = destRescName;
        this.setApiNumber(630);
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag("DataObjInp_PI", new Tag[]{new Tag("objPath", this.targetFileAbsolutePath), new Tag("createMode", 0), new Tag("openFlags", 0), new Tag("offset", 0), new Tag("dataSize", 0), new Tag("numThreads", 0), new Tag("oprType", this.operationType)});
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        kvps.add(KeyValuePair.instance("collectionType", this.collectionType));
        if (this.collectionType.equals(COLL_TYPE_MSSO)) {
            kvps.add(KeyValuePair.instance("dataType", "msso file"));
        }
        kvps.add(KeyValuePair.instance("destRescName", this.destResourceName));
        kvps.add(KeyValuePair.instance("filePath", this.sourceFileAbsolutePath));
        message.addTag(this.createKeyValueTag(kvps));
        return message;
    }
}

