/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.IRodsPI;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.query.GenQueryField;
import org.irods.jargon.core.query.GenQueryOrderByField;
import org.irods.jargon.core.query.GenQuerySelectField;
import org.irods.jargon.core.query.TranslatedGenQueryCondition;
import org.irods.jargon.core.query.TranslatedIRODSGenQuery;

public class GenQueryInp
extends AbstractIRODSPackingInstruction
implements IRodsPI {
    private final TranslatedIRODSGenQuery translatedIRODSQuery;
    private final int continueIndex;
    private final int partialStartIndex;
    private final int maxRowCount;
    public static final String PI_TAG = "GenQueryInp_PI";
    public static final String MAX_ROWS = "maxRows";
    public static final String CONTINUE_INX = "continueInx";
    public static final String PARTIAL_START_INDEX = "partialStartIndex";
    public static final String IILEN = "iiLen";
    public static final String ISLEN = "isLen";
    public static final String INX = "inx";
    public static final String IVALUE = "ivalue";
    public static final String SVALUE = "svalue";
    public static final String INX_VAL_PAIR_PI = "InxValPair_PI";
    public static final String INX_IVAL_PAIR_PI = "InxIvalPair_PI";
    public static final int ORDER_BY = 1024;
    public static final int ORDER_BY_DESC = 2048;
    public static final int UPPER_CASE_WHERE = 512;
    public static final int RETURN_TOTAL_ROW_COUNT = 32;
    public static final int API_NBR = 702;
    private String zoneName = null;

    public static GenQueryInp instance(TranslatedIRODSGenQuery translatedIRODSQuery, int continueIndex, String zoneName) throws JargonException {
        return new GenQueryInp(translatedIRODSQuery, continueIndex, 0, zoneName);
    }

    public static GenQueryInp instanceForCloseQuery(TranslatedIRODSGenQuery translatedIRODSQuery, int continueIndex) {
        return new GenQueryInp(translatedIRODSQuery, continueIndex);
    }

    public static GenQueryInp instanceWithPartialStart(TranslatedIRODSGenQuery translatedIRODSQuery, int partialStartIndex, String zoneName) throws JargonException {
        return new GenQueryInp(translatedIRODSQuery, 0, partialStartIndex, zoneName);
    }

    private GenQueryInp(TranslatedIRODSGenQuery translatedIRODSGenQuery, int continueIndex) {
        if (translatedIRODSGenQuery == null) {
            throw new IllegalArgumentException("translatedIRODSGenQuery is null");
        }
        if (continueIndex <= 0) {
            throw new IllegalArgumentException("continueIndex must be > 0 when sending a close");
        }
        this.translatedIRODSQuery = translatedIRODSGenQuery;
        this.continueIndex = continueIndex;
        this.partialStartIndex = 0;
        this.maxRowCount = -1;
    }

    private GenQueryInp(TranslatedIRODSGenQuery translatedIRODSQuery, int continueIndex, int partialStartIndex, String zoneName) throws JargonException {
        if (translatedIRODSQuery == null) {
            throw new IllegalArgumentException("irodsQuery is null");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partialStartIndex is less than 0");
        }
        if (continueIndex < 0) {
            throw new IllegalArgumentException("continue Index must be 0 or greater");
        }
        this.translatedIRODSQuery = translatedIRODSQuery;
        this.continueIndex = continueIndex;
        this.partialStartIndex = partialStartIndex;
        this.maxRowCount = translatedIRODSQuery.getIrodsQuery().getNumberOfResultsDesired();
        this.setApiNumber(702);
        this.zoneName = zoneName;
    }

    public int getContinueIndex() {
        return this.continueIndex;
    }

    public TranslatedIRODSGenQuery getTranslatedIRODSQuery() throws JargonException {
        if (this.translatedIRODSQuery == null) {
            throw new IllegalArgumentException("no translated query");
        }
        return this.translatedIRODSQuery;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(MAX_ROWS, this.maxRowCount), new Tag(CONTINUE_INX, this.continueIndex), new Tag(PARTIAL_START_INDEX, this.partialStartIndex)});
        int optionVal = 0;
        if (!this.getTranslatedIRODSQuery().isDistinct()) {
            ++optionVal;
        }
        if (this.getTranslatedIRODSQuery().isUpperCase()) {
            optionVal += 512;
        }
        if (this.getTranslatedIRODSQuery().isComputeTotalRowCount()) {
            optionVal += 32;
        }
        message.addTag(new Tag("options", optionVal));
        if (this.zoneName == null || this.zoneName.isEmpty()) {
            message.addTag(Tag.createKeyValueTag(null));
        } else {
            message.addTag(Tag.createKeyValueTag("zone", this.zoneName));
        }
        Tag[] subTags = null;
        int[] orderByFlags = new int[this.translatedIRODSQuery.getSelectFields().size()];
        int j = 1;
        int k = 0;
        subTags = new Tag[this.translatedIRODSQuery.getSelectFields().size() * 2 + 1];
        subTags[0] = new Tag(IILEN, this.translatedIRODSQuery.getSelectFields().size());
        for (GenQuerySelectField select : this.translatedIRODSQuery.getSelectFields()) {
            subTags[j] = new Tag(INX, select.getSelectFieldNumericTranslation());
            int orderByFlag = 0;
            for (GenQueryOrderByField orderBy : this.translatedIRODSQuery.getOrderByFields()) {
                if (!orderBy.getSelectFieldNumericTranslation().equals(select.getSelectFieldNumericTranslation())) continue;
                if (orderBy.getOrderByType() == GenQueryOrderByField.OrderByType.ASC) {
                    orderByFlag = 1024;
                    break;
                }
                if (orderBy.getOrderByType() != GenQueryOrderByField.OrderByType.DESC) break;
                orderByFlag = 2048;
                break;
            }
            orderByFlags[k++] = orderByFlag;
            ++j;
        }
        k = 0;
        for (GenQuerySelectField select : this.translatedIRODSQuery.getSelectFields()) {
            int val = 1;
            if (select.getSelectFieldType() == GenQueryField.SelectFieldTypes.FIELD) {
                if ((val = orderByFlags[k++]) == 0) {
                    val = 1;
                }
            } else if (select.getSelectFieldType() == GenQueryField.SelectFieldTypes.AVG) {
                val = 5;
            } else if (select.getSelectFieldType() == GenQueryField.SelectFieldTypes.COUNT) {
                val = 6;
            } else if (select.getSelectFieldType() == GenQueryField.SelectFieldTypes.MAX) {
                val = 3;
            } else if (select.getSelectFieldType() == GenQueryField.SelectFieldTypes.MIN) {
                val = 2;
            } else if (select.getSelectFieldType() == GenQueryField.SelectFieldTypes.SUM) {
                val = 4;
            } else if (select.getSelectFieldType() == GenQueryField.SelectFieldTypes.FILE_ACCESS) {
                val = 1024;
            } else {
                throw new JargonException("unknown select type, cannot translate to XML protocol:" + (Object)((Object)select.getSelectFieldType()));
            }
            subTags[j] = new Tag(IVALUE, val);
            ++j;
        }
        message.addTag(new Tag(INX_IVAL_PAIR_PI, subTags));
        if (this.translatedIRODSQuery.getTranslatedQueryConditions().size() > 0) {
            subTags = new Tag[this.translatedIRODSQuery.getTranslatedQueryConditions().size() * 2 + 1];
            subTags[0] = new Tag(ISLEN, this.translatedIRODSQuery.getTranslatedQueryConditions().size());
            j = 1;
            for (TranslatedGenQueryCondition queryCondition : this.translatedIRODSQuery.getTranslatedQueryConditions()) {
                subTags[j] = new Tag(INX, queryCondition.getColumnNumericTranslation());
                ++j;
            }
            for (TranslatedGenQueryCondition queryCondition : this.translatedIRODSQuery.getTranslatedQueryConditions()) {
                subTags[j] = new Tag(SVALUE, " " + queryCondition.getOperator() + " " + queryCondition.getValue() + " ");
                ++j;
            }
            message.addTag(new Tag(INX_VAL_PAIR_PI, subTags));
        } else {
            message.addTag(new Tag(INX_VAL_PAIR_PI, new Tag(ISLEN, 0)));
        }
        return message;
    }
}

