/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.AbstractIRODSGenQuery;

public final class IRODSGenQuery
extends AbstractIRODSGenQuery {
    private final String queryString;

    public static IRODSGenQuery instance(String queryString, int numberOfResultsDesired) throws JargonException {
        return new IRODSGenQuery(queryString, numberOfResultsDesired, AbstractIRODSGenQuery.RowCountOptions.NO_ROW_COUNT, 0);
    }

    public static IRODSGenQuery instance(String queryString, int numberOfResultsDesired, AbstractIRODSGenQuery.RowCountOptions rowCountOption) throws JargonException {
        return new IRODSGenQuery(queryString, numberOfResultsDesired, rowCountOption, 0);
    }

    private IRODSGenQuery(String queryString, int numberOfResultsDesired, AbstractIRODSGenQuery.RowCountOptions rowCountOption, int skip) throws JargonException {
        super(numberOfResultsDesired);
        if (queryString == null || queryString.length() == 0) {
            throw new JargonException("query string must be supplied");
        }
        if (numberOfResultsDesired <= 0) {
            throw new JargonException("number of results desired must be greater than zero");
        }
        if (rowCountOption == null) {
            throw new JargonException("row count option cannot be null");
        }
        if (skip < 0) {
            throw new JargonException("skip value cannot be negative");
        }
        this.queryString = queryString;
    }

    private IRODSGenQuery(String queryString, int numberOfResultsDesired) throws JargonException {
        this(queryString, numberOfResultsDesired, AbstractIRODSGenQuery.RowCountOptions.NO_ROW_COUNT, 0);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IRODSQuery:");
        sb.append("\n   queryString:");
        sb.append(this.queryString);
        sb.append("\n    numberOfResultsDesired:");
        sb.append(this.numberOfResultsDesired);
        return sb.toString();
    }
}

