/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.ExtensibleMetaDataMapping;
import org.irods.jargon.core.query.GenQueryBuilderCondition;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryField;
import org.irods.jargon.core.query.GenQueryOrderByField;
import org.irods.jargon.core.query.GenQuerySelectField;
import org.irods.jargon.core.query.IRODSGenQueryBuilderQueryData;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;

public class IRODSGenQueryBuilder {
    private final List<GenQuerySelectField> selectFields = new ArrayList<GenQuerySelectField>();
    private final List<GenQueryBuilderCondition> conditions = new ArrayList<GenQueryBuilderCondition>();
    private final List<GenQueryOrderByField> orderByFields = new ArrayList<GenQueryOrderByField>();
    private final boolean distinct;
    private final boolean upperCase;
    private final boolean computeTotalRowCount;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t distinct? ");
        sb.append(this.distinct);
        sb.append("\n\t  upperCase? ");
        sb.append(this.upperCase);
        sb.append("\n\t computeTotalRowCount? ");
        sb.append(this.computeTotalRowCount);
        sb.append("IRODSGenQueryBuilder");
        sb.append("\n\t  selects:");
        sb.append(this.selectFields);
        sb.append("\n\t conditions:");
        sb.append(this.conditions);
        sb.append("\n\t  orderByFields:");
        sb.append(this.orderByFields);
        return sb.toString();
    }

    public IRODSGenQueryBuilder(boolean distinct, boolean upperCase, ExtensibleMetaDataMapping extensibleMetadataMapping) {
        this.distinct = distinct;
        this.upperCase = upperCase;
        this.computeTotalRowCount = false;
    }

    public IRODSGenQueryBuilder(boolean distinct, boolean upperCase, boolean computeTotalRowCount, ExtensibleMetaDataMapping extensibleMetadataMapping) {
        this.distinct = distinct;
        this.upperCase = upperCase;
        this.computeTotalRowCount = computeTotalRowCount;
    }

    public IRODSGenQueryBuilder(boolean distinct, ExtensibleMetaDataMapping extensibleMetadataMapping) {
        this.distinct = distinct;
        this.upperCase = false;
        this.computeTotalRowCount = false;
    }

    public IRODSGenQueryBuilder addSelectAsGenQueryValue(RodsGenQueryEnum rodsGenQueryEnumValue) throws GenQueryBuilderException {
        if (rodsGenQueryEnumValue == null) {
            throw new IllegalArgumentException("null rodsGenQueryEnumValue");
        }
        try {
            GenQuerySelectField selectField = GenQuerySelectField.instance(rodsGenQueryEnumValue, GenQueryField.SelectFieldTypes.FIELD, GenQueryField.SelectFieldSource.DEFINED_QUERY_FIELD);
            this.addSelect(selectField);
            return this;
        }
        catch (JargonException e) {
            throw new GenQueryBuilderException("error adding select", e);
        }
    }

    public IRODSGenQueryBuilder addSelectAsAgregateGenQueryValue(RodsGenQueryEnum rodsGenQueryEnumValue, GenQueryField.SelectFieldTypes selectFieldType) throws GenQueryBuilderException {
        if (rodsGenQueryEnumValue == null) {
            throw new IllegalArgumentException("null rodsGenQueryEnumValue");
        }
        try {
            GenQuerySelectField selectField = GenQuerySelectField.instance(rodsGenQueryEnumValue, selectFieldType, GenQueryField.SelectFieldSource.DEFINED_QUERY_FIELD);
            this.addSelect(selectField);
            return this;
        }
        catch (JargonException e) {
            throw new GenQueryBuilderException("error adding select", e);
        }
    }

    public IRODSGenQueryBuilder addConditionAsGenQueryField(RodsGenQueryEnum rodsGenQueryEnumValue, QueryConditionOperators operator, long value) {
        return this.addConditionAsGenQueryField(rodsGenQueryEnumValue, operator, String.valueOf(value));
    }

    public IRODSGenQueryBuilder addConditionAsGenQueryField(RodsGenQueryEnum rodsGenQueryEnumValue, QueryConditionOperators operator, int value) {
        return this.addConditionAsGenQueryField(rodsGenQueryEnumValue, operator, String.valueOf(value));
    }

    public IRODSGenQueryBuilder addConditionAsMultiValueCondition(RodsGenQueryEnum rodsGenQueryEnumValue, QueryConditionOperators operator, List<String> nonQuotedValues) {
        if (rodsGenQueryEnumValue == null) {
            throw new IllegalArgumentException("null rodsGenQueryEnumValue");
        }
        if (operator == null) {
            throw new IllegalArgumentException("null operator");
        }
        if (nonQuotedValues == null || nonQuotedValues.isEmpty()) {
            throw new IllegalArgumentException("null or empty nonQuotedValues");
        }
        if (operator == QueryConditionOperators.IN) {
            GenQueryBuilderCondition genQueryBuilderCondition = GenQueryBuilderCondition.instanceForIn(rodsGenQueryEnumValue.getName(), GenQueryField.SelectFieldSource.DEFINED_QUERY_FIELD, String.valueOf(rodsGenQueryEnumValue.getNumericValue()), nonQuotedValues);
            this.conditions.add(genQueryBuilderCondition);
        } else if (operator == QueryConditionOperators.BETWEEN) {
            GenQueryBuilderCondition genQueryBuilderCondition = GenQueryBuilderCondition.instanceForBetween(rodsGenQueryEnumValue.getName(), GenQueryField.SelectFieldSource.DEFINED_QUERY_FIELD, String.valueOf(rodsGenQueryEnumValue.getNumericValue()), nonQuotedValues);
            this.conditions.add(genQueryBuilderCondition);
        } else {
            throw new UnsupportedOperationException("query operator not yet supported:" + (Object)((Object)operator));
        }
        return this;
    }

    public IRODSGenQueryBuilder addConditionAsGenQueryField(RodsGenQueryEnum rodsGenQueryEnumValue, QueryConditionOperators operator, String value) {
        if (rodsGenQueryEnumValue == null) {
            throw new IllegalArgumentException("null rodsGenQueryEnumValue");
        }
        if (operator == null) {
            throw new IllegalArgumentException("null operator");
        }
        if (value == null) {
            throw new IllegalArgumentException("null unit value");
        }
        if (operator == QueryConditionOperators.IN) {
            GenQueryBuilderCondition genQueryBuilderCondition = GenQueryBuilderCondition.instance(rodsGenQueryEnumValue.getName(), GenQueryField.SelectFieldSource.DEFINED_QUERY_FIELD, String.valueOf(rodsGenQueryEnumValue.getNumericValue()), operator, value);
            this.conditions.add(genQueryBuilderCondition);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("'");
            sb.append(value);
            sb.append("'");
            GenQueryBuilderCondition genQueryBuilderCondition = GenQueryBuilderCondition.instance(rodsGenQueryEnumValue.getName(), GenQueryField.SelectFieldSource.DEFINED_QUERY_FIELD, String.valueOf(rodsGenQueryEnumValue.getNumericValue()), operator, sb.toString());
            this.conditions.add(genQueryBuilderCondition);
        }
        return this;
    }

    public IRODSGenQueryBuilder addOrderByGenQueryField(RodsGenQueryEnum rodsGenQueryEnumValue, GenQueryOrderByField.OrderByType orderByType) throws GenQueryBuilderException {
        if (rodsGenQueryEnumValue == null) {
            throw new IllegalArgumentException("null rodsGenQueryEnumValue");
        }
        if (orderByType == null) {
            throw new IllegalArgumentException("null orderByType");
        }
        if (orderByType == GenQueryOrderByField.OrderByType.NONE) {
            throw new IllegalArgumentException("ascending or descending order by must be specified");
        }
        boolean selectFound = false;
        for (GenQuerySelectField genQuerySelectField : this.selectFields) {
            if (Integer.parseInt(genQuerySelectField.getSelectFieldNumericTranslation()) != rodsGenQueryEnumValue.getNumericValue()) continue;
            selectFound = true;
            break;
        }
        if (!selectFound) {
            throw new GenQueryBuilderException("order by field is not represented in the select statements");
        }
        GenQueryOrderByField orderByField = GenQueryOrderByField.instance(rodsGenQueryEnumValue.getName(), GenQueryField.SelectFieldSource.DEFINED_QUERY_FIELD, String.valueOf(rodsGenQueryEnumValue.getNumericValue()), orderByType);
        this.orderByFields.add(orderByField);
        return this;
    }

    private IRODSGenQueryBuilder addSelect(GenQuerySelectField genQuerySelectField) throws GenQueryBuilderException {
        if (genQuerySelectField == null) {
            throw new IllegalArgumentException("null genQuerySelectField");
        }
        for (GenQuerySelectField existingQuerySelectField : this.selectFields) {
            if (!genQuerySelectField.getSelectFieldNumericTranslation().equals(existingQuerySelectField.getSelectFieldNumericTranslation())) continue;
            throw new GenQueryBuilderException("duplicate select field");
        }
        this.selectFields.add(genQuerySelectField);
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public IRODSGenQueryFromBuilder exportIRODSQueryFromBuilder(int numberOfResultsDesired) throws GenQueryBuilderException {
        if (numberOfResultsDesired <= 0) {
            throw new IllegalArgumentException("numberOfResultsDesired must be >= 1");
        }
        IRODSGenQueryBuilderQueryData queryData = IRODSGenQueryBuilderQueryData.instance(this.selectFields, this.conditions, this.orderByFields, this.distinct, this.upperCase, this.computeTotalRowCount);
        if (!queryData.isQueryValid()) {
            throw new GenQueryBuilderException("query is not valid, cannot export");
        }
        return IRODSGenQueryFromBuilder.instance(queryData, numberOfResultsDesired);
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public boolean isComputeTotalRowCount() {
        return this.computeTotalRowCount;
    }
}

