/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer.encrypt;

import javax.crypto.Cipher;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.JargonRuntimeException;

abstract class ParallelCipherWrapper {
    private Cipher cipher;
    private PipelineConfiguration pipelineConfiguration;
    private NegotiatedClientServerConfiguration negotiatedClientServerConfiguration;

    ParallelCipherWrapper(PipelineConfiguration pipelineConfiguration, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) {
        if (pipelineConfiguration == null) {
            throw new IllegalArgumentException("null pipelineConfiguration");
        }
        if (negotiatedClientServerConfiguration == null) {
            throw new IllegalArgumentException("null IllegalArgumentException");
        }
        if (!negotiatedClientServerConfiguration.isSslConnection()) {
            throw new JargonRuntimeException("attempting to encrypt when not an SSL enabled connection");
        }
        this.pipelineConfiguration = pipelineConfiguration;
        this.negotiatedClientServerConfiguration = negotiatedClientServerConfiguration;
    }

    PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfiguration;
    }

    NegotiatedClientServerConfiguration getNegotiatedClientServerConfiguration() {
        return this.negotiatedClientServerConfiguration;
    }

    Cipher getCipher() {
        return this.cipher;
    }

    void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }
}

