/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EscapeTagChars {
    private static final Pattern SCRIPT = Pattern.compile("<SCRIPT>", 2);
    private static final Pattern SCRIPT_END = Pattern.compile("</SCRIPT>", 2);

    public static String forHTML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\t') {
                EscapeTagChars.addCharEntity(9, result);
            } else if (character == '!') {
                EscapeTagChars.addCharEntity(33, result);
            } else if (character == '#') {
                EscapeTagChars.addCharEntity(35, result);
            } else if (character == '$') {
                EscapeTagChars.addCharEntity(36, result);
            } else if (character == '%') {
                EscapeTagChars.addCharEntity(37, result);
            } else if (character == '\'') {
                EscapeTagChars.addCharEntity(39, result);
            } else if (character == '(') {
                EscapeTagChars.addCharEntity(40, result);
            } else if (character == ')') {
                EscapeTagChars.addCharEntity(41, result);
            } else if (character == '*') {
                EscapeTagChars.addCharEntity(42, result);
            } else if (character == '+') {
                EscapeTagChars.addCharEntity(43, result);
            } else if (character == ',') {
                EscapeTagChars.addCharEntity(44, result);
            } else if (character == '-') {
                EscapeTagChars.addCharEntity(45, result);
            } else if (character == '.') {
                EscapeTagChars.addCharEntity(46, result);
            } else if (character == '/') {
                EscapeTagChars.addCharEntity(47, result);
            } else if (character == ':') {
                EscapeTagChars.addCharEntity(58, result);
            } else if (character == ';') {
                EscapeTagChars.addCharEntity(59, result);
            } else if (character == '=') {
                EscapeTagChars.addCharEntity(61, result);
            } else if (character == '?') {
                EscapeTagChars.addCharEntity(63, result);
            } else if (character == '@') {
                EscapeTagChars.addCharEntity(64, result);
            } else if (character == '[') {
                EscapeTagChars.addCharEntity(91, result);
            } else if (character == '\\') {
                EscapeTagChars.addCharEntity(92, result);
            } else if (character == ']') {
                EscapeTagChars.addCharEntity(93, result);
            } else if (character == '^') {
                EscapeTagChars.addCharEntity(94, result);
            } else if (character == '_') {
                EscapeTagChars.addCharEntity(95, result);
            } else if (character == '`') {
                EscapeTagChars.addCharEntity(96, result);
            } else if (character == '{') {
                EscapeTagChars.addCharEntity(123, result);
            } else if (character == '|') {
                EscapeTagChars.addCharEntity(124, result);
            } else if (character == '}') {
                EscapeTagChars.addCharEntity(125, result);
            } else if (character == '~') {
                EscapeTagChars.addCharEntity(126, result);
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forHrefAmpersand(String aURL) {
        return aURL.replace("&", "&amp;");
    }

    public static String forURL(String aURLFragment) {
        String result = null;
        try {
            result = URLEncoder.encode(aURLFragment, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static String forXML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '`') {
                result.append("&apos;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forJSON(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\"') {
                result.append("\\\"");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '/') {
                result.append("\\/");
            } else if (character == '\b') {
                result.append("\\b");
            } else if (character == '\f') {
                result.append("\\f");
            } else if (character == '\n') {
                result.append("\\n");
            } else if (character == '\r') {
                result.append("\\r");
            } else if (character == '\t') {
                result.append("\\t");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String toDisableTags(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forRegex(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\.");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '?') {
                result.append("\\?");
            } else if (character == '*') {
                result.append("\\*");
            } else if (character == '+') {
                result.append("\\+");
            } else if (character == '&') {
                result.append("\\&");
            } else if (character == ':') {
                result.append("\\:");
            } else if (character == '{') {
                result.append("\\{");
            } else if (character == '}') {
                result.append("\\}");
            } else if (character == '[') {
                result.append("\\[");
            } else if (character == ']') {
                result.append("\\]");
            } else if (character == '(') {
                result.append("\\(");
            } else if (character == ')') {
                result.append("\\)");
            } else if (character == '^') {
                result.append("\\^");
            } else if (character == '$') {
                result.append("\\$");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forReplacementString(String aInput) {
        return Matcher.quoteReplacement(aInput);
    }

    public static String forScriptTagsOnly(String aText) {
        String result = null;
        Matcher matcher = SCRIPT.matcher(aText);
        result = matcher.replaceAll("&lt;SCRIPT>");
        matcher = SCRIPT_END.matcher(result);
        result = matcher.replaceAll("&lt;/SCRIPT>");
        return result;
    }

    private EscapeTagChars() {
    }

    private static void addCharEntity(Integer aIdx, StringBuilder aBuilder) {
        String padding = "";
        if (aIdx <= 9) {
            padding = "00";
        } else if (aIdx <= 99) {
            padding = "0";
        }
        String number = padding + aIdx.toString();
        aBuilder.append("&#" + number + ";");
    }
}

