/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.response;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import synapticloop.b2.exception.B2ApiException;

public abstract class BaseB2Response {
    private final JSONObject response;

    public BaseB2Response(String json) throws B2ApiException {
        this(BaseB2Response.parse(json));
    }

    public BaseB2Response(JSONObject response) throws B2ApiException {
        this.response = response;
    }

    private static JSONObject parse(String json) throws B2ApiException {
        JSONObject jsonObject;
        try {
            jsonObject = new JSONObject(json);
        }
        catch (JSONException ex) {
            throw new B2ApiException(json, ex);
        }
        return jsonObject;
    }

    protected String readString(String key) {
        return this.readString(this.response, key);
    }

    protected String readString(JSONObject response, String key) {
        Object value = response.remove(key);
        if (null == value || JSONObject.NULL == value) {
            this.getLogger().warn("No field for key {}", (Object)key);
            return null;
        }
        return value.toString();
    }

    protected Integer readInt(String key) {
        Object value = this.response.remove(key);
        if (null == value || JSONObject.NULL == value) {
            this.getLogger().warn("No field for key {}", (Object)key);
            return null;
        }
        return value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
    }

    protected Long readLong(String key) {
        Object value = this.response.remove(key);
        if (null == value || JSONObject.NULL == value) {
            this.getLogger().warn("No field for key {}", (Object)key);
            return null;
        }
        return value instanceof Number ? ((Number)value).longValue() : Long.parseLong(value.toString());
    }

    protected JSONObject readObject(String key) {
        return this.readObject(this.response, key);
    }

    protected JSONObject readObject(JSONObject response, String key) {
        Object value = response.remove(key);
        if (null == value || JSONObject.NULL == value) {
            this.getLogger().warn("No field for key {}", (Object)key);
            return null;
        }
        return value instanceof JSONObject ? (JSONObject)value : null;
    }

    protected JSONArray readObjects(String key) {
        Object value = this.response.remove(key);
        if (null == value || JSONObject.NULL == value) {
            this.getLogger().warn("No field for key {}", (Object)key);
            return null;
        }
        return value instanceof JSONArray ? (JSONArray)value : null;
    }

    protected Map<String, String> readMap(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        JSONObject value = this.readObject(key);
        if (null == value || JSONObject.NULL == value) {
            this.getLogger().warn("No field for key {}", (Object)key);
            return null;
        }
        for (String k : value.keySet().toArray(new String[value.keySet().size()])) {
            map.put(k, this.readString(value, k));
        }
        return map;
    }

    protected void warnOnMissedKeys() {
        if (this.getLogger().isWarnEnabled()) {
            Iterator keys = this.response.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if ("accountId".equals(key)) {
                    this.getLogger().warn("Found an unexpected key of '{}' in JSON that is not mapped to a field, with value '{}'.", (Object)key, (Object)"[redacted]");
                    continue;
                }
                this.getLogger().warn("Found an unexpected key of '{}' in JSON that is not mapped to a field, with value '{}'.", (Object)key, this.response.get(key));
            }
        }
    }

    protected abstract Logger getLogger();
}

