/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConflictException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.MultipartUploadTokenOutputStream;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSUploadService;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class SDSMultipartWriteFeature
implements MultipartWrite<VersionId> {
    private static final Logger log = Logger.getLogger(SDSMultipartWriteFeature.class);
    private final SDSSession session;
    private final Find finder;
    private final AttributesFinder attributes;
    private final SDSUploadService upload;

    public SDSMultipartWriteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SDSMultipartWriteFeature(SDSSession session, SDSNodeIdProvider nodeid, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
        this.upload = new SDSUploadService(session, nodeid);
    }

    public HttpResponseOutputStream<VersionId> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        final String uploadToken = this.upload.start(file, status);
        final MultipartUploadTokenOutputStream proxy = new MultipartUploadTokenOutputStream(this.session, file, status, uploadToken);
        return new HttpResponseOutputStream<VersionId>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(PreferencesFactory.get().getInteger("sds.upload.multipart.chunksize")))){
            private final AtomicBoolean close;
            {
                super(arg0);
                this.close = new AtomicBoolean();
            }

            public VersionId getStatus() {
                return proxy.getVersionId();
            }

            public void close() throws IOException {
                try {
                    if (this.close.get()) {
                        log.warn((Object)String.format("Skip double close of stream %s", new Object[]{this}));
                        return;
                    }
                    super.close();
                    try {
                        status.setVersion(SDSMultipartWriteFeature.this.upload.complete(file, uploadToken, status));
                    }
                    catch (ConflictException e) {
                        status.setVersion(SDSMultipartWriteFeature.this.upload.complete(file, uploadToken, new TransferStatus(status).exists(true)));
                    }
                }
                catch (BackgroundException e) {
                    throw new IOException(e);
                }
                finally {
                    this.close.set(true);
                }
            }

            protected void handleIOException(IOException e) throws IOException {
                try {
                    SDSMultipartWriteFeature.this.upload.cancel(file, uploadToken);
                }
                catch (BackgroundException f) {
                    log.warn((Object)String.format("Failure %s cancelling upload for file %s with upload token %s after failure %s", new Object[]{f, file, uploadToken, e}));
                }
                throw e;
            }
        };
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }
}

