/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Request model for creating a folder")
public class CreateFolderRequest {
    @JsonProperty(value="parentId")
    private Long parentId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="timestampCreation")
    private DateTime timestampCreation = null;
    @JsonProperty(value="timestampModification")
    private DateTime timestampModification = null;

    public CreateFolderRequest parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(required=true, description="Parent node ID (room or folder)")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public CreateFolderRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateFolderRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="User notes  Use empty string to remove.")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public CreateFolderRequest timestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.22.0  Time the node was created on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampCreation() {
        return this.timestampCreation;
    }

    public void setTimestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
    }

    public CreateFolderRequest timestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.22.0  Time the content of a node was last modified on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampModification() {
        return this.timestampModification;
    }

    public void setTimestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFolderRequest createFolderRequest = (CreateFolderRequest)o;
        return Objects.equals(this.parentId, createFolderRequest.parentId) && Objects.equals(this.name, createFolderRequest.name) && Objects.equals(this.notes, createFolderRequest.notes) && Objects.equals(this.timestampCreation, createFolderRequest.timestampCreation) && Objects.equals(this.timestampModification, createFolderRequest.timestampModification);
    }

    public int hashCode() {
        return Objects.hash(this.parentId, this.name, this.notes, this.timestampCreation, this.timestampModification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFolderRequest {\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    timestampCreation: ").append(this.toIndentedString(this.timestampCreation)).append("\n");
        sb.append("    timestampModification: ").append(this.toIndentedString(this.timestampModification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

