/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Request model for creating an upload channel")
public class CreateShareUploadChannelRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="directS3Upload")
    private Boolean directS3Upload = false;
    @JsonProperty(value="timestampCreation")
    private DateTime timestampCreation = null;
    @JsonProperty(value="timestampModification")
    private DateTime timestampModification = null;

    public CreateShareUploadChannelRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="File name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateShareUploadChannelRequest size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(description="File size in byte")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public CreateShareUploadChannelRequest password(String password) {
        this.password = password;
        return this;
    }

    @Schema(description="Password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateShareUploadChannelRequest directS3Upload(Boolean directS3Upload) {
        this.directS3Upload = directS3Upload;
        return this;
    }

    @Schema(description="&#128640; Since v4.15.0  Upload direct to S3")
    public Boolean isDirectS3Upload() {
        return this.directS3Upload;
    }

    public void setDirectS3Upload(Boolean directS3Upload) {
        this.directS3Upload = directS3Upload;
    }

    public CreateShareUploadChannelRequest timestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.22.0  Time the node was created on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampCreation() {
        return this.timestampCreation;
    }

    public void setTimestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
    }

    public CreateShareUploadChannelRequest timestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.22.0  Time the content of a node was last modified on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampModification() {
        return this.timestampModification;
    }

    public void setTimestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateShareUploadChannelRequest createShareUploadChannelRequest = (CreateShareUploadChannelRequest)o;
        return Objects.equals(this.name, createShareUploadChannelRequest.name) && Objects.equals(this.size, createShareUploadChannelRequest.size) && Objects.equals(this.password, createShareUploadChannelRequest.password) && Objects.equals(this.directS3Upload, createShareUploadChannelRequest.directS3Upload) && Objects.equals(this.timestampCreation, createShareUploadChannelRequest.timestampCreation) && Objects.equals(this.timestampModification, createShareUploadChannelRequest.timestampModification);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.size, this.password, this.directS3Upload, this.timestampCreation, this.timestampModification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateShareUploadChannelRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    directS3Upload: ").append(this.toIndentedString(this.directS3Upload)).append("\n");
        sb.append("    timestampCreation: ").append(this.toIndentedString(this.timestampCreation)).append("\n");
        sb.append("    timestampModification: ").append(this.toIndentedString(this.timestampModification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

