# ESMF application makefile fragment
#
# Use the following ESMF_ variables to compile and link
# your ESMF application against this ESMF build.
#
# !!! VERY IMPORTANT: If the location of this ESMF build is   !!!
# !!! changed, e.g. libesmf.a is copied to another directory, !!!
# !!! this file - esmf.mk - must be edited to adjust to the   !!!
# !!! correct new path                                        !!!
#
# Please see end of file for options used on this ESMF build
#

#----------------------------------------------
ESMF_VERSION_STRING=8.9.0
# Not a Git repository
ESMF_VERSION_STRING_GIT=NoGit
#----------------------------------------------

ESMF_VERSION_MAJOR=8
ESMF_VERSION_MINOR=9
ESMF_VERSION_REVISION=0
ESMF_VERSION_PATCHLEVEL=0
ESMF_VERSION_PUBLIC='T'
ESMF_VERSION_BETASNAPSHOT='F'


ESMF_APPSDIR=/opt/local/bin
ESMF_LIBSDIR=/opt/local/lib
ESMF_ESMXDIR=/opt/local/include/esmf/ESMX
ESMF_CMAKEDIR=/opt/local/share/cmake/Modules


ESMF_F90COMPILER=/opt/local/bin/gfortran-mp-14
ESMF_F90LINKER=/usr/bin/clang++

ESMF_F90COMPILEOPTS=-Os -O  -fPIC  -m64 -mcmodel=small -pthread -frecursive -ffree-line-length-none -fno-backtrace
ESMF_F90COMPILEPATHS=-I/opt/local/include/esmf -I/opt/local/include/esmf -I/opt/local/include -I/opt/local/include -I/opt/local/include
ESMF_F90COMPILECPPFLAGS=-DESMF_NO_INTEGER_1_BYTE -DESMF_NO_INTEGER_2_BYTE -DESMF_MPIUNI -I/opt/local/share/esmf/src/Infrastructure/stubs/mpiuni -DESMF_LOWERCASE_SINGLEUNDERSCORE -DESMF_MOAB=1 -DESMF_LAPACK=1 -DESMF_NO_ACC_SOFTWARE_STACK=1 -DESMF_NETCDF=1 -DESMF_XERCES=1 -DESMF_YAMLCPP=1 -DESMF_YAML=1 -DESMF_NO_OPENMP -DESMF_NO_OPENACC -DESMF_BOPT_O -DESMF_TESTPERFORMANCE -DESMF_TESTCOMPTUNNEL -DSx86_64_small=1 -DESMF_OS_Darwin=1 -DESMF_COMM=mpiuni -DESMF_DIR=/opt/local/share/esmf
ESMF_F90COMPILEFREECPP=
ESMF_F90COMPILEFREENOCPP=-ffree-form
ESMF_F90COMPILEFIXCPP=-cpp -ffixed-form
ESMF_F90COMPILEFIXNOCPP=

ESMF_F90LINKOPTS= -L/opt/local/lib -Wl,-headerpad_max_install_names   -m64 -mcmodel=small -pthread
ESMF_F90LINKPATHS=-L/opt/local/lib -L/opt/local/lib -L/opt/local/lib -L/opt/local/lib -L/opt/local/lib/gcc14/gcc/x86_64-apple-darwin19/14.2.0/../../../ -L./
ESMF_F90ESMFLINKPATHS=-L/opt/local/lib
ESMF_F90LINKRPATHS=-Wl,-rpath,/opt/local/lib  -Wl,-rpath,/opt/local/lib  -Wl,-rpath,/opt/local/lib  -Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib/gcc14/gcc/x86_64-apple-darwin19/14.2.0/../../../
ESMF_F90ESMFLINKRPATHS=-Wl,-rpath,/opt/local/lib
ESMF_F90LINKLIBS=-lvecLibFort -lnetcdff -lnetcdf -lxerces-c -lyaml-cpp -lm -lc++ -lgfortran
ESMF_F90ESMFLINKLIBS=-lesmf -lvecLibFort -lnetcdff -lnetcdf -lxerces-c -lyaml-cpp -lm -lc++ -lgfortran

ESMF_CXXCOMPILER=/usr/bin/clang++
ESMF_CXXLINKER=/usr/bin/clang++

ESMF_CXXCOMPILEOPTS=-Os -stdlib=libc++ -std=c++11 -O -DNDEBUG  -fPIC -x c++ -mmacosx-version-min=10.7 -stdlib=libc++ -m64 -mcmodel=small -pthread
ESMF_CXXCOMPILEPATHS= -I/opt/local/include/esmf  -I/opt/local/include -I/opt/local/include -I/opt/local/include
ESMF_CXXCOMPILECPPFLAGS=-DESMF_NO_INTEGER_1_BYTE -DESMF_NO_INTEGER_2_BYTE -DESMF_MPIUNI -I/opt/local/share/esmf/src/Infrastructure/stubs/mpiuni -DESMF_LOWERCASE_SINGLEUNDERSCORE -DESMF_MOAB=1 -DESMF_LAPACK=1 -DESMF_NO_ACC_SOFTWARE_STACK=1 -DESMF_NETCDF=1 -DESMF_XERCES=1 -DESMF_YAMLCPP=1 -DESMF_YAML=1 -DESMF_NO_OPENMP -DESMF_NO_OPENACC -DESMF_BOPT_O -DESMF_TESTPERFORMANCE -DESMF_TESTCOMPTUNNEL -DSx86_64_small=1 -DESMF_OS_Darwin=1 -DESMF_COMM=mpiuni -DESMF_DIR=/opt/local/share/esmf -D__SDIR__='' -DESMF_CXXSTD=11

ESMF_CXXLINKOPTS= -L/opt/local/lib -Wl,-headerpad_max_install_names  -m64 -mcmodel=small -pthread
ESMF_CXXLINKPATHS=-L/opt/local/lib -L/opt/local/lib -L/opt/local/lib -L/opt/local/lib -L/opt/local/lib/gcc14/gcc/x86_64-apple-darwin19/14.2.0/../../../
ESMF_CXXESMFLINKPATHS=-L/opt/local/lib
ESMF_CXXLINKRPATHS=-Wl,-rpath,/opt/local/lib  -Wl,-rpath,/opt/local/lib  -Wl,-rpath,/opt/local/lib  -Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib/gcc14/gcc/x86_64-apple-darwin19/14.2.0/../../../
ESMF_CXXESMFLINKRPATHS=-Wl,-rpath,/opt/local/lib
ESMF_CXXLINKLIBS=-lvecLibFort -lnetcdff -lnetcdf -lxerces-c -lyaml-cpp -lgfortran
ESMF_CXXESMFLINKLIBS=-lesmf -lvecLibFort -lnetcdff -lnetcdf -lxerces-c -lyaml-cpp -lgfortran

ESMF_CCOMPILER=/usr/bin/clang
ESMF_CLINKER=clang++

ESMF_CCOMPILEOPTS=-std=c99 -O -DNDEBUG  -fPIC -m64 -mcmodel=small -pthread
ESMF_CCOMPILEPATHS= -I/opt/local/include/esmf  
ESMF_CCOMPILECPPFLAGS=-DESMF_NO_INTEGER_1_BYTE -DESMF_NO_INTEGER_2_BYTE -DESMF_MPIUNI -I/opt/local/share/esmf/src/Infrastructure/stubs/mpiuni -DESMF_LOWERCASE_SINGLEUNDERSCORE -DESMF_MOAB=1 -DESMF_LAPACK=1 -DESMF_NO_ACC_SOFTWARE_STACK=1 -DESMF_NETCDF=1 -DESMF_XERCES=1 -DESMF_YAMLCPP=1 -DESMF_YAML=1 -DESMF_NO_OPENMP -DESMF_NO_OPENACC -DESMF_BOPT_O -DESMF_TESTPERFORMANCE -DESMF_TESTCOMPTUNNEL -DSx86_64_small=1 -DESMF_OS_Darwin=1 -DESMF_COMM=mpiuni -DESMF_DIR=/opt/local/share/esmf -D__SDIR__='' -DESMF_CSTD=99

ESMF_CLINKOPTS=  -m64 -mcmodel=small -pthread
ESMF_CLINKPATHS=-L/opt/local/lib -L/opt/local/lib -L/opt/local/lib -L/opt/local/lib -L/opt/local/lib/gcc14/gcc/x86_64-apple-darwin19/14.2.0/../../../ -L/opt/local/lib -L/opt/local/lib -L/opt/local/lib -L/opt/local/lib -L/opt/local/lib/gcc14/gcc/x86_64-apple-darwin19/14.2.0/../../../ -L./
ESMF_CESMFLINKPATHS=-L/opt/local/lib
ESMF_CLINKRPATHS=-Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib/gcc14/gcc/x86_64-apple-darwin19/14.2.0/../../../ -Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib -Wl,-rpath,/opt/local/lib/gcc14/gcc/x86_64-apple-darwin19/14.2.0/../../../ -Wl,-rpath,./
ESMF_CESMFLINKRPATHS=-Wl,-rpath,/opt/local/lib
ESMF_CLINKLIBS=-lvecLibFort -lnetcdff -lnetcdf -lxerces-c -lyaml-cpp -lgfortran -lvecLibFort -lnetcdff -lnetcdf -lxerces-c -lyaml-cpp -lm -lc++ -lgfortran
ESMF_CESMFLINKLIBS=-lesmf -lvecLibFort -lnetcdff -lnetcdf -lxerces-c -lyaml-cpp -lgfortran -lvecLibFort -lnetcdff -lnetcdf -lxerces-c -lyaml-cpp -lm -lc++ -lgfortran

ESMF_SO_F90COMPILEOPTS=-fPIC
ESMF_SO_F90LINKOPTS=-shared
ESMF_SO_F90LINKOPTSEXE=
ESMF_SO_CXXCOMPILEOPTS=-fPIC
ESMF_SO_CXXLINKOPTS=-shared
ESMF_SO_CXXLINKOPTSEXE=
ESMF_SO_CCOMPILEOPTS=-fPIC
ESMF_SO_CLINKOPTS=-shared
ESMF_SO_CLINKOPTSEXE=

ESMF_OPENMP_F90COMPILEOPTS= -fopenmp
ESMF_OPENMP_F90LINKOPTS= -fopenmp
ESMF_OPENMP_CXXCOMPILEOPTS= -Xpreprocessor -fopenmp
ESMF_OPENMP_CXXLINKOPTS= -Xpreprocessor -fopenmp

ESMF_OPENACC_F90COMPILEOPTS=
ESMF_OPENACC_F90LINKOPTS=
ESMF_OPENACC_CXXCOMPILEOPTS=
ESMF_OPENACC_CXXLINKOPTS=

# ESMF Tracing compile/link options
ESMF_TRACE_LDPRELOAD=/opt/local/lib/libesmftrace_preload.dylib
ESMF_TRACE_STATICLINKOPTS=-static -Wl,--wrap=c_esmftrace_notify_wrappers -Wl,--wrap=c_esmftrace_isinitialized -Wl,--wrap=write -Wl,--wrap=writev -Wl,--wrap=pwrite -Wl,--wrap=read -Wl,--wrap=open -Wl,--wrap=MPI_Allgather -Wl,--wrap=MPI_Allgatherv -Wl,--wrap=MPI_Allreduce -Wl,--wrap=MPI_Alltoall -Wl,--wrap=MPI_Alltoallv -Wl,--wrap=MPI_Alltoallw -Wl,--wrap=MPI_Barrier -Wl,--wrap=MPI_Bcast -Wl,--wrap=MPI_Bsend -Wl,--wrap=MPI_Gather -Wl,--wrap=MPI_Gatherv -Wl,--wrap=MPI_Iprobe -Wl,--wrap=MPI_Irecv -Wl,--wrap=MPI_Irsend -Wl,--wrap=MPI_Isend -Wl,--wrap=MPI_Issend -Wl,--wrap=MPI_Probe -Wl,--wrap=MPI_Recv -Wl,--wrap=MPI_Reduce -Wl,--wrap=MPI_Rsend -Wl,--wrap=MPI_Scan -Wl,--wrap=MPI_Scatter -Wl,--wrap=MPI_Scatterv -Wl,--wrap=MPI_Send -Wl,--wrap=MPI_Sendrecv -Wl,--wrap=MPI_Test -Wl,--wrap=MPI_Testall -Wl,--wrap=MPI_Testany -Wl,--wrap=MPI_Testsome -Wl,--wrap=MPI_Wait -Wl,--wrap=MPI_Waitall -Wl,--wrap=MPI_Waitany -Wl,--wrap=MPI_Waitsome -Wl,--wrap=mpi_allgather_ -Wl,--wrap=mpi_allgather__ -Wl,--wrap=mpi_allgatherv_ -Wl,--wrap=mpi_allgatherv__ -Wl,--wrap=mpi_allreduce_ -Wl,--wrap=mpi_allreduce__ -Wl,--wrap=mpi_alltoall_ -Wl,--wrap=mpi_alltoall__ -Wl,--wrap=mpi_alltoallv_ -Wl,--wrap=mpi_alltoallv__ -Wl,--wrap=mpi_alltoallw_ -Wl,--wrap=mpi_alltoallw__ -Wl,--wrap=mpi_barrier_ -Wl,--wrap=mpi_barrier__ -Wl,--wrap=mpi_bcast_ -Wl,--wrap=mpi_bcast__ -Wl,--wrap=mpi_bsend_ -Wl,--wrap=mpi_bsend__ -Wl,--wrap=mpi_exscan_ -Wl,--wrap=mpi_exscan__ -Wl,--wrap=mpi_gather_ -Wl,--wrap=mpi_gather__ -Wl,--wrap=mpi_gatherv_ -Wl,--wrap=mpi_gatherv__ -Wl,--wrap=mpi_iprobe_ -Wl,--wrap=mpi_iprobe__ -Wl,--wrap=mpi_irecv_ -Wl,--wrap=mpi_irecv__ -Wl,--wrap=mpi_irsend_ -Wl,--wrap=mpi_irsend__ -Wl,--wrap=mpi_isend_ -Wl,--wrap=mpi_isend__ -Wl,--wrap=mpi_issend_ -Wl,--wrap=mpi_issend__ -Wl,--wrap=mpi_probe_ -Wl,--wrap=mpi_probe__ -Wl,--wrap=mpi_recv_ -Wl,--wrap=mpi_recv__ -Wl,--wrap=mpi_reduce_ -Wl,--wrap=mpi_reduce__ -Wl,--wrap=mpi_reduce_scatter_ -Wl,--wrap=mpi_reduce_scatter__ -Wl,--wrap=mpi_rsend_ -Wl,--wrap=mpi_rsend__ -Wl,--wrap=mpi_scatter_ -Wl,--wrap=mpi_scatter__ -Wl,--wrap=mpi_scatterv_ -Wl,--wrap=mpi_scatterv__ -Wl,--wrap=mpi_scan_ -Wl,--wrap=mpi_scan__ -Wl,--wrap=mpi_send_ -Wl,--wrap=mpi_send__ -Wl,--wrap=mpi_sendrecv_ -Wl,--wrap=mpi_sendrecv__ -Wl,--wrap=mpi_test_ -Wl,--wrap=mpi_test__ -Wl,--wrap=mpi_testall_ -Wl,--wrap=mpi_testall__ -Wl,--wrap=mpi_testany_ -Wl,--wrap=mpi_testany__ -Wl,--wrap=mpi_testsome_ -Wl,--wrap=mpi_testsome__ -Wl,--wrap=mpi_wait_ -Wl,--wrap=mpi_wait__ -Wl,--wrap=mpi_waitall_ -Wl,--wrap=mpi_waitall__ -Wl,--wrap=mpi_waitany_ -Wl,--wrap=mpi_waitany__
ESMF_TRACE_STATICLINKLIBS=-lesmftrace_static
ESMF_TRACE_DYNAMICLINKLIBS=-lesmftrace_preload
ESMF_F90ESMFPRELOADLINKLIBS=-lesmf -lesmftrace_preload -lvecLibFort -lnetcdff -lnetcdf -lxerces-c -lyaml-cpp -lm -lc++ -lgfortran

# Internal ESMF variables, do NOT depend on these!

ESMF_INTERNAL_DIR=/opt/local/share/esmf
ESMF_INTERNAL_MPIRUN="/opt/local/share/esmf/src/Infrastructure/stubs/mpiuni/mpirun"

#
# !!! The following options were used on this ESMF build !!!
#
# ESMF_DIR: /opt/local/share/esmf
# ESMF_OS: Darwin
# ESMF_MACHINE: x86_64
# ESMF_ABI: 64
# ESMF_COMPILER: gfortranclang
# ESMF_BOPT: O
# ESMF_COMM: mpiuni
# ESMF_SITE: default
# ESMF_PTHREADS: ON
# ESMF_OPENMP: OFF
# ESMF_OPENACC: OFF
# ESMF_ARRAY_LITE: FALSE
# ESMF_NO_INTEGER_1_BYTE: TRUE
# ESMF_NO_INTEGER_2_BYTE: TRUE
# ESMF_FORTRANSYMBOLS: default
# ESMF_MAPPER_BUILD: OFF
# ESMF_AUTO_LIB_BUILD: ON
# ESMF_DEFER_LIB_BUILD: ON
# ESMF_SHARED_LIB_BUILD: ON
# 
# ESMF environment variables pointing to 3rd party software:
# ESMF_MOAB:              internal
# ESMF_LAPACK:            system
# ESMF_LAPACK_LIBS:       -lvecLibFort
# ESMF_ACC_SOFTWARE_STACK:            none
# ESMF_NETCDF:            split
# ESMF_NETCDF_INCLUDE:    /opt/local/include
# ESMF_NETCDF_LIBS:       -lnetcdff -lnetcdf
# ESMF_NETCDF_LIBPATH:    /opt/local/lib
# ESMF_XERCES:            standard
# ESMF_XERCES_INCLUDE:    /opt/local/include
# ESMF_XERCES_LIBS:       -lxerces-c
# ESMF_XERCES_LIBPATH:    /opt/local/lib
# ESMF_YAMLCPP:           standard
# ESMF_YAMLCPP_INCLUDE:   /opt/local/include
# ESMF_YAMLCPP_LIBS:      -lyaml-cpp
# ESMF_YAMLCPP_LIBPATH:   /opt/local/lib
#
# * Compilers, Linkers, Flags, and Libraries *
# Location of the preprocessor:      /usr/bin/clang
# Location of the Fortran compiler:  /opt/local/bin/gfortran-mp-14
# Location of the Fortran linker:    /usr/bin/clang++
# Location of the C++ compiler:      /usr/bin/clang++
# Location of the C++ linker:        /usr/bin/clang++
# Location of the C compiler:        /usr/bin/clang
# Location of the C linker:          /usr/bin/clang++
#
# !!! ----- User set ESMF_ environment variables ----- !!!
#
#  --------------------------------------------------------------
#   * User set ESMF environment variables *
#  ESMF_C=/usr/bin/clang
#  ESMF_COMM=mpiuni
#  ESMF_COMPILER=gfortranclang
#  ESMF_CXX=/usr/bin/clang++
#  ESMF_CXXCOMPILEOPTS=-Os -stdlib=libc++
#  ESMF_CXXLINKOPTS= -L/opt/local/lib -Wl,-headerpad_max_install_names
#  ESMF_DIR=/opt/local/share/esmf
#  ESMF_F90=/opt/local/bin/gfortran-mp-14
#  ESMF_F90COMPILEOPTS=-Os
#  ESMF_F90LINKOPTS= -L/opt/local/lib -Wl,-headerpad_max_install_names
#  ESMF_INSTALL_BINDIR=/opt/local/bin
#  ESMF_INSTALL_CMAKEDIR=/opt/local/share/cmake/Modules
#  ESMF_INSTALL_DOCDIR=/opt/local/share/doc/esmf
#  ESMF_INSTALL_HEADERDIR=/opt/local/include/esmf
#  ESMF_INSTALL_LIBDIR=/opt/local/lib
#  ESMF_INSTALL_MODDIR=/opt/local/include/esmf
#  ESMF_INSTALL_PREFIX=/opt/local
#  ESMF_LAPACK=system
#  ESMF_LAPACK_LIBS=-lvecLibFort
#  ESMF_NETCDF=split
#  ESMF_NETCDF_INCLUDE=/opt/local/include
#  ESMF_NETCDF_LIBPATH=/opt/local/lib
#  ESMF_PIO=OFF
#  ESMF_XERCES=standard
#  ESMF_XERCES_INCLUDE=/opt/local/include
#  ESMF_XERCES_LIBPATH=/opt/local/lib
#  ESMF_YAMLCPP=standard
#  ESMF_YAMLCPP_INCLUDE=/opt/local/include
#  ESMF_YAMLCPP_LIBPATH=/opt/local/lib
#  
#  --------------------------------------------------------------
