/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: CUFOps.td                                                            *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace cuf {
/// Allocate an object on device
/// This is a drop in replacement for fir.alloca and fir.allocmem for device
///     object. Any device, managed or unified object declared in an host
///     subprogram needs to be allocated in the device memory through runtime calls.
///     The cuf.alloc is an abstraction to the runtime calls and works together
///     with cuf.free.
class AllocOp;
} // namespace cuf
namespace cuf {
/// Perform the device allocation of data of an allocatable
/// The cuf.allocate operation performs the allocation on the device
///     of the data of an allocatable. The descriptor passed to the operation
///     is initialized before with the standard flang runtime calls.
class AllocateOp;
} // namespace cuf
namespace cuf {
/// Represent a data transfer between host and device memory
/// CUDA Fortran allows data transfer to be done via intrinsic assignment
///     between a host and a device variable. This operation is used to materialized
///     the data transfer between the lhs and rhs memory references.
///     The kind of transfer is specified in the attribute. 
/// 
///     ```
///       adev = a ! transfer host to device
///       a = adev ! transfer device to host
///       bdev = adev ! transfer device to device
///     ```
///     
///     When the data transfer is done on data hold by descriptors, the LHS data
///     hold by the descriptor are updated. When required, the LHS decriptor is also
///     updated.
class DataTransferOp;
} // namespace cuf
namespace cuf {
/// Perform the device deallocation of data of an allocatable
/// The cuf.deallocate operation performs the deallocation on the device
///     of the data of an allocatable.
class DeallocateOp;
} // namespace cuf
namespace cuf {
/// Get the device address from a host symbol
class DeviceAddressOp;
} // namespace cuf
namespace cuf {
/// Free a device allocated object
/// The cuf.free operation frees the memory allocated by cuf.alloc.
///     This is used for non-allocatable device, managed and unified device
///     variables declare in host subprogram.
class FreeOp;
} // namespace cuf
namespace cuf {
/// call CUDA kernel
/// Launch a CUDA kernel from the host.
/// 
///     ```
///       // launch simple kernel with no arguments. bytes and stream value are
///       // optional in the chevron notation.
///       cuf.kernel_launch @kernel<<<%gx, %gy, %gz, %bx, %by, %bz>>>()
///     ```
class KernelLaunchOp;
} // namespace cuf
namespace cuf {
/// Represent the CUDA Fortran kernel directive. The operation is a loop like
///     operation that represents the iteration range of the embedded loop nest.
/// 
///     When grid or block variadic operands are empty, a `*` only syntax was used
///     in the Fortran code.
///     If the `*` is mixed with values for either grid or block, these are
///     represented by a 0 constant value.
class KernelOp;
} // namespace cuf
namespace cuf {
/// Register a CUDA kernel
class RegisterKernelOp;
} // namespace cuf
namespace cuf {
/// Register a CUDA module
class RegisterModuleOp;
} // namespace cuf
namespace cuf {
/// Set the allocator index in a descriptor
/// Allocator index in the Fortran descriptor is used to retrived the correct
///     CUDA allocator to allocate the memory on the device.
///     In many cases the allocator index is set when the descriptor is created. For
///     device components, the descriptor is part of the derived-type itself and
///     needs to be set after the derived-type is allocated in managed memory.
class SetAllocatorIndexOp;
} // namespace cuf
namespace cuf {
/// Get the pointer to the kernel shared memory
/// Return the pointer in the shared memory relative to the specified offset.
class SharedMemoryOp;
} // namespace cuf
namespace cuf {
/// Adapt a stream value to a GPU async token
/// Cast a stream object reference as a GPU async token. This is useful to be
///     able to connect the stream representation of CUDA Fortran and the async
///     mechanism of the GPU dialect.
///     Later in the lowering this will become a no op.
class StreamCastOp;
} // namespace cuf
namespace cuf {
/// Synchronize the host and device descriptor of a Fortran pointer
class SyncDescriptorOp;
} // namespace cuf
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::AllocOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AllocOpGenericAdaptorBase {
public:
  struct Properties {
    using bindc_nameTy = ::mlir::StringAttr;
    bindc_nameTy bindc_name;

    auto getBindcName() const {
      auto &propStorage = this->bindc_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setBindcName(const ::mlir::StringAttr &propValue) {
      this->bindc_name = propValue;
    }
    using data_attrTy = ::cuf::DataAttributeAttr;
    data_attrTy data_attr;

    auto getDataAttr() const {
      auto &propStorage = this->data_attr;
      return ::llvm::cast<::cuf::DataAttributeAttr>(propStorage);
    }
    void setDataAttr(const ::cuf::DataAttributeAttr &propValue) {
      this->data_attr = propValue;
    }
    using in_typeTy = ::mlir::TypeAttr;
    in_typeTy in_type;

    auto getInType() const {
      auto &propStorage = this->in_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setInType(const ::mlir::TypeAttr &propValue) {
      this->in_type = propValue;
    }
    using uniq_nameTy = ::mlir::StringAttr;
    uniq_nameTy uniq_name;

    auto getUniqName() const {
      auto &propStorage = this->uniq_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setUniqName(const ::mlir::StringAttr &propValue) {
      this->uniq_name = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.bindc_name == this->bindc_name &&
        rhs.data_attr == this->data_attr &&
        rhs.in_type == this->in_type &&
        rhs.uniq_name == this->uniq_name &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllocOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.alloc", odsAttrs.getContext());
  }

  AllocOpGenericAdaptorBase(AllocOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getInTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().in_type);
    return attr;
  }

  ::mlir::Type getInType();
  ::mlir::StringAttr getUniqNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().uniq_name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getUniqName();
  ::mlir::StringAttr getBindcNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().bindc_name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getBindcName();
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    auto attr = ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
    return attr;
  }

  ::cuf::DataAttribute getDataAttr();
};
} // namespace detail
template <typename RangeT>
class AllocOpGenericAdaptor : public detail::AllocOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllocOpGenericAdaptorBase;
  static constexpr int odsIndex_typeparams = 0;
  static constexpr int odsIndex_shape = 1;
public:
  AllocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllocOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : AllocOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllocOpGenericAdaptor(RangeT values, const AllocOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllocOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllocOp>>>
  AllocOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getTypeparams() {
    return getODSOperands(0);
  }

  RangeT getShape() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AllocOpAdaptor : public AllocOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllocOpGenericAdaptor::AllocOpGenericAdaptor;
  AllocOpAdaptor(AllocOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllocOp : public ::mlir::Op<AllocOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::ReferenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllocOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllocOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_typeparams = 0;
  static constexpr int odsIndex_shape = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("bindc_name"), ::llvm::StringRef("data_attr"), ::llvm::StringRef("in_type"), ::llvm::StringRef("uniq_name"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBindcNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBindcNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDataAttrAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDataAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getInTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getInTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getUniqNameAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getUniqNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.alloc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getShape() {
    return getODSOperands(1);
  }

  ::mlir::MutableOperandRange getTypeparamsMutable();
  ::mlir::MutableOperandRange getShapeMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::ReferenceType> getPtr() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getInTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().in_type);
  }

  ::mlir::Type getInType();
  ::mlir::StringAttr getUniqNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().uniq_name);
  }

  ::std::optional< ::llvm::StringRef > getUniqName();
  ::mlir::StringAttr getBindcNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().bindc_name);
  }

  ::std::optional< ::llvm::StringRef > getBindcName();
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    return ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
  }

  ::cuf::DataAttribute getDataAttr();
  void setInTypeAttr(::mlir::TypeAttr attr) {
    getProperties().in_type = attr;
  }

  void setInType(::mlir::Type attrValue);
  void setUniqNameAttr(::mlir::StringAttr attr) {
    getProperties().uniq_name = attr;
  }

  void setUniqName(::std::optional<::llvm::StringRef> attrValue);
  void setBindcNameAttr(::mlir::StringAttr attr) {
    getProperties().bindc_name = attr;
  }

  void setBindcName(::std::optional<::llvm::StringRef> attrValue);
  void setDataAttrAttr(::cuf::DataAttributeAttr attr) {
    getProperties().data_attr = attr;
  }

  void setDataAttr(::cuf::DataAttribute attrValue);
  ::mlir::Attribute removeUniqNameAttr() {
      auto attr = getProperties().uniq_name;
      getProperties().uniq_name = {};
      return attr;
  }

  ::mlir::Attribute removeBindcNameAttr() {
      auto attr = getProperties().bindc_name;
      getProperties().bindc_name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, cuf::DataAttributeAttr cudaAttr, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, cuf::DataAttributeAttr cudaAttr, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, cuf::DataAttributeAttr cudaAttr, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr);
  static AllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr);
  static AllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr);
  static AllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr);
  static AllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr);
  static AllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr);
  static AllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr);
  static AllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr);
  static AllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::AllocOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::AllocateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AllocateOpGenericAdaptorBase {
public:
  struct Properties {
    using data_attrTy = ::cuf::DataAttributeAttr;
    data_attrTy data_attr;

    auto getDataAttr() const {
      auto &propStorage = this->data_attr;
      return ::llvm::cast<::cuf::DataAttributeAttr>(propStorage);
    }
    void setDataAttr(const ::cuf::DataAttributeAttr &propValue) {
      this->data_attr = propValue;
    }
    using hasStatTy = ::mlir::UnitAttr;
    hasStatTy hasStat;

    auto getHasStat() const {
      auto &propStorage = this->hasStat;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setHasStat(const ::mlir::UnitAttr &propValue) {
      this->hasStat = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data_attr == this->data_attr &&
        rhs.hasStat == this->hasStat &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllocateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.allocate", odsAttrs.getContext());
  }

  AllocateOpGenericAdaptorBase(AllocateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::cuf::DataAttributeAttr getDataAttrAttr() {
    auto attr = ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
    return attr;
  }

  ::cuf::DataAttribute getDataAttr();
  ::mlir::UnitAttr getHasStatAttr();
  bool getHasStat();
};
} // namespace detail
template <typename RangeT>
class AllocateOpGenericAdaptor : public detail::AllocateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllocateOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
  static constexpr int odsIndex_errmsg = 1;
  static constexpr int odsIndex_stream = 2;
  static constexpr int odsIndex_pinned = 3;
  static constexpr int odsIndex_source = 4;
public:
  AllocateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllocateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllocateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllocateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : AllocateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllocateOpGenericAdaptor(RangeT values, const AllocateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllocateOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllocateOp>>>
  AllocateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  ValueT getErrmsg() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getStream() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getPinned() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getSource() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AllocateOpAdaptor : public AllocateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllocateOpGenericAdaptor::AllocateOpGenericAdaptor;
  AllocateOpAdaptor(AllocateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllocateOp : public ::mlir::Op<AllocateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllocateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllocateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  static constexpr int odsIndex_errmsg = 1;
  static constexpr int odsIndex_stream = 2;
  static constexpr int odsIndex_pinned = 3;
  static constexpr int odsIndex_source = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("data_attr"), ::llvm::StringRef("hasStat"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDataAttrAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDataAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getHasStatAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getHasStatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.allocate");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::ReferenceType> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getErrmsg() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::fir::ReferenceType> getStream() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::fir::ReferenceType>{} : ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getPinned() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSource() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getErrmsgMutable();
  ::mlir::MutableOperandRange getStreamMutable();
  ::mlir::MutableOperandRange getPinnedMutable();
  ::mlir::MutableOperandRange getSourceMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getStat() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    return ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
  }

  ::cuf::DataAttribute getDataAttr();
  ::mlir::UnitAttr getHasStatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasStat);
  }

  bool getHasStat();
  void setDataAttrAttr(::cuf::DataAttributeAttr attr) {
    getProperties().data_attr = attr;
  }

  void setDataAttr(::cuf::DataAttribute attrValue);
  void setHasStatAttr(::mlir::UnitAttr attr) {
    getProperties().hasStat = attr;
  }

  void setHasStat(bool attrValue);
  ::mlir::Attribute removeHasStatAttr() {
      auto attr = getProperties().hasStat;
      getProperties().hasStat = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static AllocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static AllocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static AllocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static AllocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static AllocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static AllocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static AllocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static AllocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::AllocateOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::DataTransferOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DataTransferOpGenericAdaptorBase {
public:
  struct Properties {
    using transfer_kindTy = ::cuf::DataTransferKindAttr;
    transfer_kindTy transfer_kind;

    auto getTransferKind() const {
      auto &propStorage = this->transfer_kind;
      return ::llvm::cast<::cuf::DataTransferKindAttr>(propStorage);
    }
    void setTransferKind(const ::cuf::DataTransferKindAttr &propValue) {
      this->transfer_kind = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.transfer_kind == this->transfer_kind &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DataTransferOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.data_transfer", odsAttrs.getContext());
  }

  DataTransferOpGenericAdaptorBase(DataTransferOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::cuf::DataTransferKindAttr getTransferKindAttr() {
    auto attr = ::llvm::cast<::cuf::DataTransferKindAttr>(getProperties().transfer_kind);
    return attr;
  }

  ::cuf::DataTransferKind getTransferKind();
};
} // namespace detail
template <typename RangeT>
class DataTransferOpGenericAdaptor : public detail::DataTransferOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DataTransferOpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_dst = 1;
  static constexpr int odsIndex_shape = 2;
public:
  DataTransferOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DataTransferOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DataTransferOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DataTransferOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DataTransferOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DataTransferOpGenericAdaptor(RangeT values, const DataTransferOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DataTransferOp, typename = std::enable_if_t<std::is_same_v<LateInst, DataTransferOp>>>
  DataTransferOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDst() {
    return (*getODSOperands(1).begin());
  }

  ValueT getShape() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DataTransferOpAdaptor : public DataTransferOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DataTransferOpGenericAdaptor::DataTransferOpGenericAdaptor;
  DataTransferOpAdaptor(DataTransferOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DataTransferOp : public ::mlir::Op<DataTransferOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DataTransferOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DataTransferOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_dst = 1;
  static constexpr int odsIndex_shape = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("transfer_kind")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTransferKindAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTransferKindAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.data_transfer");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getShape() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDstMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::cuf::DataTransferKindAttr getTransferKindAttr() {
    return ::llvm::cast<::cuf::DataTransferKindAttr>(getProperties().transfer_kind);
  }

  ::cuf::DataTransferKind getTransferKind();
  void setTransferKindAttr(::cuf::DataTransferKindAttr attr) {
    getProperties().transfer_kind = attr;
  }

  void setTransferKind(::cuf::DataTransferKind attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind);
  static DataTransferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind);
  static DataTransferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind);
  static DataTransferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind);
  static DataTransferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind);
  static DataTransferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind);
  static DataTransferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind);
  static DataTransferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind);
  static DataTransferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DataTransferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DataTransferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DataTransferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DataTransferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::DataTransferOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::DeallocateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DeallocateOpGenericAdaptorBase {
public:
  struct Properties {
    using data_attrTy = ::cuf::DataAttributeAttr;
    data_attrTy data_attr;

    auto getDataAttr() const {
      auto &propStorage = this->data_attr;
      return ::llvm::cast<::cuf::DataAttributeAttr>(propStorage);
    }
    void setDataAttr(const ::cuf::DataAttributeAttr &propValue) {
      this->data_attr = propValue;
    }
    using hasStatTy = ::mlir::UnitAttr;
    hasStatTy hasStat;

    auto getHasStat() const {
      auto &propStorage = this->hasStat;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setHasStat(const ::mlir::UnitAttr &propValue) {
      this->hasStat = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data_attr == this->data_attr &&
        rhs.hasStat == this->hasStat &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeallocateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.deallocate", odsAttrs.getContext());
  }

  DeallocateOpGenericAdaptorBase(DeallocateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::cuf::DataAttributeAttr getDataAttrAttr() {
    auto attr = ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
    return attr;
  }

  ::cuf::DataAttribute getDataAttr();
  ::mlir::UnitAttr getHasStatAttr();
  bool getHasStat();
};
} // namespace detail
template <typename RangeT>
class DeallocateOpGenericAdaptor : public detail::DeallocateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeallocateOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
  static constexpr int odsIndex_errmsg = 1;
public:
  DeallocateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeallocateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeallocateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeallocateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DeallocateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeallocateOpGenericAdaptor(RangeT values, const DeallocateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeallocateOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeallocateOp>>>
  DeallocateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  ValueT getErrmsg() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeallocateOpAdaptor : public DeallocateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeallocateOpGenericAdaptor::DeallocateOpGenericAdaptor;
  DeallocateOpAdaptor(DeallocateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeallocateOp : public ::mlir::Op<DeallocateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeallocateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeallocateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  static constexpr int odsIndex_errmsg = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("data_attr"), ::llvm::StringRef("hasStat")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDataAttrAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDataAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getHasStatAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getHasStatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.deallocate");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::ReferenceType> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getErrmsg() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getErrmsgMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getStat() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    return ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
  }

  ::cuf::DataAttribute getDataAttr();
  ::mlir::UnitAttr getHasStatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasStat);
  }

  bool getHasStat();
  void setDataAttrAttr(::cuf::DataAttributeAttr attr) {
    getProperties().data_attr = attr;
  }

  void setDataAttr(::cuf::DataAttribute attrValue);
  void setHasStatAttr(::mlir::UnitAttr attr) {
    getProperties().hasStat = attr;
  }

  void setHasStat(bool attrValue);
  ::mlir::Attribute removeHasStatAttr() {
      auto attr = getProperties().hasStat;
      getProperties().hasStat = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static DeallocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static DeallocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static DeallocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static DeallocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static DeallocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static DeallocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static DeallocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static DeallocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeallocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeallocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeallocateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeallocateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::DeallocateOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::DeviceAddressOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DeviceAddressOpGenericAdaptorBase {
public:
  struct Properties {
    using hostSymbolTy = ::mlir::SymbolRefAttr;
    hostSymbolTy hostSymbol;

    auto getHostSymbol() const {
      auto &propStorage = this->hostSymbol;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setHostSymbol(const ::mlir::SymbolRefAttr &propValue) {
      this->hostSymbol = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.hostSymbol == this->hostSymbol &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeviceAddressOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.device_address", odsAttrs.getContext());
  }

  DeviceAddressOpGenericAdaptorBase(DeviceAddressOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getHostSymbolAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().hostSymbol);
    return attr;
  }

  ::mlir::SymbolRefAttr getHostSymbol();
};
} // namespace detail
template <typename RangeT>
class DeviceAddressOpGenericAdaptor : public detail::DeviceAddressOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeviceAddressOpGenericAdaptorBase;
public:
  DeviceAddressOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeviceAddressOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeviceAddressOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeviceAddressOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DeviceAddressOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeviceAddressOpGenericAdaptor(RangeT values, const DeviceAddressOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeviceAddressOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeviceAddressOp>>>
  DeviceAddressOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeviceAddressOpAdaptor : public DeviceAddressOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeviceAddressOpGenericAdaptor::DeviceAddressOpGenericAdaptor;
  DeviceAddressOpAdaptor(DeviceAddressOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeviceAddressOp : public ::mlir::Op<DeviceAddressOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::ReferenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeviceAddressOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeviceAddressOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("hostSymbol")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getHostSymbolAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getHostSymbolAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.device_address");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::ReferenceType> getAddr() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getHostSymbolAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().hostSymbol);
  }

  ::mlir::SymbolRefAttr getHostSymbol();
  void setHostSymbolAttr(::mlir::SymbolRefAttr attr) {
    getProperties().hostSymbol = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type addr, ::mlir::SymbolRefAttr hostSymbol);
  static DeviceAddressOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type addr, ::mlir::SymbolRefAttr hostSymbol);
  static DeviceAddressOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type addr, ::mlir::SymbolRefAttr hostSymbol);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr hostSymbol);
  static DeviceAddressOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr hostSymbol);
  static DeviceAddressOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr hostSymbol);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeviceAddressOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeviceAddressOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeviceAddressOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeviceAddressOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::DeviceAddressOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::FreeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class FreeOpGenericAdaptorBase {
public:
  struct Properties {
    using data_attrTy = ::cuf::DataAttributeAttr;
    data_attrTy data_attr;

    auto getDataAttr() const {
      auto &propStorage = this->data_attr;
      return ::llvm::cast<::cuf::DataAttributeAttr>(propStorage);
    }
    void setDataAttr(const ::cuf::DataAttributeAttr &propValue) {
      this->data_attr = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data_attr == this->data_attr &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FreeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.free", odsAttrs.getContext());
  }

  FreeOpGenericAdaptorBase(FreeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::cuf::DataAttributeAttr getDataAttrAttr() {
    auto attr = ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
    return attr;
  }

  ::cuf::DataAttribute getDataAttr();
};
} // namespace detail
template <typename RangeT>
class FreeOpGenericAdaptor : public detail::FreeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FreeOpGenericAdaptorBase;
  static constexpr int odsIndex_devptr = 0;
public:
  FreeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FreeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FreeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FreeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FreeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FreeOpGenericAdaptor(RangeT values, const FreeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FreeOp, typename = std::enable_if_t<std::is_same_v<LateInst, FreeOp>>>
  FreeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getDevptr() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FreeOpAdaptor : public FreeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FreeOpGenericAdaptor::FreeOpGenericAdaptor;
  FreeOpAdaptor(FreeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FreeOp : public ::mlir::Op<FreeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FreeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FreeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_devptr = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("data_attr")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDataAttrAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDataAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.free");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDevptr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getDevptrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    return ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
  }

  ::cuf::DataAttribute getDataAttr();
  void setDataAttrAttr(::cuf::DataAttributeAttr attr) {
    getProperties().data_attr = attr;
  }

  void setDataAttr(::cuf::DataAttribute attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr);
  static FreeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr);
  static FreeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr);
  static FreeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr);
  static FreeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value devptr, ::cuf::DataAttribute data_attr);
  static FreeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value devptr, ::cuf::DataAttribute data_attr);
  static FreeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value devptr, ::cuf::DataAttribute data_attr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttribute data_attr);
  static FreeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttribute data_attr);
  static FreeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttribute data_attr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FreeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FreeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FreeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FreeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::FreeOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::KernelLaunchOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class KernelLaunchOpGenericAdaptorBase {
public:
  struct Properties {
    using arg_attrsTy = ::mlir::ArrayAttr;
    arg_attrsTy arg_attrs;

    auto getArgAttrs() const {
      auto &propStorage = this->arg_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setArgAttrs(const ::mlir::ArrayAttr &propValue) {
      this->arg_attrs = propValue;
    }
    using calleeTy = ::mlir::SymbolRefAttr;
    calleeTy callee;

    auto getCallee() const {
      auto &propStorage = this->callee;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setCallee(const ::mlir::SymbolRefAttr &propValue) {
      this->callee = propValue;
    }
    using res_attrsTy = ::mlir::ArrayAttr;
    res_attrsTy res_attrs;

    auto getResAttrs() const {
      auto &propStorage = this->res_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setResAttrs(const ::mlir::ArrayAttr &propValue) {
      this->res_attrs = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 9>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.arg_attrs == this->arg_attrs &&
        rhs.callee == this->callee &&
        rhs.res_attrs == this->res_attrs &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  KernelLaunchOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.kernel_launch", odsAttrs.getContext());
  }

  KernelLaunchOpGenericAdaptorBase(KernelLaunchOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getCalleeAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().callee);
    return attr;
  }

  ::mlir::SymbolRefAttr getCallee();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
};
} // namespace detail
template <typename RangeT>
class KernelLaunchOpGenericAdaptor : public detail::KernelLaunchOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::KernelLaunchOpGenericAdaptorBase;
  static constexpr int odsIndex_grid_x = 0;
  static constexpr int odsIndex_grid_y = 1;
  static constexpr int odsIndex_grid_z = 2;
  static constexpr int odsIndex_block_x = 3;
  static constexpr int odsIndex_block_y = 4;
  static constexpr int odsIndex_block_z = 5;
  static constexpr int odsIndex_bytes = 6;
  static constexpr int odsIndex_stream = 7;
  static constexpr int odsIndex_args = 8;
public:
  KernelLaunchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  KernelLaunchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : KernelLaunchOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  KernelLaunchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : KernelLaunchOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  KernelLaunchOpGenericAdaptor(RangeT values, const KernelLaunchOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = KernelLaunchOp, typename = std::enable_if_t<std::is_same_v<LateInst, KernelLaunchOp>>>
  KernelLaunchOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getGridX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getGridY() {
    return (*getODSOperands(1).begin());
  }

  ValueT getGridZ() {
    return (*getODSOperands(2).begin());
  }

  ValueT getBlockX() {
    return (*getODSOperands(3).begin());
  }

  ValueT getBlockY() {
    return (*getODSOperands(4).begin());
  }

  ValueT getBlockZ() {
    return (*getODSOperands(5).begin());
  }

  ValueT getBytes() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getStream() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getArgs() {
    return getODSOperands(8);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class KernelLaunchOpAdaptor : public KernelLaunchOpGenericAdaptor<::mlir::ValueRange> {
public:
  using KernelLaunchOpGenericAdaptor::KernelLaunchOpGenericAdaptor;
  KernelLaunchOpAdaptor(KernelLaunchOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class KernelLaunchOp : public ::mlir::Op<KernelLaunchOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<6>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ArgAndResultAttrsOpInterface::Trait, ::mlir::CallOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = KernelLaunchOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = KernelLaunchOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_grid_x = 0;
  static constexpr int odsIndex_grid_y = 1;
  static constexpr int odsIndex_grid_z = 2;
  static constexpr int odsIndex_block_x = 3;
  static constexpr int odsIndex_block_y = 4;
  static constexpr int odsIndex_block_z = 5;
  static constexpr int odsIndex_bytes = 6;
  static constexpr int odsIndex_stream = 7;
  static constexpr int odsIndex_args = 8;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("arg_attrs"), ::llvm::StringRef("callee"), ::llvm::StringRef("res_attrs"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getArgAttrsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getArgAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getCalleeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getCalleeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getResAttrsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getResAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.kernel_launch");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getGridX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getGridY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getGridZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getBlockX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getBlockY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(4).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getBlockZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(5).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getBytes() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::fir::ReferenceType> getStream() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ::mlir::TypedValue<::fir::ReferenceType>{} : ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getArgs() {
    return getODSOperands(8);
  }

  ::mlir::OpOperand &getGridXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getGridYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getGridZMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBlockXMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBlockYMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBlockZMutable() {
    auto range = getODSOperandIndexAndLength(5);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getBytesMutable();
  ::mlir::MutableOperandRange getStreamMutable();
  ::mlir::MutableOperandRange getArgsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getCalleeAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().callee);
  }

  ::mlir::SymbolRefAttr getCallee();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  void setCalleeAttr(::mlir::SymbolRefAttr attr) {
    getProperties().callee = attr;
  }

  void setArgAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().arg_attrs = attr;
  }

  void setResAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().res_attrs = attr;
  }

  ::mlir::Attribute removeArgAttrsAttr() {
      auto attr = getProperties().arg_attrs;
      getProperties().arg_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeResAttrsAttr() {
      auto attr = getProperties().res_attrs;
      getProperties().res_attrs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static KernelLaunchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static KernelLaunchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static KernelLaunchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static KernelLaunchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KernelLaunchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KernelLaunchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KernelLaunchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KernelLaunchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  mlir::CallInterfaceCallable getCallableForCallee() {
    return getCalleeAttr();
  }

  void setCalleeFromCallable(mlir::CallInterfaceCallable callee) {
    (*this)->setAttr(getCalleeAttrName(),
                     llvm::cast<mlir::SymbolRefAttr>(callee));
  }
  mlir::FunctionType getFunctionType();

  unsigned getNbNoArgOperand() {
    unsigned nbNoArgOperand = 5; // grids and blocks values are always present.
    if (getBytes()) ++nbNoArgOperand;
    if (getStream()) ++nbNoArgOperand;
    return nbNoArgOperand;
  }

  operand_range getArgOperands() {
    return {operand_begin() + getNbNoArgOperand(), operand_end()};
  }
  mlir::MutableOperandRange getArgOperandsMutable() {
    return mlir::MutableOperandRange(
        *this, getNbNoArgOperand(), getArgs().size() - 1);
  }
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::KernelLaunchOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::KernelOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class KernelOpGenericAdaptorBase {
public:
  struct Properties {
    using nTy = ::mlir::IntegerAttr;
    nTy n;

    auto getN() const {
      auto &propStorage = this->n;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setN(const ::mlir::IntegerAttr &propValue) {
      this->n = propValue;
    }
    using reduceAttrsTy = ::mlir::ArrayAttr;
    reduceAttrsTy reduceAttrs;

    auto getReduceAttrs() const {
      auto &propStorage = this->reduceAttrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setReduceAttrs(const ::mlir::ArrayAttr &propValue) {
      this->reduceAttrs = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 7>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.n == this->n &&
        rhs.reduceAttrs == this->reduceAttrs &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  KernelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.kernel", odsAttrs.getContext());
  }

  KernelOpGenericAdaptorBase(KernelOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getNAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().n);
    return attr;
  }

  ::std::optional<uint64_t> getN();
  ::mlir::ArrayAttr getReduceAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reduceAttrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getReduceAttrs();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class KernelOpGenericAdaptor : public detail::KernelOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::KernelOpGenericAdaptorBase;
  static constexpr int odsIndex_grid = 0;
  static constexpr int odsIndex_block = 1;
  static constexpr int odsIndex_stream = 2;
  static constexpr int odsIndex_lowerbound = 3;
  static constexpr int odsIndex_upperbound = 4;
  static constexpr int odsIndex_step = 5;
  static constexpr int odsIndex_reduceOperands = 6;
public:
  KernelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  KernelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : KernelOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  KernelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : KernelOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  KernelOpGenericAdaptor(RangeT values, const KernelOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = KernelOp, typename = std::enable_if_t<std::is_same_v<LateInst, KernelOp>>>
  KernelOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getGrid() {
    return getODSOperands(0);
  }

  RangeT getBlock() {
    return getODSOperands(1);
  }

  ValueT getStream() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getLowerbound() {
    return getODSOperands(3);
  }

  RangeT getUpperbound() {
    return getODSOperands(4);
  }

  RangeT getStep() {
    return getODSOperands(5);
  }

  RangeT getReduceOperands() {
    return getODSOperands(6);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class KernelOpAdaptor : public KernelOpGenericAdaptor<::mlir::ValueRange> {
public:
  using KernelOpGenericAdaptor::KernelOpGenericAdaptor;
  KernelOpAdaptor(KernelOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class KernelOp : public ::mlir::Op<KernelOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LoopLikeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = KernelOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = KernelOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_grid = 0;
  static constexpr int odsIndex_block = 1;
  static constexpr int odsIndex_stream = 2;
  static constexpr int odsIndex_lowerbound = 3;
  static constexpr int odsIndex_upperbound = 4;
  static constexpr int odsIndex_step = 5;
  static constexpr int odsIndex_reduceOperands = 6;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("n"), ::llvm::StringRef("reduceAttrs"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReduceAttrsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReduceAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.kernel");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getGrid() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getBlock() {
    return getODSOperands(1);
  }

  ::mlir::TypedValue<::fir::ReferenceType> getStream() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::fir::ReferenceType>{} : ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getLowerbound() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getUpperbound() {
    return getODSOperands(4);
  }

  ::mlir::Operation::operand_range getStep() {
    return getODSOperands(5);
  }

  ::mlir::Operation::operand_range getReduceOperands() {
    return getODSOperands(6);
  }

  ::mlir::MutableOperandRange getGridMutable();
  ::mlir::MutableOperandRange getBlockMutable();
  ::mlir::MutableOperandRange getStreamMutable();
  ::mlir::MutableOperandRange getLowerboundMutable();
  ::mlir::MutableOperandRange getUpperboundMutable();
  ::mlir::MutableOperandRange getStepMutable();
  ::mlir::MutableOperandRange getReduceOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getNAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().n);
  }

  ::std::optional<uint64_t> getN();
  ::mlir::ArrayAttr getReduceAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reduceAttrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getReduceAttrs();
  void setNAttr(::mlir::IntegerAttr attr) {
    getProperties().n = attr;
  }

  void setN(::std::optional<uint64_t> attrValue);
  void setReduceAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().reduceAttrs = attr;
  }

  ::mlir::Attribute removeNAttr() {
      auto attr = getProperties().n;
      getProperties().n = {};
      return attr;
  }

  ::mlir::Attribute removeReduceAttrsAttr() {
      auto attr = getProperties().reduceAttrs;
      getProperties().reduceAttrs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs);
  static KernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs);
  static KernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs);
  static KernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs);
  static KernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::SmallVector<::mlir::Region *> getLoopRegions();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Get Number of variadic operands
  unsigned getNumOperands(unsigned idx) {
    auto segments = (*this)->getAttrOfType<mlir::DenseI32ArrayAttr>(
      getOperandSegmentSizeAttr());
    return static_cast<unsigned>(segments[idx]);
  }
  // Get Number of reduction operands
  unsigned getNumReduceOperands() {
    return getNumOperands(7);
  }
  /// Does the operation hold operands for reduction variables
  bool hasReduceOperands() {
    return getNumReduceOperands() > 0;
  }
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::KernelOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::RegisterKernelOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RegisterKernelOpGenericAdaptorBase {
public:
  struct Properties {
    using nameTy = ::mlir::SymbolRefAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setName(const ::mlir::SymbolRefAttr &propValue) {
      this->name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.name == this->name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RegisterKernelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.register_kernel", odsAttrs.getContext());
  }

  RegisterKernelOpGenericAdaptorBase(RegisterKernelOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getNameAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().name);
    return attr;
  }

  ::mlir::SymbolRefAttr getName();
};
} // namespace detail
template <typename RangeT>
class RegisterKernelOpGenericAdaptor : public detail::RegisterKernelOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RegisterKernelOpGenericAdaptorBase;
  static constexpr int odsIndex_modulePtr = 0;
public:
  RegisterKernelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RegisterKernelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RegisterKernelOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RegisterKernelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RegisterKernelOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RegisterKernelOpGenericAdaptor(RangeT values, const RegisterKernelOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RegisterKernelOp, typename = std::enable_if_t<std::is_same_v<LateInst, RegisterKernelOp>>>
  RegisterKernelOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getModulePtr() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RegisterKernelOpAdaptor : public RegisterKernelOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RegisterKernelOpGenericAdaptor::RegisterKernelOpGenericAdaptor;
  RegisterKernelOpAdaptor(RegisterKernelOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RegisterKernelOp : public ::mlir::Op<RegisterKernelOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RegisterKernelOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RegisterKernelOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_modulePtr = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.register_kernel");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getModulePtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getModulePtrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getNameAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().name);
  }

  ::mlir::SymbolRefAttr getName();
  void setNameAttr(::mlir::SymbolRefAttr attr) {
    getProperties().name = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr);
  static RegisterKernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr);
  static RegisterKernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr);
  static RegisterKernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr);
  static RegisterKernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RegisterKernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RegisterKernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RegisterKernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RegisterKernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  mlir::StringAttr getKernelName();
  mlir::StringAttr getKernelModuleName();
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::RegisterKernelOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::RegisterModuleOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RegisterModuleOpGenericAdaptorBase {
public:
  struct Properties {
    using nameTy = ::mlir::SymbolRefAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setName(const ::mlir::SymbolRefAttr &propValue) {
      this->name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.name == this->name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RegisterModuleOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.register_module", odsAttrs.getContext());
  }

  RegisterModuleOpGenericAdaptorBase(RegisterModuleOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getNameAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().name);
    return attr;
  }

  ::mlir::SymbolRefAttr getName();
};
} // namespace detail
template <typename RangeT>
class RegisterModuleOpGenericAdaptor : public detail::RegisterModuleOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RegisterModuleOpGenericAdaptorBase;
public:
  RegisterModuleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RegisterModuleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RegisterModuleOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RegisterModuleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RegisterModuleOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RegisterModuleOpGenericAdaptor(RangeT values, const RegisterModuleOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RegisterModuleOp, typename = std::enable_if_t<std::is_same_v<LateInst, RegisterModuleOp>>>
  RegisterModuleOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RegisterModuleOpAdaptor : public RegisterModuleOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RegisterModuleOpGenericAdaptor::RegisterModuleOpGenericAdaptor;
  RegisterModuleOpAdaptor(RegisterModuleOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RegisterModuleOp : public ::mlir::Op<RegisterModuleOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::LLVM::LLVMPointerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RegisterModuleOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RegisterModuleOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.register_module");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getModulePtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getNameAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().name);
  }

  ::mlir::SymbolRefAttr getName();
  void setNameAttr(::mlir::SymbolRefAttr attr) {
    getProperties().name = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type modulePtr, ::mlir::SymbolRefAttr name);
  static RegisterModuleOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type modulePtr, ::mlir::SymbolRefAttr name);
  static RegisterModuleOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type modulePtr, ::mlir::SymbolRefAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name);
  static RegisterModuleOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name);
  static RegisterModuleOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RegisterModuleOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RegisterModuleOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RegisterModuleOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RegisterModuleOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::RegisterModuleOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::SetAllocatorIndexOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class SetAllocatorIndexOpGenericAdaptorBase {
public:
  struct Properties {
    using data_attrTy = ::cuf::DataAttributeAttr;
    data_attrTy data_attr;

    auto getDataAttr() const {
      auto &propStorage = this->data_attr;
      return ::llvm::cast<::cuf::DataAttributeAttr>(propStorage);
    }
    void setDataAttr(const ::cuf::DataAttributeAttr &propValue) {
      this->data_attr = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data_attr == this->data_attr &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  SetAllocatorIndexOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.set_allocator_idx", odsAttrs.getContext());
  }

  SetAllocatorIndexOpGenericAdaptorBase(SetAllocatorIndexOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::cuf::DataAttributeAttr getDataAttrAttr() {
    auto attr = ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
    return attr;
  }

  ::cuf::DataAttribute getDataAttr();
};
} // namespace detail
template <typename RangeT>
class SetAllocatorIndexOpGenericAdaptor : public detail::SetAllocatorIndexOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::SetAllocatorIndexOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
public:
  SetAllocatorIndexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  SetAllocatorIndexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : SetAllocatorIndexOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  SetAllocatorIndexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : SetAllocatorIndexOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  SetAllocatorIndexOpGenericAdaptor(RangeT values, const SetAllocatorIndexOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = SetAllocatorIndexOp, typename = std::enable_if_t<std::is_same_v<LateInst, SetAllocatorIndexOp>>>
  SetAllocatorIndexOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class SetAllocatorIndexOpAdaptor : public SetAllocatorIndexOpGenericAdaptor<::mlir::ValueRange> {
public:
  using SetAllocatorIndexOpGenericAdaptor::SetAllocatorIndexOpGenericAdaptor;
  SetAllocatorIndexOpAdaptor(SetAllocatorIndexOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class SetAllocatorIndexOp : public ::mlir::Op<SetAllocatorIndexOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = SetAllocatorIndexOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = SetAllocatorIndexOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("data_attr")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDataAttrAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDataAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.set_allocator_idx");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::ReferenceType> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    return ::llvm::cast<::cuf::DataAttributeAttr>(getProperties().data_attr);
  }

  ::cuf::DataAttribute getDataAttr();
  void setDataAttrAttr(::cuf::DataAttributeAttr attr) {
    getProperties().data_attr = attr;
  }

  void setDataAttr(::cuf::DataAttribute attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value box, ::cuf::DataAttributeAttr data_attr);
  static SetAllocatorIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value box, ::cuf::DataAttributeAttr data_attr);
  static SetAllocatorIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value box, ::cuf::DataAttributeAttr data_attr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::cuf::DataAttributeAttr data_attr);
  static SetAllocatorIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::cuf::DataAttributeAttr data_attr);
  static SetAllocatorIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::cuf::DataAttributeAttr data_attr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value box, ::cuf::DataAttribute data_attr);
  static SetAllocatorIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value box, ::cuf::DataAttribute data_attr);
  static SetAllocatorIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value box, ::cuf::DataAttribute data_attr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::cuf::DataAttribute data_attr);
  static SetAllocatorIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::cuf::DataAttribute data_attr);
  static SetAllocatorIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::cuf::DataAttribute data_attr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SetAllocatorIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SetAllocatorIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SetAllocatorIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SetAllocatorIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::SetAllocatorIndexOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::SharedMemoryOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class SharedMemoryOpGenericAdaptorBase {
public:
  struct Properties {
    using bindc_nameTy = ::mlir::StringAttr;
    bindc_nameTy bindc_name;

    auto getBindcName() const {
      auto &propStorage = this->bindc_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setBindcName(const ::mlir::StringAttr &propValue) {
      this->bindc_name = propValue;
    }
    using in_typeTy = ::mlir::TypeAttr;
    in_typeTy in_type;

    auto getInType() const {
      auto &propStorage = this->in_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setInType(const ::mlir::TypeAttr &propValue) {
      this->in_type = propValue;
    }
    using uniq_nameTy = ::mlir::StringAttr;
    uniq_nameTy uniq_name;

    auto getUniqName() const {
      auto &propStorage = this->uniq_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setUniqName(const ::mlir::StringAttr &propValue) {
      this->uniq_name = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.bindc_name == this->bindc_name &&
        rhs.in_type == this->in_type &&
        rhs.uniq_name == this->uniq_name &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  SharedMemoryOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.shared_memory", odsAttrs.getContext());
  }

  SharedMemoryOpGenericAdaptorBase(SharedMemoryOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getInTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().in_type);
    return attr;
  }

  ::mlir::Type getInType();
  ::mlir::StringAttr getUniqNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().uniq_name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getUniqName();
  ::mlir::StringAttr getBindcNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().bindc_name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getBindcName();
};
} // namespace detail
template <typename RangeT>
class SharedMemoryOpGenericAdaptor : public detail::SharedMemoryOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::SharedMemoryOpGenericAdaptorBase;
  static constexpr int odsIndex_typeparams = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_offset = 2;
public:
  SharedMemoryOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  SharedMemoryOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : SharedMemoryOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  SharedMemoryOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : SharedMemoryOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  SharedMemoryOpGenericAdaptor(RangeT values, const SharedMemoryOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = SharedMemoryOp, typename = std::enable_if_t<std::is_same_v<LateInst, SharedMemoryOp>>>
  SharedMemoryOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getTypeparams() {
    return getODSOperands(0);
  }

  RangeT getShape() {
    return getODSOperands(1);
  }

  ValueT getOffset() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class SharedMemoryOpAdaptor : public SharedMemoryOpGenericAdaptor<::mlir::ValueRange> {
public:
  using SharedMemoryOpGenericAdaptor::SharedMemoryOpGenericAdaptor;
  SharedMemoryOpAdaptor(SharedMemoryOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class SharedMemoryOp : public ::mlir::Op<SharedMemoryOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::ReferenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = SharedMemoryOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = SharedMemoryOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_typeparams = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_offset = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("bindc_name"), ::llvm::StringRef("in_type"), ::llvm::StringRef("uniq_name"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBindcNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBindcNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getInTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getInTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getUniqNameAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getUniqNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.shared_memory");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getShape() {
    return getODSOperands(1);
  }

  ::mlir::TypedValue<::mlir::Type> getOffset() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::MutableOperandRange getTypeparamsMutable();
  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getOffsetMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::ReferenceType> getPtr() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getInTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().in_type);
  }

  ::mlir::Type getInType();
  ::mlir::StringAttr getUniqNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().uniq_name);
  }

  ::std::optional< ::llvm::StringRef > getUniqName();
  ::mlir::StringAttr getBindcNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().bindc_name);
  }

  ::std::optional< ::llvm::StringRef > getBindcName();
  void setInTypeAttr(::mlir::TypeAttr attr) {
    getProperties().in_type = attr;
  }

  void setInType(::mlir::Type attrValue);
  void setUniqNameAttr(::mlir::StringAttr attr) {
    getProperties().uniq_name = attr;
  }

  void setUniqName(::std::optional<::llvm::StringRef> attrValue);
  void setBindcNameAttr(::mlir::StringAttr attr) {
    getProperties().bindc_name = attr;
  }

  void setBindcName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeUniqNameAttr() {
      auto attr = getProperties().uniq_name;
      getProperties().uniq_name = {};
      return attr;
  }

  ::mlir::Attribute removeBindcNameAttr() {
      auto attr = getProperties().bindc_name;
      getProperties().bindc_name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static SharedMemoryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static SharedMemoryOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static SharedMemoryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static SharedMemoryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static SharedMemoryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static SharedMemoryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static SharedMemoryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static SharedMemoryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static SharedMemoryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static SharedMemoryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SharedMemoryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SharedMemoryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SharedMemoryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SharedMemoryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::SharedMemoryOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::StreamCastOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class StreamCastOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  StreamCastOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.stream_cast", odsAttrs.getContext());
  }

  StreamCastOpGenericAdaptorBase(StreamCastOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class StreamCastOpGenericAdaptor : public detail::StreamCastOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::StreamCastOpGenericAdaptorBase;
  static constexpr int odsIndex_stream = 0;
public:
  StreamCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  StreamCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : StreamCastOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  StreamCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : StreamCastOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  StreamCastOpGenericAdaptor(RangeT values, const StreamCastOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = StreamCastOp, typename = std::enable_if_t<std::is_same_v<LateInst, StreamCastOp>>>
  StreamCastOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getStream() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class StreamCastOpAdaptor : public StreamCastOpGenericAdaptor<::mlir::ValueRange> {
public:
  using StreamCastOpGenericAdaptor::StreamCastOpGenericAdaptor;
  StreamCastOpAdaptor(StreamCastOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class StreamCastOp : public ::mlir::Op<StreamCastOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = StreamCastOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = StreamCastOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_stream = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.stream_cast");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getStream() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getStreamMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getToken() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type token, ::mlir::Value stream);
  static StreamCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type token, ::mlir::Value stream);
  static StreamCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type token, ::mlir::Value stream);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value stream);
  static StreamCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value stream);
  static StreamCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value stream);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value stream);
  static StreamCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value stream);
  static StreamCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value stream);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static StreamCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static StreamCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static StreamCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static StreamCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static StreamCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static StreamCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static StreamCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static StreamCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::StreamCastOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::SyncDescriptorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class SyncDescriptorOpGenericAdaptorBase {
public:
  struct Properties {
    using globalNameTy = ::mlir::SymbolRefAttr;
    globalNameTy globalName;

    auto getGlobalName() const {
      auto &propStorage = this->globalName;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setGlobalName(const ::mlir::SymbolRefAttr &propValue) {
      this->globalName = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.globalName == this->globalName &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  SyncDescriptorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("cuf.sync_descriptor", odsAttrs.getContext());
  }

  SyncDescriptorOpGenericAdaptorBase(SyncDescriptorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getGlobalNameAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().globalName);
    return attr;
  }

  ::mlir::SymbolRefAttr getGlobalName();
};
} // namespace detail
template <typename RangeT>
class SyncDescriptorOpGenericAdaptor : public detail::SyncDescriptorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::SyncDescriptorOpGenericAdaptorBase;
public:
  SyncDescriptorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  SyncDescriptorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : SyncDescriptorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  SyncDescriptorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : SyncDescriptorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  SyncDescriptorOpGenericAdaptor(RangeT values, const SyncDescriptorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = SyncDescriptorOp, typename = std::enable_if_t<std::is_same_v<LateInst, SyncDescriptorOp>>>
  SyncDescriptorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class SyncDescriptorOpAdaptor : public SyncDescriptorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using SyncDescriptorOpGenericAdaptor::SyncDescriptorOpGenericAdaptor;
  SyncDescriptorOpAdaptor(SyncDescriptorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class SyncDescriptorOp : public ::mlir::Op<SyncDescriptorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = SyncDescriptorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = SyncDescriptorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("globalName")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getGlobalNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getGlobalNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("cuf.sync_descriptor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getGlobalNameAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().globalName);
  }

  ::mlir::SymbolRefAttr getGlobalName();
  void setGlobalNameAttr(::mlir::SymbolRefAttr attr) {
    getProperties().globalName = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::SymbolRefAttr globalName);
  static SyncDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::SymbolRefAttr globalName);
  static SyncDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::SymbolRefAttr globalName);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr globalName);
  static SyncDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr globalName);
  static SyncDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr globalName);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SyncDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SyncDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SyncDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SyncDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace cuf
MLIR_DECLARE_EXPLICIT_TYPE_ID(::cuf::SyncDescriptorOp)


#endif  // GET_OP_CLASSES

