#if !defined  HAVE_WALSHQ_H__
#define       HAVE_WALSHQ_H__
// This file is part of the FXT library.
// Copyright (C) 2010, 2011 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.

#include "perm/revbinpermute.h"
#include "walsh/walshgray.h"
#include "walsh/grsnegate.h"
#include "fxttypes.h"


template <typename Type>
void walsh_q1(Type *f, ulong ldn)
// Walsh transform with sequencies of basis functions == n/2 or n/2-1
// Self-inverse.
//.
// the basis (sequency at end of lines, '*':=1, ' ':=-1)
//    0: [ * * *   * *   * * * *       *   * * *   * *   *       * * *   * ] (16)
//    1: [ * * *   * *   * * * *       *         *     *   * * *       *   ] (15)
//    2: [ * * *   * *   *       * * *   *       *     *         * * *   * ] (16)
//    3: [       *     *   * * *       *         *     *         * * *   * ] (15)
//    4: [ * * *       *         *     *   * * *       *   * * *   * *   * ] (16)
//    5: [ * * *       *         *     *         * * *   *       *     *   ] (15)
//    6: [       * * *   *       *     *   * * *       *         *     *   ] (16)
//    7: [ * * *       *   * * *   * *   * * * *       *         *     *   ] (15)
//    8: [ * *   *       * * *   * * * *   * *   *       *     *         * ] (16)
//    9: [ * *   *       * * *   * * * *       *   * * *   * *   * * * *   ] (15)
//   10: [ * *   *       *     *         *     *   * * *       *         * ] (16)
//   11: [     *   * * *   * *   * * * *       *   * * *       *         * ] (15)
//   12: [     *         * * *   *       *     *         *     *   * * *   ] (16)
//   13: [     *         * * *   *       * * *   * * * *   * *   *       * ] (15)
//   14: [ * *   * * * *   * *   *       *     *         * * *   *       * ] (16)
//   15: [     *         *     *   * * *       *         * * *   *       * ] (15)
//   16: [ *       *   * * *         *     *       *   * *   * * * *   * * ] (16)
//   17: [ *       *   * * *         *       * * *   *     *         *     ] (15)
//   18: [ *       *   * *   * * * *   * *   * * *   *       * * * *   * * ] (16)
//   19: [   * * *   *     *         *       * * *   *       * * * *   * * ] (15)
//   20: [ *         *       * * *   *     *         *     *       *   * * ] (16)
//   21: [ *         *       * * *   *       * * * *   * *   * * *   *     ] (15)
//   22: [   * * * *   * *   * * *   *     *         *       * * *   *     ] (16)
//   23: [ *         *     *       *   * * *         *       * * *   *     ] (15)
//   24: [   *     *         *       * * *   *     *       *   * * *       ] (16)
//   25: [   *     *         *       * * * *   * *   * * *   *       * * * ] (15)
//   26: [   *     *       *   * * *       *   * *   * * * *   * * *       ] (16)
//   27: [ *   * *   * * *   *       * * * *   * *   * * * *   * * *       ] (15)
//   28: [ *   * * *         *     *       *   * * *       *   * *   * * * ] (16)
//   29: [ *   * * *         *     *         *       * * *   *     *       ] (15)
//   30: [   *       * * *   *     *       *   * * *         *     *       ] (16)
//   31: [ *   * * *       *   * *   * * * *   * * *         *     *       ] (15)
//
{
    ulong n = 1UL << ldn;
    grs_negate(f, n);
    walsh_gray(f, ldn);
    revbin_permute(f, n);
}
// -------------------------


template <typename Type>
void walsh_q2(Type *f, ulong ldn)
// Walsh transform with sequencies of basis functions == n/2 or n/2-1
// Self-inverse.
//.
// The basis (sequency at end of lines, '*':=1, ' ':=-1):
//    0: [ * * *   * *   * * * *       *   * * *   * *   *       * * *   * ] (16)
//    1: [ * * *   * *   *       * * *   *       *     *         * * *   * ] (16)
//    2: [ * * *       *         *     *   * * *       *   * * *   * *   * ] (16)
//    3: [       * * *   *       *     *   * * *       *         *     *   ] (16)
//    4: [ * *   *       * * *   * * * *   * *   *       *     *         * ] (16)
//    5: [ * *   *       *     *         *     *   * * *       *         * ] (16)
//    6: [     *         * * *   *       *     *         *     *   * * *   ] (16)
//    7: [ * *   * * * *   * *   *       *     *         * * *   *       * ] (16)
//    8: [ *       *   * * *         *     *       *   * *   * * * *   * * ] (16)
//    9: [ *       *   * *   * * * *   * *   * * *   *       * * * *   * * ] (16)
//   10: [ *         *       * * *   *     *         *     *       *   * * ] (16)
//   11: [   * * * *   * *   * * *   *     *         *       * * *   *     ] (16)
//   12: [   *     *         *       * * *   *     *       *   * * *       ] (16)
//   13: [   *     *       *   * * *       *   * *   * * * *   * * *       ] (16)
//   14: [ *   * * *         *     *       *   * * *       *   * *   * * * ] (16)
//   15: [   *       * * *   *     *       *   * * *         *     *       ] (16)
//   16: [ *   * * *       *   * *   * * * *   * * *         *     *       ] (15)
//   17: [ *   * * *         *     *         *       * * *   *     *       ] (15)
//   18: [ *   * *   * * *   *       * * * *   * *   * * * *   * * *       ] (15)
//   19: [   *     *         *       * * * *   * *   * * *   *       * * * ] (15)
//   20: [ *         *     *       *   * * *         *       * * *   *     ] (15)
//   21: [ *         *       * * *   *       * * * *   * *   * * *   *     ] (15)
//   22: [   * * *   *     *         *       * * *   *       * * * *   * * ] (15)
//   23: [ *       *   * * *         *       * * *   *     *         *     ] (15)
//   24: [     *         *     *   * * *       *         * * *   *       * ] (15)
//   25: [     *         * * *   *       * * *   * * * *   * *   *       * ] (15)
//   26: [     *   * * *   * *   * * * *       *   * * *       *         * ] (15)
//   27: [ * *   *       * * *   * * * *       *   * * *   * *   * * * *   ] (15)
//   28: [ * * *       *   * * *   * *   * * * *       *         *     *   ] (15)
//   29: [ * * *       *         *     *         * * *   *       *     *   ] (15)
//   30: [       *     *   * * *       *         *     *         * * *   * ] (15)
//   31: [ * * *   * *   * * * *       *         *     *   * * *       *   ] (15)
{
    ulong n = 1UL << ldn;
    revbin_permute(f, n);
    grs_negate(f, n);
    walsh_gray(f, ldn);
// =^=
//    grs_negate(f, n);
//    revbin_permute(f, n);
//    walsh_gray(f, ldn);
}
// -------------------------


#endif  // !defined HAVE_WALSHQ_H__
