/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;

public class UndefinedStringIterator
implements Iterator<StringDataInstance>,
Iterable<StringDataInstance> {
    private static final int MAX_SANE_STRING_LENGTH = 0x100000;
    private final TaskMonitor monitor;
    private final Listing listing;
    private final Program program;
    private final Memory memory;
    private final AddressSet addrs;
    private final int charSize;
    private final int charAlignment;
    private final boolean breakOnRef;
    private final Address singleStringStart;
    private final AbstractStringDataType stringDataType;
    private final Settings stringSettings;
    private final long origAddrCount;
    private final byte[] buffer = new byte[64];
    private StringDataInstance currentItem;

    static AddressSet getSingleStringEndAddrRange(Program program, AddressSetView addrs) {
        Address endAddr;
        Address minAddr = addrs.getMinAddress();
        MemoryBlock memblock = program.getMemory().getBlock(minAddr);
        Address address = endAddr = memblock != null ? memblock.getEnd() : minAddr;
        if (endAddr.subtract(minAddr) > 0x100000L) {
            endAddr = minAddr.add(0x100000L);
        }
        return new AddressSet(minAddr, endAddr);
    }

    public UndefinedStringIterator(Program program, AddressSetView addrs, int charSize, int charAlignment, boolean breakOnRef, boolean singleStringMode, AbstractStringDataType stringDataType, Settings stringSettings, TaskMonitor monitor) {
        this.program = program;
        this.listing = program.getListing();
        this.memory = program.getMemory();
        this.addrs = new AddressSet(addrs);
        this.charSize = charSize;
        this.charAlignment = charAlignment;
        this.breakOnRef = breakOnRef;
        this.singleStringStart = singleStringMode ? addrs.getMinAddress() : null;
        this.stringDataType = stringDataType;
        this.stringSettings = stringSettings;
        this.monitor = monitor;
        this.origAddrCount = addrs.getNumAddresses();
        monitor.initialize(this.origAddrCount);
    }

    @Override
    public Iterator<StringDataInstance> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.currentItem == null) {
            this.currentItem = this.findNext();
        }
        return this.currentItem != null;
    }

    @Override
    public StringDataInstance next() {
        StringDataInstance result = this.currentItem;
        this.currentItem = null;
        return result;
    }

    private StringDataInstance findNext() {
        this.forceAlignment();
        while (!this.addrs.isEmpty()) {
            if (this.monitor.isCancelled()) {
                return null;
            }
            if (!this.findStartOfString()) break;
            this.monitor.setProgress(this.origAddrCount - this.addrs.getNumAddresses());
            Address addr = this.addrs.getMinAddress();
            Data undefData = this.listing.getDataAt(addr);
            if (undefData == null) break;
            Address eos = this.findEndOfString();
            if (this.monitor.isCancelled()) {
                return null;
            }
            this.addrs.deleteFromMin(eos);
            long length = eos.subtract(addr) + 1L;
            if (length < (long)this.charSize || length > 0x100000L) continue;
            StringDataInstance sdi = this.stringDataType.getStringDataInstance((MemBuffer)undefData, this.stringSettings, (int)length);
            return sdi;
        }
        return null;
    }

    private void forceAlignment() {
        while (!this.addrs.isEmpty() && this.addrs.getMinAddress().getOffset() % (long)this.charAlignment != 0L) {
            this.addrs.deleteFromMin(this.addrs.getMinAddress());
        }
    }

    private boolean findStartOfString() {
        return this.consumeNullTerms() && !this.addrs.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Address findEndOfString() {
        Address max = this.addrs.getFirstRange().getMaxAddress();
        Address bufStart = this.addrs.getFirstRange().getMinAddress();
        try {
            int bytesRead;
            do {
                int bytesToRead;
                Address refdAddr;
                Address address = refdAddr = this.breakOnRef ? this.getNextRefdAddr(bufStart, max) : null;
                if (refdAddr != null) {
                    max = refdAddr;
                }
                if ((bytesRead = this.memory.getBytes(bufStart, this.buffer, 0, bytesToRead = (int)Math.min((long)this.buffer.length, max.subtract(bufStart) + 1L))) <= 0) return max;
                for (int nullIndex = 0; nullIndex <= bytesRead - this.charSize; nullIndex += this.charSize) {
                    if (!this.isNullChar(nullIndex)) continue;
                    return bufStart.addNoWrap((long)(nullIndex + this.charSize - 1));
                }
                if (refdAddr == null) continue;
                return refdAddr.previous();
            } while ((bufStart = bufStart.addNoWrap((long)bytesRead)).compareTo((Object)max) <= 0);
            return max;
        }
        catch (AddressOverflowException | MemoryAccessException throwable) {
            // empty catch block
        }
        return max;
    }

    private boolean isNullChar(int index) {
        for (int i = 0; i < this.charSize; ++i) {
            if (this.buffer[index + i] == 0) continue;
            return false;
        }
        return true;
    }

    private Address getNextRefdAddr(Address start, Address end) {
        AddressIterator it = this.program.getReferenceManager().getReferenceDestinationIterator((AddressSetView)new AddressSet(start, end), true);
        Address refdAddr = null;
        if (it.hasNext() && start.equals((Object)(refdAddr = it.next()))) {
            refdAddr = it.hasNext() ? it.next() : null;
        }
        return refdAddr;
    }

    private boolean consumeNullTerms() {
        block5: {
            try {
                int bytesRead;
                if (this.memory.getByte(this.addrs.getMinAddress()) != 0) break block5;
                while (!this.addrs.isEmpty() && !this.monitor.isCancelled() && (bytesRead = this.memory.getBytes(this.addrs.getMinAddress(), this.buffer, 0, (int)Math.min((long)this.buffer.length, this.addrs.getFirstRange().getLength()))) > 0) {
                    int nonNullIndex;
                    for (nonNullIndex = 0; nonNullIndex < bytesRead; ++nonNullIndex) {
                        if (this.buffer[nonNullIndex] == 0) continue;
                        nonNullIndex -= nonNullIndex % this.charSize;
                        break;
                    }
                    if (nonNullIndex > 0) {
                        this.addrs.deleteFromMin(this.addrs.getMinAddress().add((long)(nonNullIndex - 1)));
                    }
                    if (nonNullIndex >= bytesRead) continue;
                    break;
                }
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }
        return this.singleStringStart == null || Math.abs(this.singleStringStart.subtract(this.addrs.getMinAddress())) < (long)this.charAlignment;
    }
}

