/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Protocol;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectiveC1_ProtocolList
implements StructConverter {
    public static final String NAME = "objc_protocol_list";
    private ObjectiveC1_State _state;
    private long _index;
    private ObjectiveC1_ProtocolList next;
    private int count;
    private List<ObjectiveC1_Protocol> protocols = new ArrayList<ObjectiveC1_Protocol>();

    ObjectiveC1_ProtocolList(ObjectiveC1_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        if (this._index == 0L) {
            return;
        }
        this.next = new ObjectiveC1_ProtocolList(state, reader.clone(reader.readNextInt()));
        this.count = reader.readNextInt();
        for (int i = 0; i < this.count; ++i) {
            int protocolIndex = reader.readNextInt();
            long oldProtocolIndex = reader.getPointerIndex();
            reader.setPointerIndex(protocolIndex);
            this.protocols.add(new ObjectiveC1_Protocol(state, reader));
            reader.setPointerIndex(oldProtocolIndex);
        }
    }

    public ObjectiveC1_ProtocolList getNext() {
        return this.next;
    }

    public int getCount() {
        return this.count;
    }

    public List<ObjectiveC1_Protocol> getProtocols() {
        return this.protocols;
    }

    public static DataType toGenericDataType(ObjectiveC1_State state) throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)struct, (int)state.pointerSize), "next", null);
        struct.add(DWORD, "count", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_protocol_list_" + this.count + "_", 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_ProtocolList.toGenericDataType(this._state), (int)this._state.pointerSize), "next", null);
        struct.add(DWORD, "count", null);
        if (this.count > 0) {
            Pointer dt = PointerDataType.getPointer((DataType)this.protocols.get(0).toDataType(), (int)this._state.pointerSize);
            struct.add((DataType)new ArrayDataType((DataType)dt, this.count, dt.getLength()), "protocols", null);
        }
        return struct;
    }

    public void applyTo() throws Exception {
        if (this._index == 0L) {
            return;
        }
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this._index);
        DataType dt = this.toDataType();
        this._state.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this._state.program.getListing().createData(address, dt);
        for (ObjectiveC1_Protocol protocol : this.protocols) {
            if (this._state.monitor.isCancelled()) break;
            protocol.applyTo();
        }
    }
}

