/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.XReferenceUtils;
import ghidra.app.util.exporter.AbstractLineDispenser;
import ghidra.app.util.exporter.ProgramTextOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.DataRefType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ThunkReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

class ReferenceLineDispenser
extends AbstractLineDispenser {
    private static final String XREFS_DELIM = ",";
    private int headerWidth;
    private boolean displayRefHeader;
    private String header;
    private Memory memory;
    private ReferenceManager referenceManager;
    private boolean forwardRefs;
    private List<String> lines = new ArrayList<String>();

    ReferenceLineDispenser() {
    }

    ReferenceLineDispenser(boolean forwardRefs, CodeUnit cu, Program program, ProgramTextOptions options) {
        this.memory = program.getMemory();
        this.referenceManager = program.getReferenceManager();
        this.displayRefHeader = options.isShowReferenceHeaders();
        this.prefix = options.getCommentPrefix();
        this.header = forwardRefs ? " FWD" : "XREF";
        this.headerWidth = options.getRefHeaderWidth();
        this.width = options.getRefWidth();
        this.fillAmount = options.getAddrWidth() + options.getBytesWidth() + options.getLabelWidth();
        this.isHTML = options.isHTML();
        this.forwardRefs = forwardRefs;
        List<Reference> refs = forwardRefs ? this.getForwardRefs(cu) : ReferenceLineDispenser.getXRefList(cu);
        List<Reference> offcuts = forwardRefs ? List.of() : ReferenceLineDispenser.getOffcutXRefList(cu);
        this.processRefs(cu.getMinAddress(), refs, offcuts);
    }

    ReferenceLineDispenser(Variable var, Program program, ProgramTextOptions options) {
        this.memory = program.getMemory();
        this.referenceManager = program.getReferenceManager();
        this.displayRefHeader = options.isShowReferenceHeaders();
        this.header = "XREF";
        this.headerWidth = options.getRefHeaderWidth();
        this.prefix = options.getCommentPrefix();
        this.width = options.getStackVarXrefWidth();
        this.fillAmount = options.getStackVarPreNameWidth() + options.getStackVarNameWidth() + options.getStackVarDataTypeWidth() + options.getStackVarOffsetWidth() + options.getStackVarCommentWidth();
        this.isHTML = options.isHTML();
        this.forwardRefs = false;
        ArrayList<Reference> xrefs = new ArrayList<Reference>();
        ArrayList<Reference> offcuts = new ArrayList<Reference>();
        XReferenceUtils.getVariableRefs(var, xrefs, offcuts);
        Comparator comparator = (r1, r2) -> r1.getFromAddress().compareTo((Object)r2.getFromAddress());
        xrefs.sort(comparator);
        offcuts.sort(comparator);
        this.processRefs(var.getFunction().getEntryPoint(), xrefs, offcuts);
    }

    @Override
    void dispose() {
        this.memory = null;
    }

    @Override
    boolean hasMoreLines() {
        return this.index < this.lines.size();
    }

    @Override
    String getNextLine() {
        if (this.hasMoreLines()) {
            return this.lines.get(this.index++);
        }
        return null;
    }

    private List<Reference> getForwardRefs(CodeUnit cu) {
        boolean showRefs = false;
        Address cuAddr = cu.getMinAddress();
        Reference[] monRefs = cu.getMnemonicReferences();
        Reference primMonRef = this.referenceManager.getPrimaryReferenceFrom(cuAddr, -1);
        boolean bl = showRefs = monRefs.length == 1 && primMonRef == null || monRefs.length > 1;
        if (!showRefs) {
            int opCount = cu.getNumOperands();
            for (int i = 0; i < opCount; ++i) {
                Reference[] opRefs = cu.getOperandReferences(i);
                if (opRefs.length <= 1) continue;
                showRefs = true;
                break;
            }
        }
        if (!showRefs) {
            return List.of();
        }
        List<Reference> refs = Arrays.asList(cu.getReferencesFrom());
        refs.sort((r1, r2) -> r1.getToAddress().compareTo((Object)r2.getToAddress()));
        return refs;
    }

    private void processRefs(Address addr, List<Reference> refs, List<Reference> offcuts) {
        if (this.width < 1) {
            return;
        }
        if (refs.isEmpty() && offcuts.isEmpty()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        ArrayList<Reference> all = new ArrayList<Reference>();
        all.addAll(refs);
        all.addAll(offcuts);
        if (this.displayRefHeader) {
            if (!refs.isEmpty() || !offcuts.isEmpty()) {
                String text = !offcuts.isEmpty() ? "%s[%d,%d]: ".formatted(this.header, refs.size(), offcuts.size()) : "%s[%d]: ".formatted(this.header, refs.size());
                buf.append(ReferenceLineDispenser.clip(text, this.headerWidth));
            }
        } else {
            buf.append(ReferenceLineDispenser.getFill(this.headerWidth));
            buf.append(this.prefix);
        }
        int currentXrefWidth = 0;
        for (int i = 0; i < all.size(); ++i) {
            Reference ref = (Reference)all.get(i);
            XrefItem xrefItem = new XrefItem(ref);
            int nextWidth = currentXrefWidth + xrefItem.getDisplayableWidth();
            if (nextWidth > this.width) {
                this.lines.add(this.prefix + buf.toString());
                buf.delete(0, buf.length());
                buf.append(ReferenceLineDispenser.getFill(this.headerWidth));
                currentXrefWidth = 0;
            }
            currentXrefWidth += xrefItem.getDisplayableWidth();
            buf.append(xrefItem.getRawText());
            if (i >= all.size() - 1) continue;
            buf.append(XREFS_DELIM);
        }
        if (buf.length() != 0) {
            this.lines.add(this.prefix + buf.toString());
        }
    }

    private String getRefTypeDisplayString(Reference reference) {
        if (reference.getReferenceType().isRead() && reference.getReferenceType().isWrite()) {
            return "(RW)";
        }
        RefType refType = reference.getReferenceType();
        if (reference instanceof ThunkReference) {
            return "(T)";
        }
        if (refType instanceof DataRefType) {
            if (refType.isRead() || refType.isIndirect()) {
                return "(R)";
            }
            if (refType.isWrite()) {
                return "(W)";
            }
            if (refType.isData()) {
                return "(*)";
            }
        }
        if (refType.isCall()) {
            return "(c)";
        }
        if (refType.isJump()) {
            return "(j)";
        }
        return "";
    }

    public static List<Reference> getXRefList(CodeUnit cu) {
        Program prog = cu.getProgram();
        if (prog == null) {
            return List.of();
        }
        int maxXrefs = 20;
        List<Reference> refs = XReferenceUtils.getXReferences(cu, maxXrefs + 1);
        int maxOffcuts = Math.max(0, maxXrefs - refs.size());
        List<Reference> offcuts = XReferenceUtils.getOffcutXReferences(cu, maxOffcuts);
        refs.addAll(offcuts);
        refs.sort((r1, r2) -> r1.getFromAddress().compareTo((Object)r2.getFromAddress()));
        return refs;
    }

    private static List<Reference> getOffcutXRefList(CodeUnit cu) {
        Program prog = cu.getProgram();
        if (prog == null) {
            return List.of();
        }
        ArrayList<Reference> offcutList = new ArrayList<Reference>();
        if (cu.getLength() > 1) {
            ReferenceManager refMgr = prog.getReferenceManager();
            AddressSet set = new AddressSet(cu.getMinAddress().add(1L), cu.getMaxAddress());
            AddressIterator iter = refMgr.getReferenceDestinationIterator((AddressSetView)set, true);
            while (iter.hasNext()) {
                Address addr = iter.next();
                ReferenceIterator refIter = refMgr.getReferencesTo(addr);
                while (refIter.hasNext()) {
                    Reference ref = refIter.next();
                    offcutList.add(ref);
                }
            }
        }
        offcutList.sort((r1, r2) -> r1.getFromAddress().compareTo((Object)r2.getFromAddress()));
        return offcutList;
    }

    private class XrefItem {
        private Address address;
        private String displayableString;

        XrefItem(Reference ref) {
            this.address = ReferenceLineDispenser.this.forwardRefs ? ref.getToAddress() : ref.getFromAddress();
            String refType = ReferenceLineDispenser.this.getRefTypeDisplayString(ref);
            this.displayableString = this.address.toString() + refType;
        }

        int getDisplayableWidth() {
            return this.displayableString.length();
        }

        String getRawText() {
            boolean isInMem = ReferenceLineDispenser.this.memory.contains(this.address);
            if (ReferenceLineDispenser.this.isHTML && isInMem) {
                String href = AbstractLineDispenser.getUniqueAddressString(this.address);
                return "<A HREF=\"#%s\">%s</A>".formatted(href, this.displayableString);
            }
            return this.displayableString;
        }
    }
}

