/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftVariableNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        String name = null;
        Demangled namespace = null;
        Demangled privateDeclNamespace = null;
        Demangled type = null;
        block6: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Identifier: {
                    name = child.getText();
                    continue block6;
                }
                case PrivateDeclName: {
                    Demangled temp = child.demangle(demangler);
                    name = temp.getName();
                    privateDeclNamespace = temp.getNamespace();
                    continue block6;
                }
                case Class: 
                case Enum: 
                case Extension: 
                case Module: 
                case Protocol: 
                case Structure: {
                    namespace = child.demangle(demangler);
                    continue block6;
                }
                case Type: {
                    type = child.demangle(demangler);
                    continue block6;
                }
            }
            this.skip(child);
        }
        if (name == null) {
            return this.getUnknown();
        }
        DemangledVariable variable = new DemangledVariable(this.properties.mangled(), this.properties.originalDemangled(), name);
        if (type instanceof DemangledDataType) {
            DemangledDataType ddt = (DemangledDataType)type;
            variable.setDatatype(ddt);
        }
        variable.setNamespace(SwiftNode.join(namespace, privateDeclNamespace));
        return variable;
    }
}

