/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

class OptimizeRecord {
    final long offset;
    final int size;
    int writeop;
    int readop;
    int inslot;
    int writecount;
    int readcount;
    int writesection;
    int readsection;
    int opttype;

    OptimizeRecord(long offset, int size) {
        this.offset = offset;
        this.size = size;
        this.writeop = -1;
        this.readop = -1;
        this.inslot = -1;
        this.writecount = 0;
        this.readcount = 0;
        this.writesection = -2;
        this.readsection = -2;
        this.opttype = -1;
    }

    public void copyFromExcludingSize(OptimizeRecord that) {
        this.writeop = that.writeop;
        this.readop = that.readop;
        this.inslot = that.inslot;
        this.writecount = that.writecount;
        this.readcount = that.readcount;
        this.writesection = that.writesection;
        this.readsection = that.readsection;
        this.opttype = that.opttype;
    }

    public void updateRead(int i, int inslot, int secNum) {
        assert (inslot >= 0);
        this.readop = i;
        ++this.readcount;
        this.inslot = inslot;
        this.readsection = secNum;
    }

    public void updateWrite(int i, int secNum) {
        this.writeop = i;
        ++this.writecount;
        this.writesection = secNum;
    }

    public void updateExport() {
        this.writeop = 0;
        this.readop = 0;
        this.writecount = 2;
        this.readcount = 2;
        this.readsection = -2;
        this.writesection = -2;
    }

    public void updateCombine(OptimizeRecord that) {
        if (that.writecount != 0) {
            this.writeop = that.writeop;
            this.writesection = that.writesection;
        }
        if (that.readcount != 0) {
            this.readop = that.readop;
            this.inslot = that.inslot;
            this.readsection = that.readsection;
        }
        this.writecount += that.writecount;
        this.readcount += that.readcount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{writeop=");
        sb.append(this.writeop);
        sb.append(" readop=");
        sb.append(this.readop);
        sb.append(" inslot=");
        sb.append(this.inslot);
        sb.append(" writecount=");
        sb.append(this.writecount);
        sb.append(" readcount=");
        sb.append(this.readcount);
        sb.append(" opttype=");
        sb.append(this.opttype);
        sb.append("}");
        return sb.toString();
    }
}

