/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.function.FunctionTagMappingAdapterNoTable;
import ghidra.program.database.function.FunctionTagMappingAdapterV0;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class FunctionTagMappingAdapter {
    static final String TABLE_NAME = "Function Tag Map";
    static final int CURRENT_VERSION = 0;
    static final int FUNCTION_ID_COL = 0;
    static final int TAG_ID_COL = 1;

    FunctionTagMappingAdapter() {
    }

    static FunctionTagMappingAdapter getAdapter(DBHandle handle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        if (openMode == OpenMode.CREATE) {
            return new FunctionTagMappingAdapterV0(handle, true);
        }
        try {
            return new FunctionTagMappingAdapterV0(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            FunctionTagMappingAdapter adapter = FunctionTagMappingAdapter.findReadOnlyAdapter(handle);
            if (openMode == OpenMode.UPGRADE) {
                adapter = FunctionTagMappingAdapter.upgrade(handle, adapter, monitor);
            }
            return adapter;
        }
    }

    private static FunctionTagMappingAdapter findReadOnlyAdapter(DBHandle handle) {
        return new FunctionTagMappingAdapterNoTable(handle);
    }

    private static FunctionTagMappingAdapter upgrade(DBHandle handle, FunctionTagMappingAdapter oldAdapter, TaskMonitor monitor) throws VersionException {
        return new FunctionTagMappingAdapterV0(handle, true);
    }

    abstract RecordIterator getRecordsByFunctionID(long var1) throws IOException;

    abstract DBRecord getRecord(long var1, long var3) throws IOException;

    abstract DBRecord createFunctionTagRecord(long var1, long var3) throws IOException;

    abstract boolean removeFunctionTagRecord(long var1, long var3) throws IOException;

    abstract void removeFunctionTagRecord(long var1) throws IOException;

    abstract boolean isTagAssigned(long var1) throws IOException;

    protected abstract RecordIterator getRecords() throws IOException;
}

