/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGView;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphViewSettings;
import ghidra.graph.viewer.GraphPerspectiveInfo;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import java.util.Objects;

class CurrentFunctionGraphViewSettings
extends FunctionGraphViewSettings {
    private final FGView view;

    CurrentFunctionGraphViewSettings(FGView view, FunctionGraphViewSettings copySettings) {
        this.view = view;
        this.setLocation(copySettings.getLocation());
        this.setSelection(copySettings.getSelection());
        this.setHighlight(copySettings.getHighlight());
        this.setFunctionGraphPerspectiveInfo(copySettings.getFunctionGraphPerspectiveInfo());
    }

    @Override
    public void setLocation(ProgramLocation newLocation) {
        if (Objects.equals(newLocation, this.getLocation())) {
            return;
        }
        super.setLocation(newLocation);
        this.view.setLocation(newLocation);
    }

    @Override
    public void setSelection(ProgramSelection selection) {
        super.setSelection(selection);
        this.view.setSelection(selection);
    }

    @Override
    public void setHighlight(ProgramSelection highlight) {
        super.setHighlight(highlight);
        this.view.setHighlight(highlight);
    }

    @Override
    public void setFunctionGraphPerspectiveInfo(GraphPerspectiveInfo<FGVertex, FGEdge> info) {
        super.setFunctionGraphPerspectiveInfo(info);
        if (!info.isInvalid()) {
            this.view.setGraphPerspective(info);
        }
    }
}

