/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocation;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class X86_64_MachoRelocationHandler
extends MachoRelocationHandler {
    public boolean canRelocate(MachHeader header) {
        return header.getCpuType() == 0x1000007;
    }

    public boolean isPairedRelocation(RelocationInfo relocation) {
        return relocation.getType() == 5;
    }

    public RelocationResult relocate(MachoRelocation relocation) throws MemoryAccessException, RelocationException {
        int byteLength;
        if (!relocation.requiresRelocation()) {
            return RelocationResult.SKIPPED;
        }
        RelocationInfo relocationInfo = relocation.getRelocationInfo();
        Address relocAddr = relocation.getRelocationAddress();
        Address targetAddr = relocation.getTargetAddress();
        long addend = X86_64_MachoRelocationHandler.read((MachoRelocation)relocation);
        switch (relocationInfo.getType()) {
            case 0: {
                byteLength = X86_64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)targetAddr.add(addend).getOffset());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                byteLength = X86_64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)(targetAddr.add(addend).subtract(relocAddr) - 4L));
                break;
            }
            case 5: {
                Address targetAddrExtra = relocation.getTargetAddressExtra();
                if (addend > 0L) {
                    byteLength = X86_64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)targetAddrExtra.add(addend).subtract(targetAddr));
                    break;
                }
                byteLength = X86_64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)targetAddr.add(addend).subtract(targetAddrExtra));
                break;
            }
            default: {
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

