/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.AbstractSQLFunctionDatabase;
import ghidra.features.bsim.query.client.RowKeySQL;
import ghidra.features.bsim.query.client.tables.CachedStatement;
import ghidra.features.bsim.query.client.tables.ExeToCategoryTable;
import ghidra.features.bsim.query.client.tables.SQLComplexTable;
import ghidra.features.bsim.query.client.tables.SQLStringTable;
import ghidra.features.bsim.query.description.CategoryRecord;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExeTable
extends SQLComplexTable {
    public static final String TABLE_NAME = "exetable";
    private static final String CREATE_STMT = "CREATE TABLE exetable (id SERIAL PRIMARY KEY,md5 TEXT UNIQUE,name_exec TEXT,architecture INTEGER, name_compiler INTEGER,ingest_date TIMESTAMP WITH TIME ZONE,repository INTEGER, path INTEGER)";
    private static final String INSERT_STMT = "INSERT INTO exetable (id,md5,name_exec,architecture,name_compiler,ingest_date,repository,path) VALUES(DEFAULT,?,?,?,?,?,?,?) ";
    private static final String SELECT_BY_NAME_STMT = "SELECT ALL id,md5,name_exec,architecture,name_compiler,extract(epoch from ingest_date),repository,path FROM exetable WHERE name_exec = ?  LIMIT ?";
    private static final String SELECT_BY_ID_STMT = "SELECT ALL id,md5,name_exec,architecture,name_compiler,extract(epoch from ingest_date),repository,path FROM exetable WHERE id = ?";
    private static final String SELECT_BY_MD5_STMT = "SELECT ALL id,md5,name_exec,architecture,name_compiler,extract(epoch from ingest_date),repository,path FROM exetable WHERE md5 = ?";
    private final SQLStringTable archtable;
    private final SQLStringTable compilertable;
    private final SQLStringTable repositorytable;
    private final SQLStringTable pathtable;
    private final ExeToCategoryTable exeCategoryTable;
    private final CachedStatement<PreparedStatement> insertRowStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> selectByIdStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> selectByMd5Statement = new CachedStatement();
    private final CachedStatement<PreparedStatement> selectByNameStatement = new CachedStatement();

    public ExeTable(SQLStringTable archtable, SQLStringTable compilertable, SQLStringTable repositorytable, SQLStringTable pathtable, ExeToCategoryTable exeCategoryTable) {
        super(TABLE_NAME, "id");
        this.archtable = archtable;
        this.compilertable = compilertable;
        this.repositorytable = repositorytable;
        this.pathtable = pathtable;
        this.exeCategoryTable = exeCategoryTable;
    }

    @Override
    public void close() {
        this.insertRowStatement.close();
        this.selectByIdStatement.close();
        this.selectByMd5Statement.close();
        this.selectByNameStatement.close();
        super.close();
    }

    @Override
    public void create(Statement st) throws SQLException {
        st.executeUpdate(CREATE_STMT);
    }

    @Override
    public void drop(Statement st) throws SQLException {
        throw new UnsupportedOperationException("ExeTable may not be dropped");
    }

    @Override
    public int delete(long id) throws SQLException {
        int rowcount = super.delete(id);
        if (rowcount == 0) {
            throw new SQLException("Could not delete executable record");
        }
        if (rowcount > 1) {
            throw new SQLException("Problem deleting executable record");
        }
        return rowcount;
    }

    protected static void extractExecutableRow(ResultSet pgres, ExecutableRow res) throws SQLException {
        res.rowid = pgres.getInt(1);
        res.md5 = pgres.getString(2);
        res.exename = pgres.getString(3);
        res.arch_id = pgres.getInt(4);
        res.compiler_id = pgres.getInt(5);
        res.date_milli = (long)(pgres.getDouble(6) * 1000.0);
        res.repo_id = pgres.getInt(7);
        res.path_id = pgres.getInt(8);
    }

    public int extractExecutableRows(ResultSet rs, List<ExecutableRecord> vecres, DescriptionManager res, int max) throws SQLException, LSHException {
        ArrayList<ExecutableRow> exerows = new ArrayList<ExecutableRow>();
        boolean finished = false;
        while (rs.next()) {
            if (finished) continue;
            ExecutableRow row = new ExecutableRow();
            exerows.add(row);
            ExeTable.extractExecutableRow(rs, row);
            if (max <= 0 || exerows.size() < max) continue;
            finished = true;
        }
        for (ExecutableRow exerow : exerows) {
            ExecutableRecord exerec = this.makeExecutableRecord(res, exerow);
            if (vecres == null) continue;
            vecres.add(exerec);
        }
        return exerows.size();
    }

    public ExecutableRecord makeExecutableRecord(DescriptionManager manager, ExecutableRow row) throws SQLException, LSHException {
        ExecutableRecord exerec;
        String arch = this.archtable.getString(row.arch_id);
        RowKeySQL rowid = new RowKeySQL(row.rowid);
        if (ExecutableRecord.isLibraryHash(row.md5)) {
            exerec = manager.newExecutableLibrary(row.exename, arch, rowid);
        } else {
            String cname = this.compilertable.getString(row.compiler_id);
            String repo = this.repositorytable.getString(row.repo_id);
            String path = this.pathtable.getString(row.path_id);
            Date date = new Date(row.date_milli);
            exerec = manager.newExecutableRecord(row.md5, row.exename, cname, arch, date, repo, path, rowid);
        }
        return exerec;
    }

    public ExecutableRecord querySingleExecutable(DescriptionManager manage, String name, String arch, String cname) throws SQLException, LSHException {
        DescriptionManager tmp = new DescriptionManager();
        this.queryNameExeMatch(null, tmp, name, 2000000);
        ExecutableRecord res = null;
        int count = 0;
        for (ExecutableRecord erec : tmp.getExecutableRecordSet()) {
            if (!StringUtils.isBlank((CharSequence)arch) && !erec.getArchitecture().equals(arch) || !StringUtils.isBlank((CharSequence)cname) && !erec.getNameCompiler().equals(cname)) continue;
            res = erec;
            if (++count <= 1) continue;
            return null;
        }
        if (count != 1) {
            return null;
        }
        return manage.transferExecutable(res);
    }

    public int queryNameExeMatch(List<ExecutableRecord> vecres, DescriptionManager res, String nm, int max) throws SQLException, LSHException {
        PreparedStatement s = this.selectByNameStatement.prepareIfNeeded(() -> this.db.prepareStatement(SELECT_BY_NAME_STMT));
        s.setString(1, nm);
        s.setInt(2, max > 0 ? max : 2000000);
        s.setFetchSize(50);
        int count = 0;
        try (ResultSet rs = s.executeQuery();){
            count = this.extractExecutableRows(rs, vecres, res, max);
        }
        return count;
    }

    public ExecutableRow querySingleExecutableId(long id) throws SQLException {
        PreparedStatement s = this.selectByIdStatement.prepareIfNeeded(() -> this.db.prepareStatement(SELECT_BY_ID_STMT));
        s.setInt(1, (int)id);
        try (ResultSet rs = s.executeQuery();){
            if (!rs.next()) {
                throw new SQLException("Bad exetable rowid");
            }
            ExecutableRow row = new ExecutableRow();
            ExeTable.extractExecutableRow(rs, row);
            ExecutableRow executableRow = row;
            return executableRow;
        }
    }

    public ExecutableRow queryMd5ExeMatch(String md5) throws SQLException {
        PreparedStatement s = this.selectByMd5Statement.prepareIfNeeded(() -> this.db.prepareStatement(SELECT_BY_MD5_STMT));
        s.setString(1, md5);
        try (ResultSet rs = s.executeQuery();){
            if (!rs.next()) {
                ExecutableRow executableRow = null;
                return executableRow;
            }
            ExecutableRow row = new ExecutableRow();
            ExeTable.extractExecutableRow(rs, row);
            ExecutableRow executableRow = row;
            return executableRow;
        }
    }

    public int queryExeCount(String filterMd5, String filterExeName, long filterArch, long filterCompilerName, boolean includeFakes) throws SQLException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{filterMd5})) {
            filterMd5 = null;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{filterExeName})) {
            filterExeName = null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ALL COUNT(*) FROM ");
        buffer.append(TABLE_NAME);
        buffer.append(" ");
        if (filterMd5 != null || filterExeName != null || filterArch != 0L || filterCompilerName != 0L || !includeFakes) {
            buffer.append("WHERE (");
            boolean needAnd = false;
            if (!includeFakes) {
                buffer.append("md5 NOT ILIKE 'bbbbbbbbaaaaaaaa%' ");
                needAnd = true;
            }
            if (filterMd5 != null) {
                if (needAnd) {
                    buffer.append("AND ");
                }
                if (((String)filterMd5).length() == 32) {
                    buffer.append("md5 = ? ");
                } else {
                    buffer.append("md5 ILIKE ? ");
                    filterMd5 = (String)filterMd5 + "%";
                }
                needAnd = true;
            }
            if (filterExeName != null) {
                if (needAnd) {
                    buffer.append("AND ");
                }
                buffer.append("name_exec ILIKE ? ");
                filterExeName = "%" + (String)filterExeName + "%";
                needAnd = true;
            }
            if (filterArch != 0L) {
                if (needAnd) {
                    buffer.append("AND ");
                }
                buffer.append("architecture = ? ");
                needAnd = true;
            }
            if (filterCompilerName != 0L) {
                if (needAnd) {
                    buffer.append("AND ");
                }
                buffer.append("name_compiler = ? ");
            }
            buffer.append(')');
        }
        int pos = 1;
        String query = buffer.toString();
        try (PreparedStatement selectExeCountStatement = this.db.prepareStatement(query);){
            int n;
            block34: {
                if (filterMd5 != null) {
                    selectExeCountStatement.setString(pos++, (String)filterMd5);
                }
                if (filterExeName != null) {
                    selectExeCountStatement.setString(pos++, (String)filterExeName);
                }
                if (filterArch != 0L) {
                    selectExeCountStatement.setInt(pos++, (int)filterArch);
                }
                if (filterCompilerName != 0L) {
                    selectExeCountStatement.setInt(pos++, (int)filterCompilerName);
                }
                ResultSet rs = selectExeCountStatement.executeQuery();
                try {
                    int count;
                    rs.next();
                    n = count = rs.getInt(1);
                    if (rs == null) break block34;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        int n2 = 0;
                        if (selectExeCountStatement != null) {
                            selectExeCountStatement.close();
                        }
                        return n2;
                    }
                }
                rs.close();
            }
            return n;
        }
    }

    public List<ExecutableRow> queryAllExe(int limit, String filterMd5, String filterExeName, long filterArch, long filterCompilerName, ExeTableOrderColumn sortColumn, boolean includeFakes) throws SQLException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{filterMd5})) {
            filterMd5 = null;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{filterExeName})) {
            filterExeName = null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ALL id,md5,name_exec,architecture,name_compiler,extract(epoch from ingest_date),repository,path FROM ");
        buffer.append(TABLE_NAME);
        buffer.append(" ");
        if (filterMd5 != null || filterExeName != null || filterArch != 0L || filterCompilerName != 0L || !includeFakes) {
            buffer.append("WHERE (");
            boolean needAnd = false;
            if (!includeFakes) {
                buffer.append("md5 NOT ILIKE 'bbbbbbbbaaaaaaaa%' ");
                needAnd = true;
            }
            if (filterMd5 != null) {
                if (needAnd) {
                    buffer.append("AND ");
                }
                if (((String)filterMd5).length() == 32) {
                    buffer.append("md5 = ? ");
                } else {
                    buffer.append("md5 ILIKE ? ");
                    filterMd5 = (String)filterMd5 + "%";
                }
                needAnd = true;
            }
            if (filterExeName != null) {
                if (needAnd) {
                    buffer.append("AND ");
                }
                buffer.append("name_exec ILIKE ? ");
                filterExeName = "%" + (String)filterExeName + "%";
                needAnd = true;
            }
            if (filterArch != 0L) {
                if (needAnd) {
                    buffer.append("AND ");
                }
                buffer.append("architecture = ? ");
                needAnd = true;
            }
            if (filterCompilerName != 0L) {
                if (needAnd) {
                    buffer.append("AND ");
                }
                buffer.append("name_compiler = ? ");
            }
            buffer.append(')');
        }
        if (sortColumn == ExeTableOrderColumn.NAME) {
            buffer.append(" ORDER BY name_exec ");
        } else {
            buffer.append(" ORDER BY md5 ");
        }
        buffer.append("LIMIT ?");
        int pos = 1;
        String query = buffer.toString();
        try (PreparedStatement selectAllExeStatement = this.db.prepareStatement(query);){
            ArrayList<ExecutableRow> arrayList;
            block33: {
                if (filterMd5 != null) {
                    selectAllExeStatement.setString(pos++, (String)filterMd5);
                }
                if (filterExeName != null) {
                    selectAllExeStatement.setString(pos++, (String)filterExeName);
                }
                if (filterArch != 0L) {
                    selectAllExeStatement.setInt(pos++, (int)filterArch);
                }
                if (filterCompilerName != 0L) {
                    selectAllExeStatement.setInt(pos++, (int)filterCompilerName);
                }
                selectAllExeStatement.setInt(pos, limit);
                ResultSet rs = selectAllExeStatement.executeQuery();
                try {
                    ArrayList<ExecutableRow> executables = new ArrayList<ExecutableRow>();
                    while (rs.next()) {
                        ExecutableRow row = new ExecutableRow();
                        executables.add(row);
                        ExeTable.extractExecutableRow(rs, row);
                    }
                    arrayList = executables;
                    if (rs == null) break block33;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    @Override
    public long insert(Object ... arguments) throws SQLException {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof ExecutableRecord)) {
            throw new IllegalArgumentException("Insert method for ExeTable must take exactly one ExecutableRecord argument");
        }
        ExecutableRecord erec = (ExecutableRecord)arguments[0];
        PreparedStatement s = this.insertRowStatement.prepareIfNeeded(() -> this.db.prepareStatement(INSERT_STMT, 1));
        long arch_id = this.archtable.writeString(erec.getArchitecture());
        long compiler_id = this.compilertable.writeString(erec.getNameCompiler());
        long repo_id = this.repositorytable.writeString(erec.getRepository());
        long path_id = this.pathtable.writeString(erec.getPath());
        long milli = erec.getDate().getTime();
        OffsetDateTime odt = OffsetDateTime.ofInstant(Instant.ofEpochMilli(milli), ZoneId.systemDefault());
        s.setString(1, erec.getMd5());
        s.setString(2, erec.getNameExec());
        s.setInt(3, (int)arch_id);
        s.setInt(4, (int)compiler_id);
        s.setObject(5, odt);
        s.setInt(6, (int)repo_id);
        s.setInt(7, (int)path_id);
        s.executeUpdate();
        try (ResultSet rs = s.getGeneratedKeys();){
            long rowid;
            if (!rs.next()) {
                throw new SQLException("Did not get exetable sequence number after insertion");
            }
            long l = rowid = rs.getLong(1);
            return l;
        }
    }

    public void updateExecutable(ExecutableRecord.Update rec) throws SQLException {
        if (rec.architecture || rec.date || rec.name_compiler || rec.name_exec || rec.path || rec.repository) {
            try (Statement st = this.db.createStatement();){
                StringBuilder buf = new StringBuilder();
                boolean previous = false;
                buf.append("UPDATE ");
                buf.append(TABLE_NAME);
                buf.append(" SET ");
                if (rec.name_exec) {
                    if (previous) {
                        buf.append(',');
                    } else {
                        previous = true;
                    }
                    buf.append("name_exec='");
                    AbstractSQLFunctionDatabase.appendEscapedLiteral(buf, rec.update.getNameExec());
                    buf.append('\'');
                }
                if (rec.architecture) {
                    long arch_id = this.archtable.writeString(rec.update.getArchitecture());
                    if (previous) {
                        buf.append(',');
                    } else {
                        previous = true;
                    }
                    buf.append("architecture=");
                    buf.append(arch_id);
                }
                if (rec.name_compiler) {
                    long comp_id = this.compilertable.writeString(rec.update.getNameCompiler());
                    if (previous) {
                        buf.append(',');
                    } else {
                        previous = true;
                    }
                    buf.append("name_compiler=");
                    buf.append(comp_id);
                }
                if (rec.date) {
                    if (previous) {
                        buf.append(',');
                    } else {
                        previous = true;
                    }
                    String dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ").format(rec.update.getDate());
                    buf.append("ingest_date=to_timestamp('");
                    buf.append(dateString).append("','YYYY-MM-DD HH24:MI:SS.MSz')");
                }
                if (rec.repository) {
                    long repo_id = this.repositorytable.writeString(rec.update.getRepository());
                    if (previous) {
                        buf.append(',');
                    } else {
                        previous = true;
                    }
                    buf.append("repository=");
                    buf.append(repo_id);
                }
                if (rec.path) {
                    long path_id = this.pathtable.writeString(rec.update.getPath());
                    if (previous) {
                        buf.append(',');
                    } else {
                        previous = true;
                    }
                    buf.append("path=");
                    buf.append(path_id);
                }
                buf.append(" WHERE id = ");
                buf.append(rec.update.getRowId().getLong());
                st.executeUpdate(buf.toString());
            }
        }
        if (rec.categories) {
            List<CategoryRecord> insertlist = rec.catinsert;
            if (insertlist == null) {
                this.exeCategoryTable.delete(rec.update.getRowId().getLong());
                insertlist = rec.update.getAllCategories();
            }
            if (insertlist != null) {
                for (CategoryRecord element : insertlist) {
                    this.exeCategoryTable.insert(element, rec.update.getRowId().getLong());
                }
            }
        }
    }

    public static class ExecutableRow {
        public long rowid;
        public String md5;
        public String exename;
        public long arch_id;
        public long compiler_id;
        public long date_milli;
        public long repo_id;
        public long path_id;
    }

    public static enum ExeTableOrderColumn {
        MD5,
        NAME;

    }
}

