/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.model;

import ghidra.framework.main.logviewer.model.Chunk;
import ghidra.framework.main.logviewer.model.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChunkModel
implements Iterable<Chunk> {
    private List<Chunk> chunks = new ArrayList<Chunk>();
    public long selectedByteStart;
    public long selectedByteEnd;
    public final int NUM_LINES = 250;
    public final int MAX_VISIBLE_CHUNKS = 3;

    public void add(Chunk chunk) {
        this.chunks.add(chunk);
    }

    public void add(int index, Chunk chunk) {
        this.chunks.add(index, chunk);
    }

    public Chunk remove(int index) {
        if (index >= 0 && index < this.chunks.size()) {
            return this.chunks.remove(index);
        }
        return null;
    }

    public void clear() {
        this.chunks.clear();
    }

    public int getSize() {
        return this.chunks.size();
    }

    public Chunk get(int index) {
        if (index >= 0 && index < this.chunks.size()) {
            return this.chunks.get(index);
        }
        return null;
    }

    @Override
    public Iterator<Chunk> iterator() {
        Iterator<Chunk> iterator = this.chunks.iterator();
        return iterator;
    }

    public int getNumChunks() {
        return this.chunks.size();
    }

    public Pair getFilePositionForRow(int row) {
        int totalLines = 0;
        for (Chunk chunk : this) {
            if (row < chunk.linesInChunk + totalLines) {
                int myRow = chunk.linesInChunk - (chunk.linesInChunk + totalLines - row);
                Pair byteRange = chunk.rowToFilePositionMap.get(myRow);
                return byteRange;
            }
            totalLines += chunk.linesInChunk;
        }
        return null;
    }

    public int getRowForBytePos(long selectedByte) {
        int totalLines = 0;
        for (Chunk chunk : this) {
            if (selectedByte >= chunk.start && selectedByte <= chunk.end) {
                for (Map.Entry<Integer, Pair> entry : chunk.rowToFilePositionMap.entrySet()) {
                    Integer key = entry.getKey();
                    Pair value = entry.getValue();
                    if (selectedByte < value.getStart() || selectedByte > value.getEnd()) continue;
                    return key + totalLines;
                }
            }
            totalLines += chunk.linesInChunk;
        }
        return -1;
    }
}

