/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class Hasher {
    public long hash(String string, long unsigned32BitMod) throws PdbException {
        return this.hashString32(string, unsigned32BitMod) & 0xFFFFL;
    }

    protected long hashString32(String string, long unsigned32BitMod) throws PdbException {
        byte[] bytes = string.getBytes();
        PdbByteReader reader = new PdbByteReader(bytes);
        int count = bytes.length;
        long hash = 0L;
        while (count >= 4) {
            count -= 4;
            hash ^= reader.parseUnsignedIntVal();
        }
        if (bytes.length - reader.getIndex() >= 2) {
            hash ^= (long)reader.parseUnsignedShortVal();
        }
        if (bytes.length - reader.getIndex() == 1) {
            hash ^= (long)reader.parseUnsignedByteVal();
        }
        hash |= 0x20202020L;
        hash ^= hash >> 11;
        return ((hash &= 0xFFFFFFFFFFFFFFFFL) ^ hash >> 16) % unsigned32BitMod;
    }
}

