/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentNode;
import docking.ComponentPlaceholder;
import docking.ComponentTransferable;
import docking.ComponentTransferableData;
import docking.DockableComponent;
import docking.DockableToolBarManager;
import docking.DockingWindowManager;
import docking.DropCode;
import docking.GenericHeader;
import docking.Node;
import docking.SplitPanel;
import docking.WindowNode;
import docking.util.AnimationUtils;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import generic.util.WindowUtilities;
import generic.util.image.ImageUtils;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import help.Help;
import help.HelpService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public class DockableHeader
extends GenericHeader
implements DragGestureListener,
DragSourceListener {
    private DockableComponent dockComp;
    private DragCursorManager dragCursorManager = this.createDragCursorManager();
    private DragSource dragSource = null;
    private boolean isDocking;
    private Animator focusAnimator;

    DockableHeader(DockableComponent dockableComp, boolean isDocking) {
        this.dockComp = dockableComp;
        this.isDocking = isDocking;
        this.setComponent(dockableComp);
        this.dragSource = new DragSource();
        ComponentPlaceholder info = dockableComp.getComponentWindowingPlaceholder();
        this.setTitle(info.getFullTitle());
        this.setIcon(info.getIcon());
        this.toolBarMgr.dispose();
        this.toolBarMgr = new DockableToolBarManager(dockableComp, this);
        this.dragSource.createDefaultDragGestureRecognizer(this.titlePanel.getDragComponent(), 2, this);
        this.resetComponents();
    }

    @Override
    public void requestFocus() {
        this.validateFocusability();
        this.dockComp.requestFocus();
    }

    @Override
    public void setSelected(boolean hasFocus) {
        if (!hasFocus && this.focusAnimator != null) {
            this.focusAnimator.stop();
            this.focusAnimator = null;
        }
        super.setSelected(hasFocus);
    }

    @Override
    public void dispose() {
        if (this.focusAnimator != null) {
            this.focusAnimator.stop();
            this.focusAnimator = null;
        }
        super.dispose();
    }

    void installRenameAction(MouseListener listener) {
        this.titlePanel.installRenameAction(listener);
    }

    void setHelp(HelpLocation location) {
        HelpService service = Help.getHelpService();
        if (location == null) {
            service.clearHelp((Object)this.titlePanel);
        } else {
            service.registerHelp((Object)this.titlePanel, location);
        }
    }

    void emphasize() {
        DockingWindowManager manager = DockingWindowManager.getInstance(this);
        if (manager == null) {
            return;
        }
        JFrame toolFrame = manager.getRootFrame();
        Component glassPane = toolFrame.getGlassPane();
        if (!(glassPane instanceof GGlassPane)) {
            return;
        }
        if (this.focusAnimator != null && this.focusAnimator.isRunning()) {
            return;
        }
        this.focusAnimator = this.createEmphasizingAnimator(toolFrame);
    }

    protected Animator createEmphasizingAnimator(JFrame parentFrame) {
        double random = Math.random();
        int choices = 7;
        int value = (int)((double)choices * random);
        switch (value) {
            case 0: {
                return AnimationUtils.shakeComponent(this.component);
            }
            case 1: {
                return AnimationUtils.rotateComponent(this.component);
            }
            case 2: {
                return AnimationUtils.pulseComponent(this.component);
            }
            case 3: {
                return AnimationUtils.showTheDragonOverComponent(this.component);
            }
            case 4: {
                return AnimationUtils.focusComponent(this.component);
            }
            case 5: {
                return this.emphasizeDockableComponent();
            }
        }
        return this.raiseComponent(parentFrame);
    }

    private Animator emphasizeDockableComponent() {
        if (!AnimationUtils.isAnimationEnabled()) {
            return null;
        }
        ComponentPlaceholder placeholder = this.dockComp.getComponentWindowingPlaceholder();
        ComponentNode node = placeholder.getNode();
        WindowNode windowNode = node.getTopLevelNode();
        HashSet<ComponentNode> componentNodes = new HashSet<ComponentNode>();
        this.getComponents(windowNode, componentNodes);
        Set<Component> components = componentNodes.stream().map(cn -> cn.getComponent()).filter(c -> c != null).filter(c -> !SwingUtilities.isDescendingFrom(this.component, c)).collect(Collectors.toSet());
        components.remove(this.component);
        EmphasizeDockableComponentAnimationDriver driver = new EmphasizeDockableComponentAnimationDriver(this.component, components);
        return driver.animator;
    }

    private void getComponents(Node node, Set<ComponentNode> results) {
        List<Node> children = node.getChildren();
        for (Node child : children) {
            if (child instanceof ComponentNode) {
                results.add((ComponentNode)child);
                continue;
            }
            this.getComponents(child, results);
        }
    }

    private Animator raiseComponent(JFrame parent) {
        if (this.isOnlyComponentInParent(parent)) {
            return super.createEmphasizingAnimator();
        }
        return AnimationUtils.focusComponent(this.component);
    }

    private boolean isOnlyComponentInParent(JFrame parentFrame) {
        return !this.isInSplitPanel();
    }

    private boolean isInSplitPanel() {
        Container parent;
        for (parent = this.component.getParent(); parent != null && !(parent instanceof SplitPanel); parent = parent.getParent()) {
        }
        return parent instanceof SplitPanel;
    }

    private void validateFocusability() {
        Container focusCycleRootAncestor = this.dockComp.getFocusCycleRootAncestor();
        FocusTraversalPolicy policy = focusCycleRootAncestor.getFocusTraversalPolicy();
        Component firstComponent = policy.getFirstComponent(this.dockComp);
        if (firstComponent == null) {
            ComponentPlaceholder info = this.dockComp.getComponentWindowingPlaceholder();
            Object title = "";
            if (info != null) {
                title = ": Title: " + info.getTitle();
            }
            Msg.debug((Object)this, (Object)("Found a Component Provider that does not contain a focusable component" + (String)title + ". Component Providers are required to have at least one focusable component!"));
            this.setSelected(false);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        if (!this.isDocking) {
            return;
        }
        InputEvent ie = event.getTriggerEvent();
        int modifiers = ie.getModifiersEx();
        if ((modifiers & 0x800) != 0 || (modifiers & 0x1000) != 0) {
            return;
        }
        DockableComponent.DROP_CODE = DropCode.WINDOW;
        DockableComponent.DROP_CODE_SET = true;
        DockableComponent.SOURCE_INFO = this.dockComp.getComponentWindowingPlaceholder();
        this.dragCursorManager.dragStarted();
        this.dragSource.startDrag(event, DragSource.DefaultMoveNoDrop, new ComponentTransferable(new ComponentTransferableData(this.dockComp)), this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        this.dragCursorManager.restoreCursorOnPreviousDraggedOverComponent();
        this.dragCursorManager.dragEnded();
        ComponentPlaceholder info = this.dockComp.getComponentWindowingPlaceholder();
        DockingWindowManager winMgr = info.getNode().winMgr;
        if (DockableComponent.DROP_CODE == DropCode.INVALID) {
            return;
        }
        if (DockableComponent.DROP_CODE == DropCode.WINDOW) {
            winMgr.movePlaceholder(info, event.getLocation());
        } else {
            winMgr.movePlaceholder(info, DockableComponent.TARGET_INFO, DockableComponent.DROP_CODE.getWindowPosition());
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
        this.setCursor(event);
    }

    @Override
    public void dragExit(DragSourceEvent event) {
        this.setCursor(event);
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
        this.setCursor(event);
    }

    private void setCursor(DragSourceEvent event) {
        DockableComponent.DROP_CODE_SET = false;
        Cursor c = DockableComponent.DROP_CODE.getCursor();
        this.dragCursorManager.setCursor(event, c);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    private DragCursorManager createDragCursorManager() {
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.MAC_OS_X) {
            return new MacDragCursorManager(this);
        }
        return new DragCursorManager(this);
    }

    private class DragCursorManager {
        private DragCursorManager(DockableHeader dockableHeader) {
        }

        void setCursor(DragSourceEvent event, Cursor dragCursor) {
            DragSourceContext context = event.getDragSourceContext();
            context.setCursor(dragCursor);
        }

        void dragStarted() {
        }

        void dragEnded() {
        }

        void restoreCursorOnPreviousDraggedOverComponent() {
        }
    }

    public static class EmphasizeDockableComponentAnimationDriver {
        private Animator animator;
        private GGlassPane glassPane;
        private EmphasizeDockableComponentPainter rotatePainter;

        EmphasizeDockableComponentAnimationDriver(Component component, Set<Component> others) {
            this.glassPane = AnimationUtils.getGlassPane(component);
            this.rotatePainter = new EmphasizeDockableComponentPainter(component, others);
            double start = 0.0;
            double max = 1.0;
            int duration = 1000;
            this.animator = PropertySetter.createAnimator((int)duration, (Object)this, (String)"percentComplete", (Object[])new Double[]{start, max});
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.setRepeatCount(2.0);
            this.animator.setRepeatBehavior(Animator.RepeatBehavior.REVERSE);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    this.done();
                }
            });
            this.glassPane.addPainter((GGlassPanePainter)this.rotatePainter);
            this.animator.start();
        }

        public void setPercentComplete(double percentComplete) {
            this.rotatePainter.setPercentComplete(percentComplete);
            this.glassPane.repaint();
        }

        void done() {
            this.glassPane.repaint();
            this.glassPane.removePainter((GGlassPanePainter)this.rotatePainter);
        }
    }

    private class MacDragCursorManager
    extends DragCursorManager {
        private Map<Component, Cursor> defaultCursors = new HashMap<Component, Cursor>();
        private Component componentUnderDrag;

        private MacDragCursorManager(DockableHeader dockableHeader) {
            super(dockableHeader);
        }

        @Override
        void setCursor(DragSourceEvent event, Cursor dragCursor) {
            Component hoveredComponent;
            ComponentPlaceholder placeholder = DockableComponent.DRAGGED_OVER_INFO;
            Component mousedComponent = null;
            if (placeholder == null) {
                super.setCursor(event, dragCursor);
                return;
            }
            int x = event.getX();
            int y = event.getY();
            Point screenPoint = new Point(x, y);
            DockableComponent draggedOverComponent = placeholder.getComponent();
            SwingUtilities.convertPointFromScreen(screenPoint, draggedOverComponent);
            mousedComponent = hoveredComponent = SwingUtilities.getDeepestComponentAt(draggedOverComponent, screenPoint.x, screenPoint.y);
            if (mousedComponent == null) {
                mousedComponent = placeholder.getComponent();
            }
            if (this.componentUnderDrag != mousedComponent) {
                this.restoreCursorOnPreviousDraggedOverComponent();
            }
            this.componentUnderDrag = mousedComponent;
            mousedComponent.setCursor(dragCursor);
            super.setCursor(event, dragCursor);
        }

        @Override
        void restoreCursorOnPreviousDraggedOverComponent() {
            if (this.componentUnderDrag == null) {
                return;
            }
            Cursor restoreCursor = this.defaultCursors.get(this.componentUnderDrag);
            Window window = WindowUtilities.windowForComponent((Component)this.componentUnderDrag);
            if (window != null) {
                Cursor windowCursor = this.defaultCursors.get(window);
                window.setCursor(windowCursor);
            }
            this.componentUnderDrag.setCursor(restoreCursor);
            this.componentUnderDrag = null;
        }

        @Override
        void dragStarted() {
            Window[] windows;
            this.defaultCursors.clear();
            for (Window window : windows = Window.getWindows()) {
                this.storeCursors(window);
            }
        }

        private void storeCursors(Container c) {
            Component[] children;
            this.defaultCursors.put(c, c.getCursor());
            for (Component child : children = c.getComponents()) {
                if (!(child instanceof Container)) continue;
                this.storeCursors((Container)child);
            }
        }

        @Override
        void dragEnded() {
            this.defaultCursors.clear();
        }
    }

    private static class EmphasizeDockableComponentPainter
    implements GGlassPanePainter {
        private static final GIcon DRAGON_ICON = new GIcon("icon.dragon.256");
        private Set<ComponentPaintInfo> otherComponentInfos = new HashSet<ComponentPaintInfo>();
        private Image image;
        private Component component;
        private Rectangle cBounds;
        private double percentComplete = 0.0;

        EmphasizeDockableComponentPainter(Component component, Set<Component> otherComponents) {
            this.component = component;
            this.image = ImageUtils.createImage((Component)component);
            for (Component otherComponent : otherComponents) {
                ComponentPaintInfo info = new ComponentPaintInfo(this, otherComponent);
                this.otherComponentInfos.add(info);
            }
        }

        void setPercentComplete(double percent) {
            this.percentComplete = percent;
        }

        public void paint(GGlassPane glassPane, Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            GColor background = GThemeDefaults.Colors.Palette.getColor((String)"aliceblue");
            g.setColor((Color)background);
            Rectangle othersBounds = null;
            for (ComponentPaintInfo info : this.otherComponentInfos) {
                Rectangle b = info.getRelativeBounds((Component)glassPane);
                if (othersBounds == null) {
                    othersBounds = b;
                    continue;
                }
                othersBounds.add(b);
            }
            if (othersBounds == null) {
                Rectangle componentBounds = this.component.getBounds();
                othersBounds = componentBounds = SwingUtilities.convertRectangle(this.component.getParent(), componentBounds, (Component)glassPane);
                othersBounds = new Rectangle();
            }
            g2d.fillRect(othersBounds.x, othersBounds.y, othersBounds.width, othersBounds.height);
            Image ghidraImage = DRAGON_ICON.getImageIcon().getImage();
            double scale = this.percentComplete * 7.0;
            int gw = ghidraImage.getWidth(null);
            int gh = ghidraImage.getHeight(null);
            int w = (int)((double)gw * scale);
            int h = (int)((double)gh * scale);
            Rectangle gpBounds = glassPane.getBounds();
            double cx = gpBounds.getCenterX();
            double cy = gpBounds.getCenterY();
            int offsetX = (int)(cx - (double)(w >> 1));
            int offsetY = (int)(cy - (double)(h >> 1));
            Shape originalClip = g2d.getClip();
            if (!othersBounds.isEmpty()) {
                g2d.setClip(othersBounds);
            }
            g2d.drawImage(ghidraImage, offsetX, offsetY, w, h, null);
            g2d.setClip(originalClip);
            this.paintOthers(glassPane, (Graphics2D)g, (Color)background);
            Rectangle b = this.component.getBounds();
            Point p = new Point(b.getLocation());
            p = SwingUtilities.convertPoint(this.component.getParent(), p, (Component)glassPane);
            g2d.setRenderingHints(new RenderingHints(null));
            g2d.drawImage(this.image, p.x, p.y, b.width, b.height, null);
        }

        private void paintOthers(GGlassPane glassPane, Graphics2D g2d, Color background) {
            if (this.cBounds == null) {
                this.cBounds = this.component.getBounds();
                this.cBounds = SwingUtilities.convertRectangle(this.component.getParent(), this.cBounds, (Component)glassPane);
            }
            double destinationX = this.cBounds.getCenterX();
            double destinationY = this.cBounds.getCenterY();
            g2d.setColor(background);
            for (ComponentPaintInfo info : this.otherComponentInfos) {
                Rectangle b = info.getRelativeBounds((Component)glassPane);
                double scale = 1.0 - this.percentComplete;
                int w = (int)((double)b.width * scale);
                int h = (int)((double)b.height * scale);
                int offsetX = b.x - (w - b.width >> 1);
                int offsetY = b.y - (h - b.height >> 1);
                double deltaX = destinationX - (double)offsetX;
                double deltaY = destinationY - (double)offsetY;
                double moveX = this.percentComplete * deltaX;
                double moveY = this.percentComplete * deltaY;
                offsetX = (int)((double)offsetX + moveX);
                offsetY = (int)((double)offsetY + moveY);
                g2d.drawImage(info.getImage(), offsetX, offsetY, w, h, null);
            }
        }

        private class ComponentPaintInfo {
            private Component myComponent;
            private Image myImage;

            ComponentPaintInfo(EmphasizeDockableComponentPainter emphasizeDockableComponentPainter, Component component) {
                this.myComponent = component;
                this.myImage = ImageUtils.createImage((Component)component);
            }

            Image getImage() {
                return this.myImage;
            }

            Rectangle getRelativeBounds(Component other) {
                Rectangle r = this.myComponent.getBounds();
                return SwingUtilities.convertRectangle(this.myComponent.getParent(), r, other);
            }
        }
    }
}

