/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import generic.hash.HashUtilities;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class CartV1Constants {
    public static final String HEADER_MAGIC = "CART";
    public static final short HEADER_VERSION = 1;
    public static final long HEADER_RESERVED = 0L;
    public static final int HEADER_LENGTH = 38;
    public static final String FOOTER_MAGIC = "TRAC";
    public static final long FOOTER_RESERVED = 0L;
    public static final int FOOTER_LENGTH = 28;
    public static final int ARC4_KEY_LENGTH = 16;
    public static final byte[] DEFAULT_ARC4_KEY = new byte[]{3, 1, 4, 1, 5, 9, 2, 6, 3, 1, 4, 1, 5, 9, 2, 6};
    public static final byte[] PRIVATE_ARC4_KEY_PLACEHOLDER = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int BLOCK_SIZE = 65536;
    public static final int MINIMUM_LENGTH = 66;
    public static final Map<String, String> EXPECTED_HASHES = new LinkedHashMap<String, String>(){
        {
            this.put("md5", HashUtilities.MD5_ALGORITHM);
            this.put("sha1", "SHA1");
            this.put("sha256", HashUtilities.SHA256_ALGORITHM);
        }
    };
    public static final Set<String> FOOTER_ONLY_KEYS = new HashSet<String>(){
        {
            this.add("length");
            this.addAll(EXPECTED_HASHES.keySet().stream().map(String::toLowerCase).collect(Collectors.toList()));
        }
    };
    public static final List<byte[]> ZLIB_HEADER_BYTES = List.of(new byte[]{120, 1}, new byte[]{120, -100}, new byte[]{120, -38});
}

