/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial;

import ghidra.util.LockHold;
import ghidra.util.database.DBSynchronizedIterator;
import ghidra.util.database.spatial.AbstractConstraintsTree;
import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.BoundingShape;
import ghidra.util.database.spatial.DBTreeDataRecord;
import ghidra.util.database.spatial.DBTreeRecord;
import ghidra.util.database.spatial.Query;
import ghidra.util.database.spatial.SpatialMap;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.apache.commons.collections4.IteratorUtils;

public abstract class AbstractConstraintsTreeSpatialMap<DS extends BoundedShape<NS>, DR extends DBTreeDataRecord<DS, NS, T>, NS extends BoundingShape<NS>, T, Q extends Query<DS, NS>>
implements SpatialMap<DS, T, Q> {
    protected final AbstractConstraintsTree<DS, DR, NS, ?, T, Q> tree;
    protected final Q query;

    public AbstractConstraintsTreeSpatialMap(AbstractConstraintsTree<DS, DR, NS, ?, T, Q> tree, Q query) {
        this.tree = tree;
        this.query = query;
    }

    @Override
    public T put(DS shape, T value) {
        try (LockHold hold = LockHold.lock(this.tree.dataStore.writeLock());){
            DR record = this.tree.doInsertData(shape, value);
            Object t = ((DBTreeDataRecord)((Object)record)).getRecordValue();
            return t;
        }
    }

    @Override
    public boolean remove(DS shape, T value) {
        try (LockHold hold = LockHold.lock(this.tree.dataStore.writeLock());){
            boolean bl = this.tree.doRemoveData(shape, value, this.query);
            return bl;
        }
    }

    @Override
    public boolean remove(Map.Entry<DS, T> entry) {
        try (LockHold hold = LockHold.lock(this.tree.dataStore.writeLock());){
            if (!(entry instanceof DBTreeDataRecord.RecordEntry)) {
                boolean bl = this.tree.doRemoveData((BoundedShape)entry.getKey(), entry.getValue(), this.query);
                return bl;
            }
            DBTreeDataRecord rec = ((DBTreeDataRecord.RecordEntry)entry).asRecord();
            if (!this.tree.dataStore.asMap().containsValue((Object)rec)) {
                boolean bl = this.tree.doRemoveData((BoundedShape)entry.getKey(), entry.getValue(), this.query);
                return bl;
            }
            DBTreeDataRecord dr = rec;
            this.tree.doDeleteEntry(dr);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public int size() {
        try (LockHold hold = LockHold.lock(this.tree.dataStore.readLock());){
            int n = this.tree.count(this.query);
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        try (LockHold hold = LockHold.lock(this.tree.dataStore.readLock());){
            boolean bl = this.tree.isEmpty(this.query);
            return bl;
        }
    }

    protected static int checkInt(long l) {
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return (int)l;
    }

    @Override
    public Collection<Map.Entry<DS, T>> entries() {
        return new AbstractCollection<Map.Entry<DS, T>>(){

            @Override
            public Iterator<Map.Entry<DS, T>> iterator() {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    DBSynchronizedIterator dBSynchronizedIterator = new DBSynchronizedIterator(IteratorUtils.transformedIterator(AbstractConstraintsTreeSpatialMap.this.tree.iterator(AbstractConstraintsTreeSpatialMap.this.query), r -> r.asEntry()), AbstractConstraintsTreeSpatialMap.this.tree.dataStore.getLock());
                    return dBSynchronizedIterator;
                }
            }

            @Override
            public Object[] toArray() {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    ArrayList result = new ArrayList();
                    AbstractConstraintsTreeSpatialMap.this.tree.visitAllData(AbstractConstraintsTreeSpatialMap.this.query, new ToListConsumer<Map.Entry<DS, T>, DR, Map.Entry<DS, T>>(this, result){

                        @Override
                        protected Map.Entry<DS, T> transformed(DR t) {
                            return ((DBTreeDataRecord)((Object)t)).asEntry();
                        }
                    }, false);
                    Object[] objectArray = result.toArray();
                    return objectArray;
                }
            }

            @Override
            public <U> U[] toArray(U[] a) {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    int size = AbstractConstraintsTreeSpatialMap.this.size();
                    if (a.length < size) {
                        a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                    }
                    ToArrayConsumer consumer = new ToArrayConsumer<U, DR, U>(this, a){

                        @Override
                        protected U transformed(DR t) {
                            return ((DBTreeDataRecord)((Object)t)).asEntry();
                        }
                    };
                    AbstractConstraintsTreeSpatialMap.this.tree.visitAllData(AbstractConstraintsTreeSpatialMap.this.query, consumer, false);
                    consumer.putNull();
                    Object[] objectArray = a;
                    return objectArray;
                }
            }

            @Override
            public int size() {
                return AbstractConstraintsTreeSpatialMap.checkInt(AbstractConstraintsTreeSpatialMap.this.size());
            }

            @Override
            public boolean isEmpty() {
                return AbstractConstraintsTreeSpatialMap.this.isEmpty();
            }

            @Override
            public Spliterator<Map.Entry<DS, T>> spliterator() {
                return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
            }
        };
    }

    @Override
    public Collection<Map.Entry<DS, T>> orderedEntries() {
        return new AbstractCollection<Map.Entry<DS, T>>(){

            @Override
            public Iterator<Map.Entry<DS, T>> iterator() {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    DBSynchronizedIterator dBSynchronizedIterator = new DBSynchronizedIterator(IteratorUtils.transformedIterator(AbstractConstraintsTreeSpatialMap.this.tree.orderedIterator(AbstractConstraintsTreeSpatialMap.this.query), r -> r.asEntry()), AbstractConstraintsTreeSpatialMap.this.tree.dataStore.getLock());
                    return dBSynchronizedIterator;
                }
            }

            @Override
            public int size() {
                return AbstractConstraintsTreeSpatialMap.checkInt(AbstractConstraintsTreeSpatialMap.this.size());
            }

            @Override
            public boolean isEmpty() {
                return AbstractConstraintsTreeSpatialMap.this.isEmpty();
            }

            @Override
            public Spliterator<Map.Entry<DS, T>> spliterator() {
                return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
            }
        };
    }

    @Override
    public Collection<DS> keys() {
        return new AbstractCollection<DS>(){

            @Override
            public Iterator<DS> iterator() {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    DBSynchronizedIterator dBSynchronizedIterator = new DBSynchronizedIterator(IteratorUtils.transformedIterator(AbstractConstraintsTreeSpatialMap.this.tree.iterator(AbstractConstraintsTreeSpatialMap.this.query), r -> r.getShape()), AbstractConstraintsTreeSpatialMap.this.tree.dataStore.getLock());
                    return dBSynchronizedIterator;
                }
            }

            @Override
            public Object[] toArray() {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    ArrayList result = new ArrayList();
                    AbstractConstraintsTreeSpatialMap.this.tree.visitAllData(AbstractConstraintsTreeSpatialMap.this.query, new ToListConsumer<DS, DR, DS>(this, result){

                        @Override
                        protected DS transformed(DR t) {
                            return ((DBTreeRecord)((Object)t)).getShape();
                        }
                    }, false);
                    Object[] objectArray = result.toArray();
                    return objectArray;
                }
            }

            @Override
            public <U> U[] toArray(U[] a) {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    int size = AbstractConstraintsTreeSpatialMap.this.size();
                    if (a.length < size) {
                        a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                    }
                    ToArrayConsumer consumer = new ToArrayConsumer<U, DR, U>(this, a){

                        @Override
                        protected U transformed(DR t) {
                            return ((DBTreeRecord)((Object)t)).getShape();
                        }
                    };
                    AbstractConstraintsTreeSpatialMap.this.tree.visitAllData(AbstractConstraintsTreeSpatialMap.this.query, consumer, false);
                    consumer.putNull();
                    Object[] objectArray = a;
                    return objectArray;
                }
            }

            @Override
            public int size() {
                return AbstractConstraintsTreeSpatialMap.checkInt(AbstractConstraintsTreeSpatialMap.this.size());
            }

            @Override
            public boolean isEmpty() {
                return AbstractConstraintsTreeSpatialMap.this.isEmpty();
            }

            @Override
            public Spliterator<DS> spliterator() {
                return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
            }
        };
    }

    @Override
    public Collection<DS> orderedKeys() {
        return new AbstractCollection<DS>(){

            @Override
            public Iterator<DS> iterator() {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    DBSynchronizedIterator dBSynchronizedIterator = new DBSynchronizedIterator(IteratorUtils.transformedIterator(AbstractConstraintsTreeSpatialMap.this.tree.orderedIterator(AbstractConstraintsTreeSpatialMap.this.query), r -> r.getShape()), AbstractConstraintsTreeSpatialMap.this.tree.dataStore.getLock());
                    return dBSynchronizedIterator;
                }
            }

            @Override
            public int size() {
                return AbstractConstraintsTreeSpatialMap.checkInt(AbstractConstraintsTreeSpatialMap.this.size());
            }

            @Override
            public boolean isEmpty() {
                return AbstractConstraintsTreeSpatialMap.this.isEmpty();
            }

            @Override
            public Spliterator<DS> spliterator() {
                return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
            }
        };
    }

    @Override
    public Collection<T> values() {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    DBSynchronizedIterator dBSynchronizedIterator = new DBSynchronizedIterator(IteratorUtils.transformedIterator(AbstractConstraintsTreeSpatialMap.this.tree.iterator(AbstractConstraintsTreeSpatialMap.this.query), r -> r.getRecordValue()), AbstractConstraintsTreeSpatialMap.this.tree.dataStore.getLock());
                    return dBSynchronizedIterator;
                }
            }

            @Override
            public Object[] toArray() {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    ArrayList result = new ArrayList();
                    AbstractConstraintsTreeSpatialMap.this.tree.visitAllData(AbstractConstraintsTreeSpatialMap.this.query, new ToListConsumer<T, DR, T>(this, result){

                        @Override
                        protected T transformed(DR t) {
                            return ((DBTreeDataRecord)((Object)t)).getRecordValue();
                        }
                    }, false);
                    Object[] objectArray = result.toArray();
                    return objectArray;
                }
            }

            @Override
            public <U> U[] toArray(U[] a) {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    int size = AbstractConstraintsTreeSpatialMap.this.size();
                    if (a.length < size) {
                        a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                    }
                    ToArrayConsumer consumer = new ToArrayConsumer<U, DR, U>(this, a){

                        @Override
                        protected U transformed(DR t) {
                            return ((DBTreeDataRecord)((Object)t)).getRecordValue();
                        }
                    };
                    AbstractConstraintsTreeSpatialMap.this.tree.visitAllData(AbstractConstraintsTreeSpatialMap.this.query, consumer, false);
                    consumer.putNull();
                    Object[] objectArray = a;
                    return objectArray;
                }
            }

            @Override
            public int size() {
                return AbstractConstraintsTreeSpatialMap.checkInt(AbstractConstraintsTreeSpatialMap.this.size());
            }

            @Override
            public boolean isEmpty() {
                return AbstractConstraintsTreeSpatialMap.this.isEmpty();
            }

            @Override
            public Spliterator<T> spliterator() {
                return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
            }
        };
    }

    @Override
    public Collection<T> orderedValues() {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                try (LockHold hold = LockHold.lock(AbstractConstraintsTreeSpatialMap.this.tree.dataStore.readLock());){
                    DBSynchronizedIterator dBSynchronizedIterator = new DBSynchronizedIterator(IteratorUtils.transformedIterator(AbstractConstraintsTreeSpatialMap.this.tree.orderedIterator(AbstractConstraintsTreeSpatialMap.this.query), r -> r.getRecordValue()), AbstractConstraintsTreeSpatialMap.this.tree.dataStore.getLock());
                    return dBSynchronizedIterator;
                }
            }

            @Override
            public int size() {
                return AbstractConstraintsTreeSpatialMap.checkInt(AbstractConstraintsTreeSpatialMap.this.size());
            }

            @Override
            public boolean isEmpty() {
                return AbstractConstraintsTreeSpatialMap.this.isEmpty();
            }

            @Override
            public Spliterator<T> spliterator() {
                return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
            }
        };
    }

    @Override
    public Map.Entry<DS, T> firstEntry() {
        try (LockHold hold = LockHold.lock(this.tree.dataStore.readLock());){
            DR first = this.tree.first(this.query);
            DBTreeDataRecord.RecordEntry recordEntry = first == null ? null : ((DBTreeDataRecord)((Object)first)).asEntry();
            return recordEntry;
        }
    }

    @Override
    public DS firstKey() {
        try (LockHold hold = LockHold.lock(this.tree.dataStore.readLock());){
            DR first = this.tree.first(this.query);
            DS DS = first == null ? null : (DS)((DBTreeRecord)((Object)first)).getShape();
            return DS;
        }
    }

    @Override
    public T firstValue() {
        try (LockHold hold = LockHold.lock(this.tree.dataStore.readLock());){
            DR first = this.tree.first(this.query);
            T t = first == null ? null : (T)((DBTreeDataRecord)((Object)first)).getRecordValue();
            return t;
        }
    }

    @Override
    public void clear() {
        try (LockHold hold = LockHold.lock(this.tree.dataStore.writeLock());){
            this.tree.clear(this.query);
        }
    }

    protected static abstract class ToListConsumer<A, T, U extends A>
    implements Consumer<T> {
        protected final List<A> list;

        public ToListConsumer(List<A> list) {
            this.list = list;
        }

        @Override
        public void accept(T t) {
            this.list.add(this.transformed(t));
        }

        protected abstract U transformed(T var1);
    }

    protected static abstract class ToArrayConsumer<A, T, U extends A>
    implements Consumer<T> {
        protected final A[] arr;
        protected int i = 0;

        public ToArrayConsumer(A[] arr) {
            this.arr = arr;
        }

        @Override
        public void accept(T t) {
            this.arr[this.i++] = this.transformed(t);
        }

        protected abstract U transformed(T var1);

        protected void putNull() {
            if (this.i < this.arr.length) {
                this.arr[this.i] = null;
            }
        }
    }
}

