/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.actions.AbstractFindReferencesDataTypeAction;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.util.HelpLocation;

public class FindReferencesToDataTypeAction
extends AbstractFindReferencesDataTypeAction {
    private final DecompilerController controller;

    public FindReferencesToDataTypeAction(String owner, PluginTool tool, DecompilerController controller) {
        super(tool, "Find References To", owner, DEFAULT_KEY_STROKE);
        this.controller = controller;
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFindUses"));
        this.setPopupMenuData(new MenuData(new String[]{"References", "Find Uses of "}));
    }

    public DataType getDataType(ActionContext context) {
        return DecompilerUtils.getDataType((DecompilerActionContext)context);
    }

    protected String getDataTypeField(DataType dataType) {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor instanceof ClangFieldToken) {
            return tokenAtCursor.getText();
        }
        if (tokenAtCursor instanceof ClangVariableToken && dataType instanceof Enum) {
            String[] names;
            ClangVariableToken vt = (ClangVariableToken)tokenAtCursor;
            String text = vt.getText();
            Enum e = (Enum)dataType;
            for (String name : names = e.getNames()) {
                if (!name.equals(text)) continue;
                return name;
            }
        }
        return null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DataType dataType = this.getDataType(context);
        this.updateMenuName(dataType);
        return super.isEnabledForContext(context);
    }

    private void updateMenuName(DataType type) {
        if (type == null) {
            return;
        }
        String typeName = type.getName();
        String menuName = "Find Uses of " + typeName;
        String fieldName = this.getDataTypeField(type);
        if (fieldName != null) {
            menuName = menuName + "." + fieldName;
        }
        MenuData data = this.getPopupMenuData().cloneData();
        data.setMenuPath(new String[]{"References", menuName});
        this.setPopupMenuData(data);
    }
}

