/*
 * Decompiled with CFR 0.152.
 */
package sarif.export;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ISF.IsfObject;
import sarif.SarifUtils;
import sarif.export.ExtLogicalLocation;

public class SarifObject
implements IsfObject {
    public static boolean SARIF = true;
    protected JsonObject message;
    protected String kind;
    protected String level;
    protected String ruleId;
    protected JsonArray locations;
    protected JsonObject properties;
    protected JsonObject element;

    public SarifObject(String key, String ruleKey, JsonElement element) {
        if (SARIF) {
            this.message = new JsonObject();
            this.message.addProperty("text", key);
            this.kind = "informational";
            this.level = "none";
            this.ruleId = ruleKey;
            this.properties = new JsonObject();
            this.properties.add("additionalProperties", element);
        } else {
            this.element = (JsonObject)element;
            this.element.addProperty("key", key);
            this.element.addProperty("rule", ruleKey);
        }
    }

    public SarifObject(String key, String ruleKey, JsonElement tree, Address min, Address max) {
        this(key, ruleKey, tree);
        if (min != null) {
            this.writeLocations(min, max);
        }
    }

    public SarifObject(String key, String ruleKey, JsonElement tree, AddressSetView body) {
        this(key, ruleKey, tree);
        if (body != null) {
            this.writeLocations(body);
        }
    }

    public SarifObject(String key, String ruleKey, ExtLogicalLocation lloc, JsonElement tree, Address addr, int index) {
        this(key, ruleKey, tree);
        if (addr != null) {
            this.locations = SarifUtils.setLocation(addr, "data", lloc.uri, lloc.name, lloc.fullyQualifiedName, index);
        }
    }

    protected void writeLocations(Address min, Address max) {
        if (SARIF) {
            this.locations = SarifUtils.setLocations(min, max);
        } else {
            this.element.addProperty("startAddress", min.toString(true));
            this.element.addProperty("stopAddress", max.toString(true));
        }
    }

    protected void writeLocations(AddressSetView set) {
        if (SARIF) {
            this.locations = SarifUtils.setLocations(set);
        } else {
            this.element.addProperty("startAddress", set.getMinAddress().toString(true));
            this.element.addProperty("stopAddress", set.getMaxAddress().toString(true));
        }
    }
}

