/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.framework.GModule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import utility.module.ClasspathFilter;
import utility.module.ModuleUtilities;

public class GhidraTestApplicationLayout
extends GhidraApplicationLayout {
    public GhidraTestApplicationLayout(File userSettingsDir) throws FileNotFoundException, IOException {
        this.userSettingsDir = userSettingsDir;
    }

    @Override
    protected ResourceFile findExtensionArchiveDirectory() {
        File archiveDir = new File(this.getUserTempDir(), "ExtensionArchiveDir");
        return new ResourceFile(archiveDir);
    }

    @Override
    protected List<ResourceFile> findExtensionInstallationDirectories() {
        File installDir = new File(this.getUserTempDir(), "ExtensionInstallDir");
        return Collections.singletonList(new ResourceFile(installDir));
    }

    @Override
    protected ResourceFile findPatchDirectory() {
        File dir = new File(this.getUserTempDir(), "patch");
        return new ResourceFile(dir);
    }

    @Override
    protected Map<String, GModule> findGhidraModules() throws IOException {
        Set<String> modulePatterns = this.getDependentModulePatterns();
        Predicate<Path> additionalPaths = path -> {
            String pathString = path.toString();
            return modulePatterns.stream().anyMatch(pattern -> pathString.contains((CharSequence)pattern));
        };
        Collection<ResourceFile> roots = ModuleUtilities.findModuleRootDirectories(this.applicationRootDirs);
        return ModuleUtilities.findModules(this.applicationRootDirs, roots, new ClasspathFilter(additionalPaths));
    }

    protected Set<String> getDependentModulePatterns() {
        char slash = File.separatorChar;
        return new HashSet<String>(Set.of(slash + "Processors" + slash, "TestResources", "DemanglerGnu"));
    }
}

