/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.parse;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyExtendedGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyExtendedProduction;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyFirstFollow;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseActionGotoTable;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseMachine;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseResult;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseState;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseStateItem;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseTransitionTable;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyEOI;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyExtendedNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericSymbols;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.util.TableEntry;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.commons.collections4.map.LazyMap;
import org.apache.commons.lang3.StringUtils;

public class AssemblyParser {
    protected final AssemblyGrammar grammar;
    protected final AssemblyFirstFollow ff;
    protected final ArrayList<AssemblyParseState> states = new ArrayList();
    protected final AssemblyParseTransitionTable table = new AssemblyParseTransitionTable();
    protected AssemblyExtendedGrammar extendedGrammar;
    protected final AssemblyFirstFollow extff;
    protected Map<MergeKey, MergeValue> mergers;
    protected AssemblyParseActionGotoTable actions;

    public AssemblyParser(AssemblyGrammar grammar) {
        this.grammar = grammar;
        Object newName = "$S";
        while (grammar.contains((String)newName)) {
            newName = "$" + (String)newName;
        }
        AssemblyNonTerminal start = new AssemblyNonTerminal((String)newName);
        grammar.addProduction(start, new AssemblySentential(new AssemblySymbol[]{grammar.getStart(), AssemblyEOI.EOI}));
        grammar.setStart(start);
        this.ff = new AssemblyFirstFollow(grammar);
        this.buildLR0Machine();
        this.buildExtendedGrammar();
        this.extff = new AssemblyFirstFollow(this.extendedGrammar);
        this.buildActionGotoTable();
    }

    protected void buildLR0Machine() {
        AssemblyProduction sp = (AssemblyProduction)this.grammar.productionsOf((AssemblyNonTerminal)this.grammar.getStart()).iterator().next();
        AssemblyParseStateItem startItem = new AssemblyParseStateItem(sp, 0);
        AssemblyParseState startState = new AssemblyParseState(this.grammar, startItem);
        this.states.add(startState);
        for (int curState = 0; curState < this.states.size(); ++curState) {
            AssemblyParseState state = this.states.get(curState);
            LazyMap go = LazyMap.lazyMap(new LinkedHashMap(), () -> new AssemblyParseState(this.grammar));
            for (AssemblyParseStateItem assemblyParseStateItem : state.getClosure()) {
                AssemblySymbol sym = assemblyParseStateItem.getNext();
                if (sym == null) continue;
                AssemblyParseStateItem ni = assemblyParseStateItem.read();
                ((AssemblyParseState)go.get(sym)).getKernel().add(ni);
            }
            for (Map.Entry entry : go.entrySet()) {
                int newStateNum = this.addLR0State((AssemblyParseState)entry.getValue());
                this.table.put(curState, (AssemblySymbol)entry.getKey(), newStateNum);
            }
        }
    }

    protected int addLR0State(AssemblyParseState state) {
        int num = this.states.indexOf(state);
        if (num != -1) {
            return num;
        }
        this.states.add(state);
        return this.states.size() - 1;
    }

    protected void buildExtendedGrammar() {
        this.extendedGrammar = new AssemblyExtendedGrammar();
        this.extendedGrammar.setStartName(this.grammar.getStartName());
        for (int curState = 0; curState < this.states.size(); ++curState) {
            AssemblyParseState state = this.states.get(curState);
            for (AssemblyParseStateItem item : state.getClosure()) {
                if (item.getPos() != 0) continue;
                AssemblyExtendedProduction ext = this.extend(item.getProduction(), curState);
                this.extendedGrammar.addProduction(ext);
            }
        }
    }

    protected AssemblyExtendedProduction extend(AssemblyProduction prod, int start) {
        AssemblySentential<AssemblyExtendedNonTerminal> extR = new AssemblySentential<AssemblyExtendedNonTerminal>();
        int curState = start;
        for (AssemblySymbol sym : prod.getRHS()) {
            int nextState = this.table.get(curState, sym);
            if (sym instanceof AssemblyTerminal) {
                extR.addSymbol(sym);
            } else if (sym instanceof AssemblyNonTerminal) {
                extR.addSymbol(new AssemblyExtendedNonTerminal(curState, (AssemblyNonTerminal)sym, nextState));
            } else {
                throw new AssertionError((Object)"Internal error: all AssemblySymbols must be either terminal or non-terminal");
            }
            curState = nextState;
        }
        Object lhs = prod.getLHS();
        int nextState = -1;
        if (!((AssemblySymbol)lhs).equals(this.grammar.getStart())) {
            nextState = this.table.get(start, (AssemblySymbol)prod.getLHS());
        }
        AssemblyExtendedNonTerminal extL = new AssemblyExtendedNonTerminal(start, (AssemblyNonTerminal)prod.getLHS(), nextState);
        return new AssemblyExtendedProduction(extL, extR, curState, prod);
    }

    protected void buildActionGotoTable() {
        this.actions = new AssemblyParseActionGotoTable();
        this.table.forEach(new Consumer<TableEntry<Integer>>(){

            @Override
            public void accept(TableEntry<Integer> ent) {
                if (ent.getSym() instanceof AssemblyNonTerminal) {
                    AssemblyNonTerminal nt = (AssemblyNonTerminal)ent.getSym();
                    AssemblyParser.this.actions.putGoto(ent.getState(), nt, ent.getValue());
                } else if (ent.getSym() instanceof AssemblyTerminal) {
                    AssemblyTerminal t = (AssemblyTerminal)ent.getSym();
                    AssemblyParser.this.actions.putShift(ent.getState(), t, ent.getValue());
                } else {
                    throw new AssertionError((Object)"INTERNAL: symbols must be T or NT");
                }
            }
        });
        this.mergers = LazyMap.lazyMap(new LinkedHashMap(), () -> new MergeValue());
        int i = -1;
        for (AssemblyExtendedProduction assemblyExtendedProduction : this.extendedGrammar) {
            MergeValue entry = this.mergers.get(new MergeKey(assemblyExtendedProduction.getFinalState(), assemblyExtendedProduction.getAncestor()));
            entry.merge(++i, this.extff.getFollow(assemblyExtendedProduction.getLHS()));
        }
        for (Map.Entry entry : this.mergers.entrySet()) {
            for (AssemblyTerminal t : ((MergeValue)entry.getValue()).follow) {
                AssemblyProduction prod = ((MergeKey)entry.getKey()).prod;
                if (((AssemblySymbol)prod.getLHS()).equals(this.grammar.getStart())) continue;
                this.actions.putReduce(((MergeKey)entry.getKey()).finalState, t, prod);
            }
        }
        block3: for (i = 0; i < this.states.size(); ++i) {
            AssemblyParseState state = this.states.get(i);
            for (AssemblyParseStateItem item : state.getKernel()) {
                if (!item.completed() || !((AssemblySymbol)item.getProduction().getLHS()).getName().equals("$S")) continue;
                this.actions.putAccept(i);
                continue block3;
            }
        }
    }

    public Iterable<AssemblyParseResult> parse(String input) {
        return this.parse(input, AssemblyNumericSymbols.EMPTY);
    }

    public Collection<AssemblyParseResult> parse(String input, AssemblyNumericSymbols symbols) {
        AssemblyParseMachine init = new AssemblyParseMachine(this, input, 0, null, symbols);
        Set<AssemblyParseMachine> results = init.exhaust();
        LinkedHashSet<AssemblyParseResult> ret = new LinkedHashSet<AssemblyParseResult>();
        for (AssemblyParseMachine m : results) {
            if (m.accepted) {
                ret.add(AssemblyParseResult.accept(m.getTree()));
                continue;
            }
            if (m.error != 0) {
                TreeSet<String> suggestions = new TreeSet<String>();
                for (AssemblyTerminal t : m.expected) {
                    suggestions.addAll(t.getSuggestions(m.got, symbols));
                }
                ret.add(AssemblyParseResult.error(m.got, suggestions));
                continue;
            }
            throw new AssertionError((Object)"INTERNAL: Unfinished machine was returned");
        }
        return ret;
    }

    public void printGrammar(PrintStream out) {
        out.println("\nGeneral Grammar:");
        this.grammar.print(out);
    }

    public void printLR0States(PrintStream out) {
        out.println("\nLR0 States:");
        for (int i = 0; i < this.states.size(); ++i) {
            AssemblyParseState state = this.states.get(i);
            out.println("I" + i);
            for (AssemblyParseStateItem item : state.getKernel()) {
                out.println("K: " + String.valueOf(item));
            }
            for (AssemblyParseStateItem item : state.getClosure()) {
                if (state.getKernel().contains(item)) continue;
                out.println("C: " + String.valueOf(item));
            }
        }
    }

    public void printLR0TransitionTable(PrintStream out) {
        out.println("\nLR0 Transition Table:");
        out.print("State\t");
        for (AssemblyTerminal t : this.grammar.terminals()) {
            out.print(String.valueOf(t) + "\t");
        }
        for (AssemblyNonTerminal nt : this.grammar.nonTerminals()) {
            out.print(String.valueOf(nt) + "\t");
        }
        out.println();
        for (int i = 0; i < this.states.size(); ++i) {
            Integer newState;
            out.print(i + "\t");
            for (AssemblyTerminal t : this.grammar.terminals()) {
                newState = this.table.get(i, t);
                if (newState != null) {
                    out.print(newState);
                }
                out.print("\t");
            }
            for (AssemblyNonTerminal nt : this.grammar.nonTerminals()) {
                newState = this.table.get(i, nt);
                if (newState != null) {
                    out.print(newState);
                }
                out.print("\t");
            }
            out.println();
        }
    }

    public void printExtendedGrammar(PrintStream out) {
        out.println("\nExtended Grammar:");
        this.extendedGrammar.print(out);
    }

    public void printGeneralFF(PrintStream out) {
        out.println("\nGeneral FF:");
        this.ff.print(out);
    }

    public void printExtendedFF(PrintStream out) {
        out.println("\nExtended FF:");
        this.extff.print(out);
    }

    public void printMergers(PrintStream out) {
        out.println("\nMergers:");
        for (Map.Entry<MergeKey, MergeValue> ent : this.mergers.entrySet()) {
            out.print(ent.getKey().finalState + "\t");
            out.print(String.valueOf(ent.getKey().prod) + "\t");
            out.print(String.valueOf(ent.getValue().extProds) + "\t");
            out.print(String.valueOf(ent.getValue().follow) + "\n");
        }
    }

    public void printParseTable(PrintStream out) {
        out.println("\nParse Table:");
        out.print("State\t");
        for (AssemblyTerminal t : this.grammar.terminals()) {
            out.print(String.valueOf(t) + "\t");
        }
        for (AssemblyNonTerminal nt : this.grammar.nonTerminals()) {
            out.print(String.valueOf(nt) + "\t");
        }
        out.println();
        for (int i = 0; i < this.states.size(); ++i) {
            out.print(i + "\t");
            for (AssemblyTerminal t : this.grammar.terminals()) {
                out.print(StringUtils.join(this.actions.get(i, t), (String)"/"));
                out.print("\t");
            }
            for (AssemblyNonTerminal nt : this.grammar.nonTerminals()) {
                out.print(StringUtils.join(this.actions.get(i, nt), (String)"/"));
                out.print("\t");
            }
            out.println();
        }
    }

    public void printStuff(PrintStream out) {
        this.printGrammar(out);
        this.printGeneralFF(out);
        this.printLR0States(out);
        this.printLR0TransitionTable(out);
        this.printExtendedGrammar(out);
        this.printExtendedFF(out);
        this.printMergers(out);
        this.printParseTable(out);
    }

    public AssemblyGrammar getGrammar() {
        return this.grammar;
    }

    protected static class MergeKey
    implements Comparable<MergeKey> {
        int finalState;
        AssemblyProduction prod;

        protected MergeKey(int finalState, AssemblyProduction prod) {
            this.finalState = finalState;
            this.prod = prod;
        }

        public int hashCode() {
            int result = 0;
            result += this.finalState;
            result *= 31;
            return result += this.prod.hashCode();
        }

        public boolean equals(Object that) {
            if (!(that instanceof MergeKey)) {
                return false;
            }
            MergeKey mk = (MergeKey)that;
            if (this.finalState != mk.finalState) {
                return false;
            }
            return this.prod.equals(mk.prod);
        }

        @Override
        public int compareTo(MergeKey that) {
            int result = this.finalState - that.finalState;
            if (result != 0) {
                return result;
            }
            result = this.prod.compareTo(that.prod);
            if (result != 0) {
                return result;
            }
            return 0;
        }
    }

    protected static class MergeValue {
        Set<Integer> extProds = new TreeSet<Integer>();
        Set<AssemblyTerminal> follow = new TreeSet<AssemblyTerminal>();

        protected MergeValue() {
        }

        protected void merge(int extProdNum, Collection<AssemblyTerminal> more) {
            this.extProds.add(extProdNum);
            this.follow.addAll(more);
        }
    }
}

