/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Program;

public class CreateDataCmd
implements Command<Program> {
    private Address addr;
    private DataType newDataType;
    private String cmdName;
    private String msg;
    private DataUtilities.ClearDataMode clearMode;
    private boolean stackPointers;

    public CreateDataCmd(Address addr, boolean force, DataType dataType) {
        this(addr, dataType, false, force ? DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA : DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
    }

    public CreateDataCmd(Address addr, boolean force, boolean stackPointers, DataType dataType) {
        this(addr, dataType, stackPointers, force ? DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA : DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
    }

    public CreateDataCmd(Address addr, DataType dataType) {
        this(addr, dataType, false, false);
    }

    public CreateDataCmd(Address addr, DataType dataType, boolean isCycle, boolean stackPointers) {
        this(addr, dataType, stackPointers, isCycle ? DataUtilities.ClearDataMode.CLEAR_SINGLE_DATA : DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
    }

    public CreateDataCmd(Address addr, DataType dataType, boolean stackPointers, DataUtilities.ClearDataMode clearMode) {
        this.newDataType = dataType;
        this.addr = addr;
        this.stackPointers = stackPointers;
        this.clearMode = clearMode;
        this.cmdName = "Create " + dataType.getDisplayName();
    }

    public boolean applyTo(Program program) {
        try {
            DataUtilities.createData((Program)program, (Address)this.addr, (DataType)this.newDataType, (int)-1, (boolean)this.stackPointers, (DataUtilities.ClearDataMode)this.clearMode);
            return true;
        }
        catch (Exception e) {
            this.msg = e.getMessage();
            return false;
        }
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public String getName() {
        return this.cmdName;
    }
}

