/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.cmd.function.NewFunctionStackAnalysisCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StackVariableAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Stack";
    private static final String DESCRIPTION = "Creates stack variables for a function.";
    protected static final String MAX_THREAD_COUNT_OPTION_NAME = "Max Threads";
    protected static final String MAX_THREAD_COUNT_OPTION_DESCRIPTION = "Maximum threads for stack variable reference creation.  Too many threads causes thrashing in DB.";
    protected static final int MAX_THREAD_COUNT_OPTION_DEFAULT_VALUE = 2;
    protected int maxThreadCount = 2;
    private boolean doCreateLocalStackVars = true;
    private boolean doCreateStackParams = false;

    public StackVariableAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.after().after().after());
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        HashSet<Address> locations = new HashSet<Address>();
        this.findDefinedFunctions(program, set, locations, monitor);
        int locationCount = locations.size();
        monitor.initialize((long)locationCount);
        try {
            monitor.setMessage(this.getName());
            AddressSetView addressSetView = this.runParallelAddressAnalysis(program, locations, null, this.maxThreadCount, monitor);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"caught exception", (Throwable)e);
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public AddressSetView analyzeLocation(Program program, Address start, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        NewFunctionStackAnalysisCmd cmd = new NewFunctionStackAnalysisCmd((AddressSetView)new AddressSet(start, start), this.doCreateStackParams, this.doCreateLocalStackVars, false);
        cmd.applyTo((DomainObject)program, monitor);
        return EMPTY_ADDRESS_SET;
    }

    protected void findDefinedFunctions(Program program, AddressSetView set, Set<Address> locations, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Finding function locations...");
        long total = set.getNumAddresses();
        monitor.initialize(total);
        Iterator fiter = program.getFunctionManager().getFunctionsOverlapping(set);
        while (fiter.hasNext()) {
            monitor.checkCancelled();
            Function function = (Function)fiter.next();
            locations.add(function.getEntryPoint());
        }
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption("Create Local Variables", (Object)this.doCreateLocalStackVars, null, "Create Function Local stack variables and references");
        options.registerOption("Create Param Variables", (Object)this.doCreateStackParams, null, "Create Function Parameter stack variables and references");
        options.registerOption(MAX_THREAD_COUNT_OPTION_NAME, (Object)this.maxThreadCount, null, MAX_THREAD_COUNT_OPTION_DESCRIPTION);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.doCreateLocalStackVars = options.getBoolean("Create Local Variables", this.doCreateLocalStackVars);
        this.doCreateStackParams = options.getBoolean("Create Param Variables", this.doCreateStackParams);
        this.maxThreadCount = options.getInt(MAX_THREAD_COUNT_OPTION_NAME, this.maxThreadCount);
    }
}

