/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import docking.ActionContext;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.util.ProgramLocation;
import java.awt.Point;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import resources.Icons;

public class EventDisplayComponentProvider
extends ComponentProviderAdapter {
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JViewport viewport;
    private Point bottom = new Point(0, 10000);
    private DockingAction clearAction;

    public EventDisplayComponentProvider(PluginTool tool, String owner) {
        super(tool, "Plugin Event Display", owner);
        this.textArea = new JTextArea(10, 80);
        this.textArea.setEditable(true);
        this.scrollPane = new JScrollPane(this.textArea);
        this.viewport = this.scrollPane.getViewport();
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setTitle("Plugin Event Display");
        this.setVisible(true);
        this.createAction();
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void processEvent(PluginEvent event) {
        String date = new Date().toString();
        this.textArea.append(date + "     " + event.toString());
        this.printLocationDetails(event);
        this.textArea.append("\n");
        this.viewport.setViewPosition(this.bottom);
    }

    private void printLocationDetails(PluginEvent event) {
        if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent l = (ProgramLocationPluginEvent)event;
            ProgramLocation location = l.getLocation();
            this.textArea.append("\t" + location.toString());
            this.textArea.append("\n");
        }
    }

    private void createAction() {
        this.clearAction = new DockingAction("Clear Display", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                EventDisplayComponentProvider.this.clear();
            }
        };
        this.clearAction.markHelpUnnecessary();
        this.clearAction.setEnabled(true);
        Icon icon = Icons.CLEAR_ICON;
        this.clearAction.setToolBarData(new ToolBarData(icon));
        this.addLocalAction((DockingActionIf)this.clearAction);
    }

    private void clear() {
        this.textArea.setText("");
    }
}

