/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import ghidra.app.plugin.core.interpreter.InterpreterConsole;
import ghidra.app.services.ConsoleService;
import ghidra.util.task.TaskMonitor;
import java.io.OutputStream;
import java.io.PrintWriter;

public class ScriptControls {
    public static final ScriptControls NONE = new ScriptControls(null, null, false, TaskMonitor.DUMMY);
    private PrintWriter writer;
    private PrintWriter errorWriter;
    private boolean decorateOutput;
    private TaskMonitor monitor;

    public ScriptControls(PrintWriter writer, PrintWriter errorWriter, boolean decorateOutput, TaskMonitor monitor) {
        this.writer = writer;
        this.errorWriter = errorWriter;
        this.decorateOutput = decorateOutput;
        this.monitor = monitor;
    }

    public ScriptControls(PrintWriter writer, PrintWriter errorWriter, TaskMonitor monitor) {
        this(writer, errorWriter, false, monitor);
    }

    public ScriptControls(OutputStream stream, OutputStream errorStream, TaskMonitor monitor) {
        this(new PrintWriter(stream, true), new PrintWriter(errorStream, true), false, monitor);
    }

    public ScriptControls(ConsoleService console, TaskMonitor monitor) {
        this(console.getStdOut(), console.getStdErr(), monitor);
    }

    public ScriptControls(InterpreterConsole console, TaskMonitor monitor) {
        this(console.getOutWriter(), console.getErrWriter(), monitor);
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public boolean shouldDecorateOutput() {
        return this.decorateOutput;
    }

    public TaskMonitor getMonitor() {
        return this.monitor;
    }
}

