/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import java.awt.Component;
import java.util.Objects;
import javax.swing.KeyStroke;
import resources.Icons;

public class MakeProgramSelectionAction
extends DockingAction {
    private Plugin plugin;
    private Navigatable navigatable;
    private GhidraTable table;

    @Deprecated(forRemoval=true, since="10.2")
    public MakeProgramSelectionAction(String owner, GhidraTable table) {
        super("Make Selection", owner, KeyBindingType.SHARED);
        this.table = Objects.requireNonNull(table);
        this.init(null);
    }

    public MakeProgramSelectionAction(Navigatable navigatable, String owner, GhidraTable table) {
        this(navigatable, owner, table, null);
    }

    public MakeProgramSelectionAction(Navigatable navigatable, String owner, GhidraTable table, String menuGroup) {
        super("Make Selection", owner, KeyBindingType.SHARED);
        this.navigatable = Objects.requireNonNull(navigatable);
        this.table = Objects.requireNonNull(table);
        this.init(menuGroup);
    }

    public MakeProgramSelectionAction(Plugin plugin, GhidraTable table) {
        super("Make Selection", plugin.getName(), KeyBindingType.SHARED);
        this.plugin = Objects.requireNonNull(plugin);
        this.table = Objects.requireNonNull(table);
        this.init(null);
    }

    private void init(String menuGroup) {
        this.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, Icons.MAKE_SELECTION_ICON, menuGroup));
        this.setToolBarData(new ToolBarData(Icons.MAKE_SELECTION_ICON));
        this.setDescription("Make a program selection from the selected rows");
        this.setHelpLocation(new HelpLocation("Search", "Make_Selection"));
        this.initKeyStroke(null);
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }

    public boolean isEnabledForContext(ActionContext context) {
        Component component = context.getSourceComponent();
        if (component != this.table) {
            return false;
        }
        Program program = this.table.getProgram();
        if (program == null) {
            return false;
        }
        if (program.isClosed()) {
            return false;
        }
        int n = this.table.getSelectedRowCount();
        return n > 0;
    }

    public void actionPerformed(ActionContext context) {
        ProgramSelection selection = this.table.getProgramSelection();
        this.makeProgramSelection(selection, context);
    }

    protected void makeProgramSelection(ProgramSelection selection, ActionContext context) {
        if (selection.isEmpty()) {
            return;
        }
        if (this.navigatable != null) {
            Program program = this.table.getProgram();
            this.navigatable.goTo(program, new ProgramLocation(program, selection.getMinAddress()));
            this.navigatable.setSelection(selection);
            this.navigatable.requestFocus();
            return;
        }
        if (this.plugin == null) {
            throw new IllegalStateException("The Make Program Selection action cannot be used without a plugin or a navigatable unless the client overrides this method");
        }
        ProgramSelectionPluginEvent event = new ProgramSelectionPluginEvent(this.plugin.getName(), selection, this.table.getProgram());
        this.plugin.firePluginEvent((PluginEvent)event);
    }
}

