/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.impl;

import java.io.IOException;
import java.io.InputStream;
import net.sf.sevenzipjbinding.ISequentialInStream;
import net.sf.sevenzipjbinding.SevenZipException;

public class InputStreamSequentialInStream
implements ISequentialInStream {
    private final InputStream inputStream;

    public InputStreamSequentialInStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int read(byte[] byArray) throws SevenZipException {
        if (byArray.length == 0) {
            return 0;
        }
        try {
            int n = this.inputStream.read(byArray);
            if (n < 0) {
                return 0;
            }
            return n;
        }
        catch (IOException iOException) {
            throw new SevenZipException("Error reading " + byArray.length + " bytes out of InputStream", iOException);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

