/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.GenericAddress;
import ghidra.program.model.address.GenericAddressSpace;
import java.math.BigInteger;

public interface AddressSpace
extends Comparable<AddressSpace> {
    public static final int TYPE_CONSTANT = 0;
    public static final int TYPE_RAM = 1;
    public static final int TYPE_CODE = 2;
    public static final int TYPE_UNIQUE = 3;
    public static final int TYPE_REGISTER = 4;
    public static final int TYPE_STACK = 5;
    public static final int TYPE_JOIN = 6;
    public static final int TYPE_OTHER = 7;
    public static final int TYPE_SYMBOL = 9;
    public static final int TYPE_EXTERNAL = 10;
    public static final int TYPE_VARIABLE = 11;
    public static final int TYPE_DELETED = 13;
    public static final int TYPE_UNKNOWN = 14;
    public static final int TYPE_NONE = 15;
    public static final int TYPE_IPTR_CONSTANT = 0;
    public static final int TYPE_IPTR_INTERNAL = 3;
    public static final int TYPE_IPTR_SPACEBASE = 5;
    public static final int ID_SIZE_MASK = 112;
    public static final int ID_SIZE_SHIFT = 4;
    public static final int ID_TYPE_MASK = 15;
    public static final int ID_UNIQUE_SHIFT = 7;
    public static final AddressSpace OTHER_SPACE = new GenericAddressSpace("OTHER", 64, 7, 1);
    public static final AddressSpace EXTERNAL_SPACE = new GenericAddressSpace("EXTERNAL", 32, 10, 0);
    public static final AddressSpace VARIABLE_SPACE = new GenericAddressSpace("VARIABLE", 32, 11, 0);
    public static final AddressSpace HASH_SPACE = new GenericAddressSpace("HASH", 60, 14, 0);
    public static final AddressSpace DEFAULT_REGISTER_SPACE = new GenericAddressSpace("REGISTER", 32, 4, 0);

    public String getName();

    public int getSpaceID();

    public int getSize();

    public int getAddressableUnitSize();

    public long getAddressableWordOffset(long var1);

    public int getPointerSize();

    public int getType();

    public int getUnique();

    public Address getAddress(String var1) throws AddressFormatException;

    public Address getAddress(String var1, boolean var2) throws AddressFormatException;

    public Address getAddress(long var1) throws AddressOutOfBoundsException;

    public Address getAddress(long var1, boolean var3) throws AddressOutOfBoundsException;

    public Address getTruncatedAddress(long var1, boolean var3);

    public Address getAddressInThisSpaceOnly(long var1) throws AddressOutOfBoundsException;

    public long truncateOffset(long var1);

    public long truncateAddressableWordOffset(long var1);

    public Address getOverlayAddress(Address var1);

    public long subtract(Address var1, Address var2);

    public Address subtractWrap(Address var1, long var2);

    public Address subtractWrapSpace(Address var1, long var2);

    public Address subtractNoWrap(Address var1, long var2) throws AddressOverflowException;

    public Address subtract(Address var1, long var2);

    public Address addWrap(Address var1, long var2);

    public Address addWrapSpace(Address var1, long var2);

    public Address addNoWrap(Address var1, long var2) throws AddressOverflowException;

    public Address addNoWrap(GenericAddress var1, BigInteger var2) throws AddressOverflowException;

    public Address add(Address var1, long var2) throws AddressOutOfBoundsException;

    public boolean isValidRange(long var1, long var3);

    public boolean isSuccessor(Address var1, Address var2);

    public Address getMaxAddress();

    public Address getMinAddress();

    public AddressSpace getPhysicalSpace();

    public long makeValidOffset(long var1) throws AddressOutOfBoundsException;

    public boolean isMemorySpace();

    public boolean isLoadedMemorySpace();

    public boolean isNonLoadedMemorySpace();

    public boolean isRegisterSpace();

    public boolean isVariableSpace();

    public boolean isStackSpace();

    public boolean isHashSpace();

    public boolean isExternalSpace();

    public boolean isUniqueSpace();

    public boolean isConstantSpace();

    public boolean hasMappedRegisters();

    public boolean showSpaceName();

    public boolean isOverlaySpace();

    public boolean hasSignedOffset();

    public static boolean isValidName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c != ':' && c > ' ') continue;
            return false;
        }
        return true;
    }
}

