/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.OverlapCodeSubModel;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.LinkedList;

public class SingleEntSubIterator
implements CodeBlockIterator {
    private CodeBlock nextSub = null;
    private AddressSetView addrSet = null;
    private OverlapCodeSubModel model = null;
    private LinkedList<CodeBlock> subList = new LinkedList();
    private CodeBlockIterator modelMIter = null;
    private TaskMonitor monitor;

    public SingleEntSubIterator(OverlapCodeSubModel model, TaskMonitor monitor) throws CancelledException {
        this.model = model;
        this.monitor = monitor != null ? monitor : TaskMonitor.DUMMY;
        this.addrSet = null;
        this.nextSub = null;
        this.modelMIter = model.getModelM().getCodeBlocks(monitor);
    }

    public SingleEntSubIterator(OverlapCodeSubModel model, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        this.model = model;
        this.monitor = monitor;
        monitor.setIndeterminate(true);
        this.addrSet = set;
        this.nextSub = null;
        this.modelMIter = model.getModelM().getCodeBlocksContaining(set, monitor);
    }

    @Override
    public boolean hasNext() throws CancelledException {
        if (this.nextSub != null) {
            return true;
        }
        if (!this.subList.isEmpty()) {
            this.nextSub = this.subList.removeFirst();
            return true;
        }
        if (this.modelMIter.hasNext()) {
            CodeBlock modelMSub = this.modelMIter.next();
            Address[] entPts = modelMSub.getStartAddresses();
            for (int i = 0; i < entPts.length; ++i) {
                CodeBlock sub = this.model.getCodeBlockAt(entPts[i], this.monitor);
                if (sub == null) continue;
                if (this.monitor.isCancelled()) {
                    return false;
                }
                if (this.addrSet != null && !sub.intersects(this.addrSet)) continue;
                this.subList.add(sub);
            }
            if (!this.subList.isEmpty()) {
                this.nextSub = this.subList.removeFirst();
                return true;
            }
        }
        return false;
    }

    @Override
    public CodeBlock next() throws CancelledException {
        if (this.nextSub == null) {
            this.hasNext();
        }
        CodeBlock retSub = this.nextSub;
        this.nextSub = null;
        return retSub;
    }
}

