/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.util.SystemUtilities;

public class InstructionBlockFlow
implements Comparable<InstructionBlockFlow> {
    final Address address;
    final Address flowFrom;
    final Type type;

    public InstructionBlockFlow(Address address, Address flowFrom, Type type) {
        this.address = address;
        this.flowFrom = flowFrom;
        this.type = type;
    }

    public Address getDestinationAddress() {
        return this.address;
    }

    public Address getFlowFromAddress() {
        return this.flowFrom;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return this.address != null ? this.address.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InstructionBlockFlow)) {
            return false;
        }
        InstructionBlockFlow other = (InstructionBlockFlow)obj;
        return this.type == other.type && SystemUtilities.isEqual((Object)this.address, (Object)other.address) && SystemUtilities.isEqual((Object)this.flowFrom, (Object)other.flowFrom);
    }

    @Override
    public int compareTo(InstructionBlockFlow o) {
        return SystemUtilities.compareTo((Comparable)this.address, (Comparable)o.address);
    }

    public String toString() {
        return String.valueOf((Object)this.type) + " " + String.valueOf(this.flowFrom) + "->" + String.valueOf(this.address);
    }

    public static enum Type {
        PRIORITY,
        BRANCH,
        CALL_FALLTHROUGH,
        CALL;

    }
}

