/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PcodeFieldLocation
extends ProgramLocation {
    private List<String> pcodeStrings;

    public PcodeFieldLocation(Program program, Address addr, List<String> pcodeStrings, int row, int charOffset) {
        super(program, addr, row, 0, charOffset);
        this.pcodeStrings = pcodeStrings;
    }

    public PcodeFieldLocation() {
    }

    public List<String> getPcodeStrings() {
        return Collections.unmodifiableList(this.pcodeStrings);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pcodeStrings == null ? 0 : this.pcodeStrings.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PcodeFieldLocation other = (PcodeFieldLocation)obj;
        return !(this.pcodeStrings == null ? other.pcodeStrings != null : !this.pcodeStrings.equals(other.pcodeStrings));
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putStrings("_PCODE_STRINGS", this.pcodeStrings.toArray(new String[this.pcodeStrings.size()]));
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        String[] strings = obj.getStrings("_PCODE_STRINGS", new String[0]);
        this.pcodeStrings = new ArrayList<String>(strings.length);
        for (String string : strings) {
            this.pcodeStrings.add(string);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", Pcode sample: " + this.getPcodeSample();
    }

    private String getPcodeSample() {
        if (this.pcodeStrings.size() == 0) {
            return "<no pcode>";
        }
        return this.pcodeStrings.get(0);
    }
}

