/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.util;

import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelatorAddressRestrictionPreference;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;

public abstract class VTAbstractProgramCorrelatorFactory
implements VTProgramCorrelatorFactory {
    private final VTProgramCorrelatorAddressRestrictionPreference addressRestrictionPreference;

    protected VTAbstractProgramCorrelatorFactory(VTProgramCorrelatorAddressRestrictionPreference addressRestrictionPreference) {
        this.addressRestrictionPreference = addressRestrictionPreference;
    }

    protected VTAbstractProgramCorrelatorFactory() {
        this(VTProgramCorrelatorAddressRestrictionPreference.PREFER_RESTRICTING_ACCEPTED_MATCHES);
    }

    @Override
    public abstract String getName();

    @Override
    public abstract String getDescription();

    public String toString() {
        return this.getName() + ": " + this.getDescription();
    }

    @Override
    public VTProgramCorrelatorAddressRestrictionPreference getAddressRestrictionPreference() {
        return this.addressRestrictionPreference;
    }

    @Override
    public VTOptions createDefaultOptions() {
        return new VTOptions(this.getName());
    }

    @Override
    public final VTProgramCorrelator createCorrelator(Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, VTOptions options) {
        return this.doCreateCorrelator(sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options == null ? this.createDefaultOptions() : (VTOptions)options.copy());
    }

    protected abstract VTProgramCorrelator doCreateCorrelator(Program var1, AddressSetView var2, Program var3, AddressSetView var4, VTOptions var5);

    @Override
    @Deprecated
    public VTProgramCorrelator createCorrelator(ServiceProvider serviceProvider, Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, VTOptions options) {
        return this.doCreateCorrelator(sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options);
    }
}

