/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.impliedmatches;

import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.feature.vt.gui.provider.impliedmatches.AssociationStub;
import ghidra.feature.vt.gui.provider.impliedmatches.ImpliedMatchWrapperRowObject;
import ghidra.program.model.address.Address;

class MatchMapper
implements VTMatch {
    private final ImpliedMatchWrapperRowObject rowObject;
    private final AssociationStub assocationStub;

    MatchMapper(ImpliedMatchWrapperRowObject rowObject) {
        this.rowObject = rowObject;
        this.assocationStub = new AssociationStub(rowObject.getSourceAddress(), rowObject.getDestinationAddress(), rowObject.getAssociationType());
    }

    @Override
    public VTAssociation getAssociation() {
        VTMatch existingMatch = this.rowObject.getMatch();
        if (existingMatch != null) {
            return existingMatch.getAssociation();
        }
        return this.assocationStub;
    }

    @Override
    public VTScore getConfidenceScore() {
        return this.rowObject.getConfidenceScore();
    }

    @Override
    public int getDestinationLength() {
        return this.rowObject.getDestinationLength();
    }

    @Override
    public VTMatchSet getMatchSet() {
        return this.rowObject.getMatchSet();
    }

    @Override
    public VTScore getSimilarityScore() {
        return this.rowObject.getSimilarityScore();
    }

    @Override
    public Address getSourceAddress() {
        return this.rowObject.getSourceAddress();
    }

    @Override
    public Address getDestinationAddress() {
        return this.rowObject.getDestinationAddress();
    }

    @Override
    public int getSourceLength() {
        return this.rowObject.getSourceLength();
    }

    @Override
    public VTMatchTag getTag() {
        return this.rowObject.getTag();
    }

    @Override
    public void setTag(VTMatchTag tag) {
    }
}

