/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WeakStore<T> {
    protected ReferenceQueue<T> refQueue = new ReferenceQueue();
    private Link<T> first;
    private Link<T> last;
    private int size = 0;

    public synchronized int size() {
        this.processQueue();
        return this.size;
    }

    public synchronized List<T> getValues() {
        this.processQueue();
        ArrayList values = new ArrayList();
        Link<T> l = this.first;
        while (l != null) {
            Object value = l.get();
            if (value != null) {
                values.add(value);
            }
            l = l.nextLink;
        }
        return values;
    }

    public synchronized void add(T value) {
        Objects.requireNonNull(value);
        this.processQueue();
        Link<T> newLink = new Link<T>(this.last, value, null, this.refQueue);
        if (this.last == null) {
            this.first = newLink;
        } else {
            this.last.nextLink = newLink;
        }
        this.last = newLink;
        ++this.size;
    }

    private void processQueue() {
        Link ref;
        while ((ref = (Link)this.refQueue.poll()) != null) {
            this.remove(ref);
        }
    }

    private void remove(Link<T> link) {
        if (link.previousLink == null) {
            this.first = link.nextLink;
        } else {
            link.previousLink.nextLink = link.nextLink;
        }
        if (link.nextLink == null) {
            this.last = link.previousLink;
        } else {
            link.nextLink.previousLink = link.previousLink;
        }
        --this.size;
    }

    private static class Link<T>
    extends WeakReference<T> {
        private Link<T> nextLink;
        private Link<T> previousLink;

        public Link(Link<T> previous, T value, Link<T> next, ReferenceQueue<T> refQueue) {
            super(value, refQueue);
            this.nextLink = next;
            this.previousLink = previous;
        }
    }
}

