/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.Msg;
import ghidra.util.exception.NoValueException;
import ghidra.util.graph.DirectedGraph;
import ghidra.util.graph.Edge;
import ghidra.util.graph.GraphIterator;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.Path;
import ghidra.util.graph.Vertex;
import ghidra.util.graph.attributes.DoubleAttribute;
import ghidra.util.graph.attributes.IntegerAttribute;
import ghidra.util.graph.attributes.ObjectAttribute;
import ghidra.util.graph.attributes.StringAttribute;
import java.util.Vector;

@Deprecated(forRemoval=true, since="10.2")
public class Dominator
extends DirectedGraph {
    private IntegerAttribute<Vertex> vertexColor;
    private ObjectAttribute<Vertex> callingParent;
    private DoubleAttribute<Vertex> vertexWeight;
    private DoubleAttribute<Edge> edgeWeight;
    private StringAttribute<Vertex> vertexType;
    private Path paths = new Path();
    private static final int white = 0;
    private static final int gray = 1;

    public Dominator(int vertexCapacity, int edgeCapacity) {
        super(vertexCapacity, edgeCapacity);
        this.vertexColor = (IntegerAttribute)this.vertexAttributes().createAttribute("Color", "INTEGER_TYPE");
        this.callingParent = (ObjectAttribute)this.vertexAttributes().createAttribute("Calling Parent", "OBJECT_TYPE");
        this.vertexWeight = (DoubleAttribute)this.vertexAttributes().createAttribute("Weight", "DOUBLE_TYPE");
        this.edgeWeight = (DoubleAttribute)this.edgeAttributes().createAttribute("Weight", "DOUBLE_TYPE");
        this.vertexType = (StringAttribute)this.vertexAttributes().createAttribute("Type", "STRING_TYPE");
    }

    public Dominator() {
        this(101, 101);
    }

    public Dominator(DirectedGraph cg) {
        this();
        GraphIterator<Vertex> vertexIter = cg.vertexIterator();
        while (vertexIter.hasNext()) {
            Vertex next = vertexIter.next();
            this.add(next);
            this.setColor(next, 0);
        }
        GraphIterator<Edge> edgeIter = cg.edgeIterator();
        while (edgeIter.hasNext()) {
            Edge next = edgeIter.next();
            if (next.to().equals(next.from())) continue;
            this.add(next);
        }
    }

    public Vertex backTrack(Vertex v) {
        return this.getCallingParent(v);
    }

    public Vertex getDominator(Vertex v) {
        Vector pathSet = this.allPathsContaining(v);
        if (pathSet.isEmpty()) {
            return v;
        }
        Vector path = (Vector)pathSet.firstElement();
        return this.allPathsContain(pathSet, v, path);
    }

    public Vector allPathsContaining(Vertex v) {
        int maxsize = 0;
        Vector pathSet = new Vector();
        for (int i = 0; i < this.paths.size(); ++i) {
            Vector tmpPath = (Vector)this.paths.elementAt(i);
            if (!tmpPath.contains(v)) continue;
            if (tmpPath.size() > maxsize) {
                maxsize = tmpPath.size();
                pathSet.add(0, tmpPath);
                continue;
            }
            pathSet.add(this.paths.elementAt(i));
        }
        return pathSet;
    }

    public Vertex allPathsContain(Vector pathSet, Vertex v, Vector path) {
        int candIndex = path.indexOf(v) - 1;
        if (candIndex < 0) {
            return v;
        }
        Vertex candidate = (Vertex)path.elementAt(candIndex--);
        boolean flag = false;
        while (!flag) {
            flag = true;
            for (int i = 0; i < pathSet.size(); ++i) {
                if (((Vector)pathSet.elementAt(i)).contains(candidate)) continue;
                flag = false;
            }
            if (flag) continue;
            candidate = (Vertex)path.elementAt(candIndex--);
        }
        return candidate;
    }

    public Vertex goToNextWhiteChild(Vertex v) {
        if (this.hasWhiteChild(v)) {
            for (Vertex nextChild : this.getChildren(v)) {
                if (this.getColor(nextChild) != 0) continue;
                this.setCallingParent(nextChild, v);
                return nextChild;
            }
        }
        return null;
    }

    public DirectedGraph setDominance() {
        Vertex[] roots = this.getSources();
        int i = 0;
        if (roots.length != 1) {
            if (roots.length > 1) {
                Msg.error((Object)this, (Object)"this should not print because it means you have more than 1 root");
            } else if (roots.length == 0) {
                Msg.error((Object)this, (Object)"You need a root,no root provided");
            } else {
                Msg.error((Object)this, (Object)("Your number of roots is " + roots.length));
            }
            return null;
        }
        Vertex v = roots[0];
        Vector singlePath = new Vector();
        while (this.hasWhiteChild(v) || !v.equals(roots[0])) {
            v = this.addToPaths(v, singlePath);
            if (!this.paths.containsInSomeElement(singlePath)) {
                this.paths.add(i, singlePath);
                singlePath = new Vector();
                for (int j = 0; j < ((Vector)this.paths.elementAt(i)).size(); ++j) {
                    singlePath.add(j, ((Vector)this.paths.elementAt(i)).elementAt(j));
                }
                ++i;
            }
            this.whitenChildren(v);
            v = this.backTrack(v);
            singlePath.removeElementAt(singlePath.size() - 1);
        }
        return this.getDominanceGraph();
    }

    public DirectedGraph getDominanceGraph() {
        Dominator dom = new Dominator();
        GraphIterator<Vertex> it = this.vertexIterator();
        if (this.numVertices() == 1) {
            dom.add(this.getSources()[0]);
            return dom;
        }
        while (it.hasNext()) {
            Vertex next = it.next();
            if (this.getSources()[0].equals(next)) continue;
            Vertex parent = this.getDominator(next);
            dom.add(next);
            dom.add(parent);
            dom.add(new Edge(parent, next));
        }
        return dom;
    }

    public Vertex addToPaths(Vertex v, Vector singlePath) {
        int i = singlePath.size();
        this.setColor(v, 1);
        if (!singlePath.contains(v)) {
            singlePath.add(i++, v);
        }
        while (this.hasWhiteChild(v)) {
            v = this.goToNextWhiteChild(v);
            this.setColor(v, 1);
            singlePath.add(i++, v);
        }
        return v;
    }

    private boolean hasWhiteChild(Vertex v) {
        boolean flag = false;
        for (Vertex nextChild : this.getChildren(v)) {
            if (this.getColor(nextChild) != 0) continue;
            flag = true;
        }
        return flag;
    }

    public void whitenChildren(Vertex v) {
        for (Vertex next : this.getChildren(v)) {
            if (!this.getCallingParent(next).equals(v)) continue;
            this.setColor(next, 0);
        }
    }

    public void setColor(Vertex v, int color) {
        if (this.contains(v)) {
            this.vertexColor.setValue(v, color);
        }
    }

    public int getColor(Vertex v) {
        try {
            return this.vertexColor.getValue(v);
        }
        catch (NoValueException exc) {
            return 0;
        }
    }

    public void setCallingParent(Vertex v, Vertex parent) {
        if (this.contains(v)) {
            this.callingParent.setValue(v, parent);
        }
    }

    public Vertex getCallingParent(Vertex v) {
        return (Vertex)this.callingParent.getValue(v);
    }

    public void setType(Vertex v, String type) {
        if (this.contains(v)) {
            this.vertexType.setValue(v, type);
        }
    }

    public String getType(KeyedObject o) {
        String type = null;
        type = this.vertexType.getValue(o);
        return type;
    }

    public void setWeight(Vertex v, double weight) {
        if (this.contains(v)) {
            this.vertexWeight.setValue(v, weight);
        }
    }

    public double getWeight(Vertex v) {
        try {
            return this.vertexWeight.getValue(v);
        }
        catch (NoValueException exc) {
            return 0.0;
        }
    }

    public void setWeight(Edge e, double weight) {
        if (this.contains(e)) {
            this.edgeWeight.setValue(e, weight);
        }
    }

    public double getWeight(Edge e) {
        try {
            return this.edgeWeight.getValue(e);
        }
        catch (NoValueException exc) {
            return 0.0;
        }
    }
}

