/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.sys;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.pcode.emu.sys.EmuInvalidSystemCallException;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface EmuSyscallLibrary<T>
extends PcodeUseropLibrary<T> {
    public static final String SYSCALL_SPACE_NAME = "syscall";
    public static final String SYSCALL_CONVENTION_NAME = "syscall";

    public static Map<Long, String> loadSyscallNumberMap(String dataFileName) throws IOException {
        String line;
        ResourceFile mapFile = Application.findDataFileInAnyModule((String)dataFileName);
        if (mapFile == null) {
            throw new FileNotFoundException("Cannot find syscall number map: " + dataFileName);
        }
        HashMap<Long, String> result = new HashMap<Long, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(mapFile.getInputStream()));
        while (null != (line = reader.readLine())) {
            if ((line = line.strip()).startsWith("#")) continue;
            String[] parts = line.split("\\s+");
            if (parts.length != 2) {
                throw new IOException("Badly formatted syscall number map: " + dataFileName + ". Line: " + line);
            }
            try {
                result.put(Long.parseLong(parts[0]), parts[1]);
            }
            catch (NumberFormatException e) {
                throw new IOException("Badly formatted syscall number map: " + dataFileName, e);
            }
        }
        return result;
    }

    public static Map<Long, Function> loadSyscallFunctionMap(Program program) {
        Symbol s;
        AddressSpace space = program.getAddressFactory().getAddressSpace("syscall");
        if (space == null) {
            throw new IllegalStateException("No syscall address space in program. Please analyze the syscalls first.");
        }
        HashMap<Long, Function> result = new HashMap<Long, Function>();
        SymbolIterator sit = program.getSymbolTable().getSymbolIterator(space.getMinAddress(), true);
        while (sit.hasNext() && (s = sit.next()).getAddress().getAddressSpace() == space) {
            if (s.getSymbolType() != SymbolType.FUNCTION) continue;
            result.put(s.getAddress().getOffset(), (Function)s.getObject());
        }
        return result;
    }

    public static Map<Long, String> loadSyscallNumberMap(Program program) {
        return EmuSyscallLibrary.loadSyscallFunctionMap(program).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Function)e.getValue()).getName()));
    }

    public static Map<Long, PrototypeModel> loadSyscallConventionMap(Program program) {
        return EmuSyscallLibrary.loadSyscallFunctionMap(program).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Function)e.getValue()).getCallingConvention()));
    }

    default public PcodeUseropLibrary.PcodeUseropDefinition<T> getSyscallUserop() {
        return new SyscallPcodeUseropDefinition(this);
    }

    public long readSyscallNumber(PcodeExecutorState<T> var1, PcodeExecutorStatePiece.Reason var2);

    public boolean handleError(PcodeExecutor<T> var1, PcodeExecutionException var2);

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    default public void syscall(@AnnotatedPcodeUseropLibrary.OpExecutor PcodeExecutor<T> executor, @AnnotatedPcodeUseropLibrary.OpLibrary PcodeUseropLibrary<T> library) {
        block3: {
            long syscallNumber = this.readSyscallNumber(executor.getState(), executor.getReason());
            EmuSyscallDefinition<T> syscall = this.getSyscalls().get(syscallNumber);
            if (syscall == null) {
                throw new EmuInvalidSystemCallException(syscallNumber);
            }
            try {
                syscall.invoke(executor, library);
            }
            catch (PcodeExecutionException e) {
                if (this.handleError(executor, e)) break block3;
                throw e;
            }
        }
    }

    public Map<Long, EmuSyscallDefinition<T>> getSyscalls();

    public static final class SyscallPcodeUseropDefinition<T>
    implements PcodeUseropLibrary.PcodeUseropDefinition<T> {
        private final EmuSyscallLibrary<T> syslib;

        public SyscallPcodeUseropDefinition(EmuSyscallLibrary<T> syslib) {
            this.syslib = syslib;
        }

        public String getName() {
            return "syscall";
        }

        public int getInputCount() {
            return 0;
        }

        public void execute(PcodeExecutor<T> executor, PcodeUseropLibrary<T> library, Varnode outVar, List<Varnode> inVars) {
            this.syslib.syscall(executor, library);
        }

        public boolean isFunctional() {
            return false;
        }

        public boolean hasSideEffects() {
            return true;
        }

        public boolean modifiesContext() {
            return false;
        }

        public boolean canInlinePcode() {
            return false;
        }

        public Class<?> getOutputType() {
            return Void.TYPE;
        }

        public PcodeUseropLibrary<?> getDefiningLibrary() {
            return this.syslib;
        }

        public Method getJavaMethod() {
            try {
                return this.syslib.getClass().getMethod("syscall", PcodeExecutor.class, PcodeUseropLibrary.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static interface EmuSyscallDefinition<T> {
        public void invoke(PcodeExecutor<T> var1, PcodeUseropLibrary<T> var2);
    }
}

