/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.ScriptPathsPropertyEditor;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.debug.spi.tracermi.TraceRmiLaunchOpinion;
import ghidra.framework.Application;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.util.HelpLocation;
import java.util.stream.Stream;

public abstract class AbstractTraceRmiLaunchOpinion
implements TraceRmiLaunchOpinion {
    @Override
    public void registerOptions(Options options) {
        String pluginName = PluginUtils.getPluginNameFromClass(TraceRmiLauncherServicePlugin.class);
        options.registerOption("Script Paths", OptionType.STRING_TYPE, (Object)"", new HelpLocation(pluginName, "options"), "Paths to search for user-created debugger launchers", () -> new ScriptPathsPropertyEditor());
    }

    @Override
    public boolean requiresRefresh(String optionName) {
        return "Script Paths".equals(optionName);
    }

    protected Stream<ResourceFile> getModuleScriptPaths() {
        return Application.findModuleSubDirectories((String)"data/debugger-launchers").stream();
    }

    protected Stream<ResourceFile> getUserScriptPaths(PluginTool tool) {
        ToolOptions options = tool.getOptions("Debugger");
        String scriptPaths = options.getString("Script Paths", "");
        return scriptPaths.lines().filter(d -> !d.isBlank()).map(ResourceFile::new);
    }

    protected Stream<ResourceFile> getScriptPaths(PluginTool tool) {
        return Stream.concat(this.getModuleScriptPaths(), this.getUserScriptPaths(tool));
    }
}

